/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.tdh.aimatch.service.impl;

import com.tydic.nbchat.train.api.bo.eums.StateEnum;
import com.tydic.nbchat.train.core.service.tdh.aimatch.service.TemplateService;
import com.tydic.nbchat.train.mapper.TdhTemplateMapper;
import com.tydic.nbchat.train.mapper.po.TdhTemplate;
import com.tydic.nbchat.train.mapper.po.TdhTemplateSelectCondition;
import com.tydic.nicc.common.eums.EntityValidType;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TemplateServiceImpl
implements TemplateService {
    private static final Logger log = LoggerFactory.getLogger(TemplateServiceImpl.class);
    @Resource
    private TdhTemplateMapper tdhTemplateMapper;

    @Override
    public List<TdhTemplate> findCandidateTemplates(String tenantCode, String userId, String userVipFlag) {
        log.info("\u67e5\u8be2\u5019\u9009\u6a21\u677f - tenantCode: {}, userId: {}, userVipFlag: {}", new Object[]{tenantCode, userId, userVipFlag});
        List templates = this.tdhTemplateMapper.findCandidateTemplates(tenantCode, userId, userVipFlag);
        log.info("\u67e5\u8be2\u5230\u5019\u9009\u6a21\u677f\u6570\u91cf: {}", (Object)templates.size());
        return templates;
    }

    @Override
    public String getRandomTemplateId(String tenantCode, String userId, String userVipFlag) {
        log.info("\u83b7\u53d6\u968f\u673a\u6a21\u677fID - tenantCode: {}, userId: {}, userVipFlag: {}", new Object[]{tenantCode, userId, userVipFlag});
        String templateId = this.tdhTemplateMapper.findRandomTemplateId(tenantCode, userId);
        log.info("\u968f\u673a\u6a21\u677fID: {}", (Object)templateId);
        return templateId;
    }

    @Override
    public List<TdhTemplate> findCandidateTemplatesByLayout(String tenantCode, String userId, String userVipFlag, String layoutId) {
        log.info("\u6839\u636e\u5e03\u5c40ID\u67e5\u8be2\u5019\u9009\u6a21\u677f - tenantCode: {}, userId: {}, userVipFlag: {}, layoutId: {}", new Object[]{tenantCode, userId, userVipFlag, layoutId});
        if (StringUtils.isBlank((CharSequence)layoutId)) {
            log.info("\u5e03\u5c40ID\u4e3a\u7a7a\uff0c\u4f7f\u7528\u9ed8\u8ba4\u67e5\u8be2\u65b9\u5f0f");
            return this.findCandidateTemplates(tenantCode, userId, userVipFlag);
        }
        TdhTemplateSelectCondition condition = new TdhTemplateSelectCondition();
        condition.setLayoutId(layoutId);
        condition.setIsValid(EntityValidType.NORMAL.getCode());
        condition.setTpState(StateEnum.STATE.AVAILABLE.getCode());
        if (StringUtils.isNotBlank((CharSequence)userVipFlag)) {
            condition.setVipFlag(userVipFlag);
        }
        List templates = this.tdhTemplateMapper.findTmplLayoutRels(condition);
        log.info("\u6839\u636e\u5e03\u5c40ID\u67e5\u8be2\u5230\u6a21\u677f\u6570\u91cf: {}", (Object)templates.size());
        return templates;
    }

    @Override
    public boolean isTemplateExists(String templateId, String tenantCode, String userId, String userVipFlag) {
        log.info("\u68c0\u67e5\u6a21\u677f\u662f\u5426\u5b58\u5728 - templateId: {}, tenantCode: {}, userId: {}, userVipFlag: {}", new Object[]{templateId, tenantCode, userId, userVipFlag});
        if (StringUtils.isBlank((CharSequence)templateId)) {
            return false;
        }
        int count = this.tdhTemplateMapper.checkTemplateExists(templateId, tenantCode, userId, userVipFlag);
        boolean exists = count > 0;
        log.info("\u6a21\u677f\u5b58\u5728\u6027\u68c0\u67e5\u7ed3\u679c - templateId: {}, exists: {}", (Object)templateId, (Object)exists);
        return exists;
    }

    @Override
    public String getRandomTemplateIdByLayout(String tenantCode, String userId, String userVipFlag, String layoutId) {
        log.info("\u6839\u636e\u5e03\u5c40ID\u968f\u673a\u83b7\u53d6\u6a21\u677fID - tenantCode: {}, userId: {}, userVipFlag: {}, layoutId: {}", new Object[]{tenantCode, userId, userVipFlag, layoutId});
        if (StringUtils.isBlank((CharSequence)layoutId)) {
            log.info("\u5e03\u5c40ID\u4e3a\u7a7a\uff0c\u4f7f\u7528\u9ed8\u8ba4\u968f\u673a\u83b7\u53d6\u65b9\u5f0f");
            return this.getRandomTemplateId(tenantCode, userId, userVipFlag);
        }
        String randomTemplateId = this.tdhTemplateMapper.findRandomTemplateIdByLayout(tenantCode, userId, userVipFlag, layoutId);
        log.info("\u6839\u636e\u5e03\u5c40ID\u968f\u673a\u83b7\u53d6\u6a21\u677fID\u7ed3\u679c: {}", (Object)randomTemplateId);
        return randomTemplateId;
    }
}

