/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.tdh.aimatch.strategy;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nbchat.train.api.tdh.enums.PptTypeEnum;
import com.tydic.nbchat.train.core.service.tdh.aimatch.MatchResult;
import com.tydic.nbchat.train.core.service.tdh.aimatch.PptContext;
import com.tydic.nbchat.train.core.service.tdh.aimatch.strategy.BaseRecommender;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRecommender
extends BaseRecommender {
    private static final Logger log = LoggerFactory.getLogger(AbstractRecommender.class);

    @Override
    public final MatchResult recommend(PptContext context) {
        String recommenderType = this.getRecommenderType();
        boolean templateEnabled = this.isTemplateMatchEnabled(context);
        boolean avatarEnabled = this.isAvatarMatchEnabled(context);
        boolean audioEnabled = this.isAudioMatchEnabled(context);
        log.info("\u667a\u80fd\u5339\u914d-{}\u5f00\u59cb\uff0c\u5f00\u5173\u72b6\u6001[\u6a21\u677f:{}, \u6570\u5b57\u4eba:{}, \u97f3\u4e50:{}]", new Object[]{recommenderType, templateEnabled ? "\u5f00\u542f" : "\u5173\u95ed", avatarEnabled ? "\u5f00\u542f" : "\u5173\u95ed", audioEnabled ? "\u5f00\u542f" : "\u5173\u95ed"});
        try {
            String audioId;
            String tdhId;
            List<String> tpIds;
            JSONObject audioAiResult;
            CompletableFuture<JSONObject> templateFuture = null;
            if (templateEnabled && StringUtils.isNotBlank((CharSequence)context.getTemplatePresetId())) {
                templateFuture = CompletableFuture.supplyAsync(() -> {
                    List<String> templatePresetPrompts = this.buildTemplatePresetPrompts(context);
                    return this.callAiRecommendation(context, templatePresetPrompts, context.getTemplatePresetId());
                });
            }
            CompletableFuture<JSONObject> avatarFuture = null;
            if (avatarEnabled && StringUtils.isNotBlank((CharSequence)context.getAvatarPresetId())) {
                avatarFuture = CompletableFuture.supplyAsync(() -> {
                    List<String> avatarPresetPrompts = this.buildAvatarPresetPrompts(context);
                    return this.callAiRecommendation(context, avatarPresetPrompts, context.getAvatarPresetId());
                });
            }
            CompletableFuture<JSONObject> audioFuture = null;
            if (audioEnabled && StringUtils.isNotBlank((CharSequence)context.getAudioPresetId())) {
                audioFuture = CompletableFuture.supplyAsync(() -> {
                    List<String> audioPresetPrompts = this.buildAudioPresetPrompts(context);
                    return this.callAiRecommendation(context, audioPresetPrompts, context.getAudioPresetId());
                });
            }
            ArrayList<CompletableFuture<JSONObject>> futures = new ArrayList<CompletableFuture<JSONObject>>();
            if (templateFuture != null) {
                futures.add(templateFuture);
            }
            if (avatarFuture != null) {
                futures.add(avatarFuture);
            }
            if (audioFuture != null) {
                futures.add(audioFuture);
            }
            if (!futures.isEmpty()) {
                CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
            }
            JSONObject templateAiResult = templateFuture != null ? templateFuture.join() : null;
            JSONObject avatarAiResult = avatarFuture != null ? avatarFuture.join() : null;
            JSONObject jSONObject = audioAiResult = audioFuture != null ? audioFuture.join() : null;
            if (templateEnabled && StringUtils.isNotBlank((CharSequence)context.getTemplatePresetId())) {
                tpIds = this.executeTemplateMatching(context, templateAiResult);
                log.debug("\u667a\u80fd\u5339\u914d-\u6a21\u677fAI\u63a8\u8350\u5b8c\u6210\uff0c\u5339\u914d\u6a21\u677f\u6570: {}", (Object)tpIds.size());
            } else {
                log.info("\u667a\u80fd\u5339\u914d-\u6a21\u677fAI\u5f00\u5173\u5173\u95ed\uff0c\u8fd4\u56denull");
                tpIds = null;
            }
            if (avatarEnabled && StringUtils.isNotBlank((CharSequence)context.getAvatarPresetId())) {
                tdhId = this.matchAvatarWithAi(context, avatarAiResult);
                log.debug("\u667a\u80fd\u5339\u914d-\u6570\u5b57\u4ebaAI\u63a8\u8350\u5b8c\u6210: {}", (Object)tdhId);
            } else {
                log.info("\u667a\u80fd\u5339\u914d-\u6570\u5b57\u4ebaAI\u5f00\u5173\u5173\u95ed\uff0c\u8fd4\u56denull");
                tdhId = null;
            }
            if (audioEnabled && StringUtils.isNotBlank((CharSequence)context.getAudioPresetId())) {
                audioId = this.executeAudioMatching(context, audioAiResult);
                log.debug("\u667a\u80fd\u5339\u914d-\u80cc\u666f\u97f3\u4e50AI\u63a8\u8350\u5b8c\u6210: {}", (Object)audioId);
            } else {
                log.info("\u667a\u80fd\u5339\u914d-\u80cc\u666f\u97f3\u4e50AI\u5f00\u5173\u5173\u95ed\uff0c\u8fd4\u56denull");
                audioId = null;
            }
            return MatchResult.builder().tpId(tpIds).tdhId(tdhId).audioId(audioId).reason(this.buildReason(templateAiResult, avatarAiResult, audioAiResult)).aiRecommend(this.buildCombinedAiResult(templateAiResult, avatarAiResult, audioAiResult)).build();
        }
        catch (Exception e) {
            log.error("\u667a\u80fd\u5339\u914d-{}\u63a8\u8350\u5f02\u5e38: {}", new Object[]{recommenderType, e.getMessage(), e});
            return this.createErrorResult();
        }
    }

    protected abstract String getRecommenderType();

    protected abstract PptTypeEnum getSupportedPptType();

    protected abstract StringBuilder buildPptContent(PptContext var1);

    protected abstract String buildReason(JSONObject var1, JSONObject var2, JSONObject var3);

    protected List<String> executeTemplateMatching(PptContext context, JSONObject templateAiResult) {
        return this.matchTemplateIdsWithAi(context, templateAiResult, null, null, null);
    }

    protected boolean isTemplateMatchEnabled(PptContext context) {
        boolean enabled;
        boolean backendEnabled = this.tdhTemplateConfigProperties != null && this.tdhTemplateConfigProperties.isEnableTemplateAiMatch();
        boolean frontendEnabled = context.getEnableTemplateMatch() == null || context.getEnableTemplateMatch() != false;
        boolean bl = enabled = backendEnabled && frontendEnabled;
        if (!enabled) {
            log.debug("\u667a\u80fd\u5339\u914d-\u6a21\u677fAI\u5173\u95ed[\u540e\u7aef:{}, \u524d\u7aef:{}]", (Object)backendEnabled, (Object)frontendEnabled);
        }
        return enabled;
    }

    protected boolean isAvatarMatchEnabled(PptContext context) {
        boolean enabled;
        boolean backendEnabled = this.tdhTemplateConfigProperties != null && this.tdhTemplateConfigProperties.isEnableAvatarAiMatch();
        boolean frontendEnabled = context.getEnableAvatarMatch() == null || context.getEnableAvatarMatch() != false;
        boolean bl = enabled = backendEnabled && frontendEnabled;
        if (!enabled) {
            log.debug("\u667a\u80fd\u5339\u914d-\u6570\u5b57\u4ebaAI\u5173\u95ed[\u540e\u7aef:{}, \u524d\u7aef:{}]", (Object)backendEnabled, (Object)frontendEnabled);
        }
        return enabled;
    }

    protected boolean isAudioMatchEnabled(PptContext context) {
        boolean enabled;
        boolean backendEnabled = this.tdhTemplateConfigProperties != null && this.tdhTemplateConfigProperties.isEnableAudioAiMatch();
        boolean frontendEnabled = context.getEnableAudioMatch() == null || context.getEnableAudioMatch() != false;
        boolean bl = enabled = backendEnabled && frontendEnabled;
        if (!enabled) {
            log.debug("\u667a\u80fd\u5339\u914d-\u80cc\u666f\u97f3\u4e50AI\u5173\u95ed[\u540e\u7aef:{}, \u524d\u7aef:{}]", (Object)backendEnabled, (Object)frontendEnabled);
        }
        return enabled;
    }

    protected String executeAudioMatching(PptContext context, JSONObject audioAiResult) {
        return this.matchAudioWithAi(context, audioAiResult, null, null);
    }

    protected List<String> buildTemplatePresetPrompts(PptContext context) {
        ArrayList<String> presetPrompts = new ArrayList<String>();
        try {
            String availableResources;
            StringBuilder pptInfoBuilder = this.buildPptContent(context);
            if (pptInfoBuilder.length() > 0) {
                presetPrompts.add(pptInfoBuilder.toString().trim());
            }
            if (StringUtils.isNotBlank((CharSequence)(availableResources = this.getAvailableResources(context)))) {
                presetPrompts.add(availableResources);
            }
            log.info("\u6784\u5efa\u6a21\u677f\u63a8\u8350\u9884\u8bbe\u53c2\u6570\u5b8c\u6210\uff0c\u53c2\u6570\u6570\u91cf: {}", (Object)presetPrompts.size());
        }
        catch (Exception e) {
            log.error("\u6784\u5efa\u6a21\u677f\u63a8\u8350\u9884\u8bbe\u53c2\u6570\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
        }
        return presetPrompts;
    }

    protected List<String> buildAvatarPresetPrompts(PptContext context) {
        ArrayList<String> presetPrompts = new ArrayList<String>();
        try {
            String avatarInfo;
            StringBuilder pptInfoBuilder = this.buildPptContent(context);
            if (pptInfoBuilder.length() > 0) {
                presetPrompts.add(pptInfoBuilder.toString().trim());
            }
            if (StringUtils.isNotBlank((CharSequence)(avatarInfo = this.buildAvatarInfoForAi(context)))) {
                presetPrompts.add(avatarInfo);
            }
            log.info("\u6784\u5efa\u6570\u5b57\u4eba\u63a8\u8350\u9884\u8bbe\u53c2\u6570\u5b8c\u6210\uff0c\u53c2\u6570\u6570\u91cf: {}", (Object)presetPrompts.size());
        }
        catch (Exception e) {
            log.error("\u6784\u5efa\u6570\u5b57\u4eba\u63a8\u8350\u9884\u8bbe\u53c2\u6570\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
        }
        return presetPrompts;
    }

    protected List<String> buildAudioPresetPrompts(PptContext context) {
        ArrayList<String> presetPrompts = new ArrayList<String>();
        try {
            String audioInfo;
            StringBuilder pptInfoBuilder = this.buildPptContent(context);
            if (pptInfoBuilder.length() > 0) {
                presetPrompts.add(pptInfoBuilder.toString().trim());
            }
            if (StringUtils.isNotBlank((CharSequence)(audioInfo = this.buildAudioInfoForAi(context)))) {
                presetPrompts.add(audioInfo);
            }
            log.info("\u6784\u5efa\u80cc\u666f\u97f3\u4e50\u63a8\u8350\u9884\u8bbe\u53c2\u6570\u5b8c\u6210\uff0c\u53c2\u6570\u6570\u91cf: {}", (Object)presetPrompts.size());
        }
        catch (Exception e) {
            log.error("\u6784\u5efa\u80cc\u666f\u97f3\u4e50\u63a8\u8350\u9884\u8bbe\u53c2\u6570\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
        }
        return presetPrompts;
    }

    protected String buildCombinedAiResult(JSONObject templateResult, JSONObject avatarResult, JSONObject audioResult) {
        JSONObject combined = new JSONObject();
        if (templateResult != null) {
            combined.put("templateRecommend", (Object)templateResult);
        }
        if (avatarResult != null) {
            combined.put("avatarRecommend", (Object)avatarResult);
        }
        if (audioResult != null) {
            combined.put("audioRecommend", (Object)audioResult);
        }
        return combined.toString();
    }

    protected MatchResult createErrorResult() {
        return MatchResult.builder().tpId(new ArrayList<String>()).tdhId(null).audioId(null).reason("\u63a8\u8350\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5").aiRecommend(null).build();
    }
}

