/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.tdh.aimatch.strategy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nbchat.robot.api.NbchatRobotToolsApi;
import com.tydic.nbchat.robot.api.bo.tools.RobotPromptMessageRequest;
import com.tydic.nbchat.robot.api.bo.tools.RobotToolsChatResponse;
import com.tydic.nbchat.train.api.tdh.enums.TdhGenderEnum;
import com.tydic.nbchat.train.core.config.TdhTemplateConfigProperties;
import com.tydic.nbchat.train.core.service.tdh.aimatch.PptContext;
import com.tydic.nbchat.train.core.service.tdh.aimatch.matcher.CommonAudioMatchProcessor;
import com.tydic.nbchat.train.core.service.tdh.aimatch.matcher.CommonTemplateMatchProcessor;
import com.tydic.nbchat.train.core.service.tdh.aimatch.matcher.TdhTemplateMatchStrategy;
import com.tydic.nbchat.train.core.service.tdh.aimatch.service.AvatarService;
import com.tydic.nbchat.train.core.service.tdh.aimatch.service.TemplateService;
import com.tydic.nbchat.train.core.service.tdh.aimatch.strategy.AudioMatchStrategy;
import com.tydic.nbchat.train.core.service.tdh.aimatch.strategy.Recommender;
import com.tydic.nbchat.train.core.util.RegularUtil;
import com.tydic.nbchat.train.mapper.po.TdhAudio;
import com.tydic.nbchat.train.mapper.po.TdhTemplate;
import com.tydic.nbchat.train.mapper.po.TdhVirtualHuman;
import com.tydic.nicc.dc.base.bo.Rsp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public abstract class BaseRecommender
implements Recommender {
    private static final Logger log = LoggerFactory.getLogger(BaseRecommender.class);
    @Resource
    protected TdhTemplateMatchStrategy tdhTemplateMatchStrategy;
    @Resource
    protected TemplateService templateService;
    @Resource
    protected AvatarService avatarService;
    @Resource
    protected TdhTemplateConfigProperties tdhTemplateConfigProperties;
    @Resource
    protected AudioMatchStrategy audioMatchStrategy;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=10000)
    private NbchatRobotToolsApi nbchatRobotToolsApi;

    protected JSONObject callAiRecommendation(PptContext context, List<String> presetPrompts, String presetId) {
        if (StringUtils.isEmpty((CharSequence)presetId)) {
            log.warn("AI\u63a8\u8350-\u9884\u8bbeID\u4e3a\u7a7a\uff0c\u8df3\u8fc7AI\u8c03\u7528");
            return null;
        }
        try {
            RobotPromptMessageRequest request = new RobotPromptMessageRequest();
            BeanUtils.copyProperties((Object)context, (Object)request);
            request.setPresetId(presetId);
            request.setPresetPrompts(presetPrompts);
            log.info("AI\u63a8\u8350-\u8c03\u7528\u53c2\u6570: \u9884\u8bbeID={}, robotType={}, \u7528\u6237ID={}", new Object[]{presetId, context.getRobotType(), context.getUserId()});
            Rsp rsp = this.nbchatRobotToolsApi.getChatResult(request);
            if (!rsp.isSuccess() || rsp.getData() == null) {
                log.warn("AI\u63a8\u8350-\u8c03\u7528\u5931\u8d25\uff0c\u9884\u8bbeID: {}", (Object)presetId);
                return null;
            }
            RobotToolsChatResponse data = (RobotToolsChatResponse)rsp.getData();
            String content = RegularUtil.extractJsonString(data.getContent());
            log.info("AI\u63a8\u8350-\u6a21\u578b\u8fd4\u56de\u5185\u5bb9: {}", (Object)content);
            if (StringUtils.isBlank((CharSequence)content)) {
                log.warn("AI\u63a8\u8350-\u672a\u627e\u5230\u5408\u6cd5JSON\uff0c\u9884\u8bbeID: {}", (Object)presetId);
                return null;
            }
            log.info("AI\u63a8\u8350-\u6210\u529f\u83b7\u53d6\u7ed3\u679c\uff0c\u9884\u8bbeID: {}, \u5185\u5bb9: {}", (Object)presetId, (Object)content);
            return JSON.parseObject((String)content);
        }
        catch (Exception e) {
            log.error("AI\u63a8\u8350-\u5904\u7406\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    protected String matchTemplateWithAi(PptContext context, JSONObject aiResult, String defaultScene, String defaultStyle, String defaultColor) {
        return CommonTemplateMatchProcessor.matchTemplateWithAi(this.tdhTemplateMatchStrategy, context.getTenantCode(), context.getUserId(), context.getUserVipFlag(), context.getLayoutId(), aiResult, defaultScene, defaultStyle, defaultColor, this.tdhTemplateConfigProperties);
    }

    protected List<String> matchTemplateIdsWithAi(PptContext context, JSONObject aiResult, String defaultScene, String defaultStyle, String defaultColor) {
        return CommonTemplateMatchProcessor.matchTemplateIdsWithAi(this.tdhTemplateMatchStrategy, context.getTenantCode(), context.getUserId(), context.getUserVipFlag(), context.getLayoutId(), aiResult, defaultScene, defaultStyle, defaultColor, this.tdhTemplateConfigProperties);
    }

    protected String matchAudioWithAi(PptContext context, JSONObject aiResult, String defaultScene, String defaultStyle) {
        return CommonAudioMatchProcessor.matchAudioWithAi(this.audioMatchStrategy, context.getTenantCode(), context.getUserId(), context.getUserVipFlag(), aiResult, defaultScene, defaultStyle, this.tdhTemplateConfigProperties);
    }

    protected List<String> matchAudioIdsWithAi(PptContext context, JSONObject aiResult, String defaultScene, String defaultStyle) {
        return CommonAudioMatchProcessor.matchAudioIdsWithAi(this.audioMatchStrategy, context.getTenantCode(), context.getUserId(), context.getUserVipFlag(), aiResult, defaultScene, defaultStyle, this.tdhTemplateConfigProperties);
    }

    protected String matchAvatarWithAi(PptContext context, JSONObject aiResult) {
        try {
            String aiSelectedTdhId;
            if (aiResult != null && aiResult.containsKey((Object)"tdhId") && StringUtils.isNotBlank((CharSequence)(aiSelectedTdhId = aiResult.getString("tdhId")))) {
                log.info("\u6570\u5b57\u4eba\u5339\u914d-AI\u76f4\u63a5\u63a8\u8350\u6570\u5b57\u4eba: {}", (Object)aiSelectedTdhId);
                return aiSelectedTdhId;
            }
            log.info("\u6570\u5b57\u4eba\u5339\u914d-AI\u672a\u63a8\u8350\u5177\u4f53\u6570\u5b57\u4eba\uff0c\u4f18\u5148\u5c1d\u8bd5\u56fa\u5b9a\u6570\u5b57\u4eba");
            String fixedAvatarId = this.tryGetFixedAvatarId(context);
            if (StringUtils.isNotBlank((CharSequence)fixedAvatarId)) {
                return fixedAvatarId;
            }
            log.info("\u6570\u5b57\u4eba\u5339\u914d-\u56fa\u5b9a\u6570\u5b57\u4eba\u4e0d\u53ef\u7528\uff0c\u4f7f\u7528\u968f\u673a\u6570\u5b57\u4eba");
            String randomAvatarId = this.avatarService.getRandomAvatarId(context.getTenantCode(), context.getUserId(), context.getUserVipFlag());
            if (StringUtils.isNotBlank((CharSequence)randomAvatarId)) {
                return randomAvatarId;
            }
            log.warn("\u6570\u5b57\u4eba\u5339\u914d-\u968f\u673a\u6570\u5b57\u4eba\u83b7\u53d6\u5931\u8d25\uff0c\u542f\u7528\u964d\u7ea7\u7b56\u7565");
            return this.getFallbackAvatarId(context);
        }
        catch (Exception e) {
            log.error("\u6570\u5b57\u4eba\u5339\u914d-\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
            return this.getFallbackAvatarId(context);
        }
    }

    private String tryGetFixedAvatarId(PptContext context) {
        if (this.tdhTemplateConfigProperties != null && this.tdhTemplateConfigProperties.isEnableDefaultAvatar() && StringUtils.isNotBlank((CharSequence)this.tdhTemplateConfigProperties.getDefaultAvatarId())) {
            String defaultAvatarId = this.tdhTemplateConfigProperties.getDefaultAvatarId();
            log.info("\u6570\u5b57\u4eba\u5339\u914d-\u68c0\u67e5\u56fa\u5b9a\u6570\u5b57\u4eba: {}", (Object)defaultAvatarId);
            if (this.avatarService.isAvatarExists(defaultAvatarId, context.getTenantCode(), context.getUserId(), context.getUserVipFlag())) {
                log.info("\u6570\u5b57\u4eba\u5339\u914d-\u4f7f\u7528\u56fa\u5b9a\u6570\u5b57\u4eba: {}", (Object)defaultAvatarId);
                return defaultAvatarId;
            }
            log.info("\u6570\u5b57\u4eba\u5339\u914d-\u56fa\u5b9a\u6570\u5b57\u4eba\u4e0d\u5b58\u5728\u6216\u65e0\u6743\u9650\u8bbf\u95ee: {}", (Object)defaultAvatarId);
        }
        return "";
    }

    private String getFallbackAvatarId(PptContext context) {
        log.info("\u6570\u5b57\u4eba\u964d\u7ea7\u7b56\u7565-\u4f7f\u7528AvatarService\u83b7\u53d6\u968f\u673a\u6570\u5b57\u4eba");
        String fallbackAvatarId = this.avatarService.getRandomAvatarId(context.getTenantCode(), context.getUserId(), context.getUserVipFlag());
        if (StringUtils.isNotBlank((CharSequence)fallbackAvatarId)) {
            return fallbackAvatarId;
        }
        if (this.tdhTemplateConfigProperties != null && StringUtils.isNotBlank((CharSequence)this.tdhTemplateConfigProperties.getDefaultAvatarId())) {
            String defaultAvatarId = this.tdhTemplateConfigProperties.getDefaultAvatarId();
            log.warn("\u6570\u5b57\u4eba\u964d\u7ea7\u7b56\u7565-\u5f3a\u5236\u4f7f\u7528\u56fa\u5b9a\u6570\u5b57\u4eba\u4f5c\u4e3a\u6700\u7ec8\u964d\u7ea7: {}", (Object)defaultAvatarId);
            return defaultAvatarId;
        }
        log.error("\u6570\u5b57\u4eba\u964d\u7ea7\u7b56\u7565-\u6240\u6709\u7b56\u7565\u5747\u5931\u8d25\uff0c\u65e0\u6cd5\u83b7\u53d6\u6570\u5b57\u4ebaID");
        return "";
    }

    protected String getAvailableResources(PptContext context) {
        try {
            List<TdhTemplate> allTemplates;
            if (StringUtils.isNotBlank((CharSequence)context.getLayoutId())) {
                log.info("\u4f7f\u7528\u5e03\u5c40ID\u8fc7\u6ee4\u6a21\u677f: {}", (Object)context.getLayoutId());
                allTemplates = this.tdhTemplateMatchStrategy.findCandidateTemplatesByLayout(context.getTenantCode(), context.getUserId(), context.getUserVipFlag(), context.getLayoutId());
            } else {
                allTemplates = this.templateService.findCandidateTemplates(context.getTenantCode(), context.getUserId(), context.getUserVipFlag());
            }
            if (CollectionUtils.isEmpty(allTemplates)) {
                log.info("\u672a\u67e5\u8be2\u5230\u6a21\u677f\u6570\u636e");
                return "\u53ef\u7528\u6a21\u677f\u8d44\u6e90\uff1a\n\u6682\u65e0\u53ef\u7528\u6a21\u677f";
            }
            LinkedHashMap<String, Set> sceneStyleMap = new LinkedHashMap<String, Set>();
            LinkedHashMap<String, Set> sceneColorMap = new LinkedHashMap<String, Set>();
            for (TdhTemplate template : allTemplates) {
                String sceneStr = template.getScene();
                String style = template.getStyle();
                String color = template.getColor();
                Set<String> scenes = this.parseStringArrayField(sceneStr);
                if (scenes.isEmpty()) continue;
                for (String scene : scenes) {
                    sceneStyleMap.computeIfAbsent(scene, k -> new LinkedHashSet());
                    sceneColorMap.computeIfAbsent(scene, k -> new LinkedHashSet());
                    Set<String> styles = this.parseStringArrayField(style);
                    ((Set)sceneStyleMap.get(scene)).addAll(styles);
                    Set<String> colors = this.parseStringArrayField(color);
                    ((Set)sceneColorMap.get(scene)).addAll(colors);
                }
            }
            sceneStyleMap.entrySet().removeIf(entry -> ((Set)entry.getValue()).isEmpty() && (!sceneColorMap.containsKey(entry.getKey()) || ((Set)sceneColorMap.get(entry.getKey())).isEmpty()));
            if (sceneStyleMap.isEmpty()) {
                log.info("\u6ca1\u6709\u6709\u6548\u7684\u6a21\u677f\u8d44\u6e90\u4fe1\u606f");
                return "\u53ef\u7528\u6a21\u677f\u8d44\u6e90\uff1a\n\u6682\u65e0\u6709\u6548\u6a21\u677f\u8d44\u6e90";
            }
            StringBuilder templateText = new StringBuilder();
            for (String scene : sceneStyleMap.keySet()) {
                Set colorSet;
                templateText.append("\u573a\u666f\uff1a").append(scene).append("\n");
                Set styleSet = (Set)sceneStyleMap.get(scene);
                if (!styleSet.isEmpty()) {
                    templateText.append("    - \u98ce\u683c\uff1a").append(String.join((CharSequence)"\u3001", styleSet)).append("\n");
                }
                if ((colorSet = (Set)sceneColorMap.getOrDefault(scene, new LinkedHashSet())).isEmpty()) continue;
                templateText.append("    - \u989c\u8272\uff1a").append(String.join((CharSequence)"\u3001", colorSet)).append("\n");
            }
            log.info("\u6210\u529f\u6784\u5efa\u6a21\u677f\u8d44\u6e90\u4fe1\u606f - \u573a\u666f\u6570\u91cf: {}", (Object)sceneStyleMap.size());
            return "\u53ef\u7528\u6a21\u677f\u8d44\u6e90\uff1a\n" + String.valueOf(templateText);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u53ef\u7528\u6a21\u677f\u8d44\u6e90\u4fe1\u606f\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private Set<String> parseStringArrayField(String fieldValue) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (StringUtils.isBlank((CharSequence)fieldValue)) {
            return result;
        }
        try {
            if (fieldValue.trim().startsWith("[") && fieldValue.trim().endsWith("]")) {
                JSONArray jsonArray = JSON.parseArray((String)fieldValue);
                if (jsonArray != null) {
                    for (int i = 0; i < jsonArray.size(); ++i) {
                        String value = jsonArray.getString(i);
                        if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                        result.add(value.trim());
                    }
                }
            } else {
                String[] values;
                for (String value : values = fieldValue.split("[,\uff0c]")) {
                    if (!StringUtils.isNotBlank((CharSequence)value.trim())) continue;
                    result.add(value.trim());
                }
            }
        }
        catch (Exception e) {
            String[] values;
            log.warn("\u89e3\u6790\u5b57\u7b26\u4e32\u6570\u7ec4\u5b57\u6bb5\u5f02\u5e38\uff0c\u5c06\u6309\u9017\u53f7\u5206\u9694\u5904\u7406: {}, \u5f02\u5e38: {}", (Object)fieldValue, (Object)e.getMessage());
            for (String value : values = fieldValue.split("[,\uff0c]")) {
                if (!StringUtils.isNotBlank((CharSequence)value.trim())) continue;
                result.add(value.trim());
            }
        }
        return result;
    }

    protected String buildAvatarInfoForAi(PptContext context) {
        try {
            String[] groups;
            List<TdhVirtualHuman> avatars = this.avatarService.findAllAvailableAvatars(context.getTenantCode(), context.getUserId(), context.getUserVipFlag());
            if (CollectionUtils.isEmpty(avatars)) {
                return null;
            }
            Map<String, List<TdhVirtualHuman>> groupedAvatars = this.groupAvatarsByTypeAndPriority(avatars);
            StringBuilder result = new StringBuilder();
            for (String groupKey : groups = new String[]{"\u5199\u5b9e\u6570\u5b57\u4eba-\u4f18\u5148\u7ea7\u9ad8", "\u5199\u5b9e\u6570\u5b57\u4eba-\u4f18\u5148\u7ea7\u4f4e", "\u5361\u901a\u6570\u5b57\u4eba-\u4f18\u5148\u7ea7\u9ad8", "\u5361\u901a\u6570\u5b57\u4eba-\u4f18\u5148\u7ea7\u4f4e"}) {
                List<TdhVirtualHuman> groupAvatars = groupedAvatars.get(groupKey);
                if (groupAvatars == null || groupAvatars.isEmpty()) continue;
                result.append("##").append(groupKey).append("\uff1a\n");
                for (TdhVirtualHuman avatar : groupAvatars) {
                    result.append(this.formatAvatarInfo(avatar)).append("\n");
                }
            }
            log.info("\u6784\u5efa\u6570\u5b57\u4eba\u4fe1\u606f\u5b8c\u6210\uff0c\u603b\u6570: {}, VIP\u72b6\u6001: {}", (Object)avatars.size(), (Object)context.getUserVipFlag());
            return result.toString();
        }
        catch (Exception e) {
            log.error("\u6784\u5efa\u6570\u5b57\u4eba\u4fe1\u606f\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    protected String buildAudioInfoForAi(PptContext context) {
        try {
            List<TdhAudio> audios = this.audioMatchStrategy.findCandidateAudios(context.getTenantCode(), context.getUserId(), context.getUserVipFlag());
            if (CollectionUtils.isEmpty(audios)) {
                log.info("\u672a\u67e5\u8be2\u5230\u80cc\u666f\u97f3\u4e50\u6570\u636e");
                return "\u53ef\u7528\u80cc\u666f\u97f3\u4e50\u8d44\u6e90\uff1a\n\u6682\u65e0\u53ef\u7528\u80cc\u666f\u97f3\u4e50";
            }
            LinkedHashMap<String, Set> sceneStyleMap = new LinkedHashMap<String, Set>();
            for (TdhAudio audio : audios) {
                String sceneStr = audio.getScene();
                String style = audio.getStyle();
                Set<String> scenes = this.parseStringArrayField(sceneStr);
                if (scenes.isEmpty()) continue;
                for (String scene : scenes) {
                    sceneStyleMap.computeIfAbsent(scene, k -> new LinkedHashSet());
                    Set<String> styles = this.parseStringArrayField(style);
                    ((Set)sceneStyleMap.get(scene)).addAll(styles);
                }
            }
            sceneStyleMap.entrySet().removeIf(entry -> ((Set)entry.getValue()).isEmpty());
            if (sceneStyleMap.isEmpty()) {
                log.info("\u6ca1\u6709\u6709\u6548\u7684\u80cc\u666f\u97f3\u4e50\u8d44\u6e90\u4fe1\u606f");
                return "\u53ef\u7528\u80cc\u666f\u97f3\u4e50\u8d44\u6e90\uff1a\n\u6682\u65e0\u6709\u6548\u80cc\u666f\u97f3\u4e50\u8d44\u6e90";
            }
            StringBuilder audioText = new StringBuilder();
            for (String scene : sceneStyleMap.keySet()) {
                audioText.append("\u573a\u666f\uff1a").append(scene).append("\n");
                Set styleSet = (Set)sceneStyleMap.get(scene);
                if (styleSet.isEmpty()) continue;
                audioText.append("    - \u98ce\u683c\uff1a").append(String.join((CharSequence)"\u3001", styleSet)).append("\n");
            }
            log.info("\u6210\u529f\u6784\u5efa\u80cc\u666f\u97f3\u4e50\u8d44\u6e90\u4fe1\u606f - \u573a\u666f\u6570\u91cf: {}", (Object)sceneStyleMap.size());
            return "\u53ef\u7528\u80cc\u666f\u97f3\u4e50\u8d44\u6e90\uff1a\n" + String.valueOf(audioText);
        }
        catch (Exception e) {
            log.error("\u6784\u5efa\u80cc\u666f\u97f3\u4e50\u4fe1\u606f\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private Map<String, List<TdhVirtualHuman>> groupAvatarsByTypeAndPriority(List<TdhVirtualHuman> avatars) {
        HashMap<String, List<TdhVirtualHuman>> groups = new HashMap<String, List<TdhVirtualHuman>>();
        groups.put("\u5199\u5b9e\u6570\u5b57\u4eba-\u4f18\u5148\u7ea7\u9ad8", new ArrayList());
        groups.put("\u5199\u5b9e\u6570\u5b57\u4eba-\u4f18\u5148\u7ea7\u4f4e", new ArrayList());
        groups.put("\u5361\u901a\u6570\u5b57\u4eba-\u4f18\u5148\u7ea7\u9ad8", new ArrayList());
        groups.put("\u5361\u901a\u6570\u5b57\u4eba-\u4f18\u5148\u7ea7\u4f4e", new ArrayList());
        for (TdhVirtualHuman avatar : avatars) {
            boolean isHighPriority;
            boolean isCartoon = "2d_gif".equals(avatar.getTdhType());
            boolean bl = isHighPriority = avatar.getOrderIndex() != null && avatar.getOrderIndex() <= 100;
            String groupKey = isCartoon ? (isHighPriority ? "\u5361\u901a\u6570\u5b57\u4eba-\u4f18\u5148\u7ea7\u9ad8" : "\u5361\u901a\u6570\u5b57\u4eba-\u4f18\u5148\u7ea7\u4f4e") : (isHighPriority ? "\u5199\u5b9e\u6570\u5b57\u4eba-\u4f18\u5148\u7ea7\u9ad8" : "\u5199\u5b9e\u6570\u5b57\u4eba-\u4f18\u5148\u7ea7\u4f4e");
            ((List)groups.get(groupKey)).add(avatar);
        }
        for (List group : groups.values()) {
            group.sort((a, b) -> {
                int orderA = a.getOrderIndex() != null ? a.getOrderIndex() : 999999;
                int orderB = b.getOrderIndex() != null ? b.getOrderIndex() : 999999;
                return Integer.compare(orderA, orderB);
            });
        }
        return groups;
    }

    private String formatAvatarInfo(TdhVirtualHuman avatar) {
        try {
            String id = avatar.getTdhId();
            String name = StringUtils.isNotBlank((CharSequence)avatar.getTdhName()) ? avatar.getTdhName() : "\u672a\u77e5";
            String gender = TdhGenderEnum.getDescriptionByCode((String)avatar.getGender());
            if (StringUtils.isBlank((CharSequence)gender)) {
                gender = "\u672a\u77e5";
            }
            String age = this.parseAgeFromTags(avatar.getTdhTags());
            String temperament = this.parseTemperamentFromTags(avatar.getTdhTags());
            String clothing = this.parseClothingFromTags(avatar.getTdhTags());
            String identity = this.parseIdentityFromTags(avatar.getTdhTags());
            String language = "\u666e\u901a\u8bdd";
            return String.format("ID:%s\uff1b%s\uff1b%s\uff1b%s\uff1b%s\uff1b%s\uff1b%s\uff1b%s", id, name, gender, age, temperament, clothing, identity, language);
        }
        catch (Exception e) {
            log.error("\u683c\u5f0f\u5316\u6570\u5b57\u4eba\u4fe1\u606f\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
            return String.format("ID:%s\uff1b%s\uff1b\u6570\u636e\u683c\u5f0f\u5f02\u5e38", avatar.getTdhId(), avatar.getTdhName());
        }
    }

    private String parseAgeFromTags(String tdhTags) {
        if (StringUtils.isBlank((CharSequence)tdhTags)) {
            return "\u9752\u5e74";
        }
        try {
            String tagsText = tdhTags.toLowerCase();
            if (tagsText.contains("\u8001\u5e74") || tagsText.contains("\u8001\u4eba")) {
                return "\u8001\u5e74";
            }
            if (tagsText.contains("\u4e2d\u5e74")) {
                return "\u4e2d\u5e74";
            }
            if (tagsText.contains("\u5c11\u5e74") || tagsText.contains("\u9752\u5c11\u5e74")) {
                return "\u5c11\u5e74";
            }
            if (tagsText.contains("\u513f\u7ae5") || tagsText.contains("\u5c0f\u5b69")) {
                return "\u513f\u7ae5";
            }
            return "\u9752\u5e74";
        }
        catch (Exception e) {
            return "\u9752\u5e74";
        }
    }

    private String parseTemperamentFromTags(String tdhTags) {
        if (StringUtils.isBlank((CharSequence)tdhTags)) {
            return "\u6c89\u7a33\u6743\u5a01";
        }
        try {
            String tagsText = tdhTags.toLowerCase();
            if (tagsText.contains("\u4e25\u8083") || tagsText.contains("\u4e25\u8c28")) {
                return "\u4e25\u8083\u4e25\u8c28";
            }
            if (tagsText.contains("\u5446\u840c") || tagsText.contains("\u53ef\u7231")) {
                return "\u5446\u840c\u53ef\u7231";
            }
            if (tagsText.contains("\u6d3b\u6cfc") || tagsText.contains("\u8df3\u8131")) {
                return "\u6d3b\u6cfc\u8df3\u8131";
            }
            if (tagsText.contains("\u5e7d\u9ed8") || tagsText.contains("\u98ce\u8da3")) {
                return "\u5e7d\u9ed8\u98ce\u8da3";
            }
            return "\u6c89\u7a33\u6743\u5a01";
        }
        catch (Exception e) {
            return "\u6c89\u7a33\u6743\u5a01";
        }
    }

    private String parseClothingFromTags(String tdhTags) {
        if (StringUtils.isBlank((CharSequence)tdhTags)) {
            return "\u804c\u4e1a\u88c5\uff08\u6b63\u88c5\uff09";
        }
        try {
            String tagsText = tdhTags.toLowerCase();
            if (tagsText.contains("\u897f\u88c5") || tagsText.contains("\u6b63\u88c5")) {
                return "\u6b63\u88c5\uff08\u897f\u88c5\uff09";
            }
            if (tagsText.contains("\u6c49\u670d") || tagsText.contains("\u53e4\u98ce")) {
                return "\u53e4\u98ce\uff08\u6c49\u670d\uff09";
            }
            if (tagsText.contains("\u6559\u5e08") || tagsText.contains("\u5236\u670d")) {
                return "\u804c\u4e1a\u88c5\uff08\u6559\u5e08\u5236\u670d\uff09";
            }
            if (tagsText.contains("\u5de5\u7a0b\u5e08") || tagsText.contains("\u5de5\u88c5")) {
                return "\u804c\u4e1a\u88c5\uff08\u5de5\u7a0b\u5e08\u5de5\u88c5\uff09";
            }
            if (tagsText.contains("\u536b\u8863") || tagsText.contains("\u4f11\u95f2")) {
                return "\u4f11\u95f2\u88c5\uff08\u536b\u8863\uff09";
            }
            if (tagsText.contains("\u6f6e\u724c") || tagsText.contains("\u6f6e\u6d41")) {
                return "\u4f11\u95f2\u88c5\uff08\u6f6e\u724c\uff09";
            }
            if (tagsText.contains("\u793c\u670d")) {
                return "\u6b63\u88c5\uff08\u793c\u670d\uff09";
            }
            return "\u804c\u4e1a\u88c5\uff08\u6b63\u88c5\uff09";
        }
        catch (Exception e) {
            return "\u804c\u4e1a\u88c5\uff08\u6b63\u88c5\uff09";
        }
    }

    private String parseIdentityFromTags(String tdhTags) {
        if (StringUtils.isBlank((CharSequence)tdhTags)) {
            return "\u804c\u573a\u5bfc\u5e08";
        }
        try {
            String tagsText = tdhTags.toLowerCase();
            if (tagsText.contains("\u6559\u6388")) {
                return "\u6559\u6388";
            }
            if (tagsText.contains("\u4e8c\u6b21\u5143") || tagsText.contains("\u52a8\u6f2b") || tagsText.contains("ip")) {
                return "\u4e8c\u6b21\u5143\u89d2\u8272\uff08\u52a8\u6f2bIP\u884d\u751f\uff09";
            }
            if (tagsText.contains("\u5de5\u7a0b\u5e08")) {
                return "\u5de5\u7a0b\u5e08";
            }
            if (tagsText.contains("ceo") || tagsText.contains("\u4f01\u4e1a")) {
                return "\u4f01\u4e1aCEO";
            }
            if (tagsText.contains("\u4e3b\u64ad")) {
                return "\u4e3b\u64ad";
            }
            if (tagsText.contains("\u535a\u4e3b") || tagsText.contains("\u79d1\u6280")) {
                return "\u8fbe\u4eba\uff08\u79d1\u6280\u535a\u4e3b\uff09";
            }
            if (tagsText.contains("\u6559\u5e08")) {
                return "\u804c\u573a\u5bfc\u5e08";
            }
            return "\u804c\u573a\u5bfc\u5e08";
        }
        catch (Exception e) {
            return "\u804c\u573a\u5bfc\u5e08";
        }
    }
}

