/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.tdh.aimatch.strategy;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nbchat.train.api.tdh.enums.PptTypeEnum;
import com.tydic.nbchat.train.core.service.tdh.aimatch.PptContext;
import com.tydic.nbchat.train.core.service.tdh.aimatch.strategy.AbstractRecommender;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HtmlRecommender
extends AbstractRecommender {
    private static final Logger log = LoggerFactory.getLogger(HtmlRecommender.class);

    @Override
    protected String getRecommenderType() {
        return PptTypeEnum.HTML.getDescription();
    }

    @Override
    protected PptTypeEnum getSupportedPptType() {
        return PptTypeEnum.HTML;
    }

    @Override
    protected StringBuilder buildPptContent(PptContext context) {
        StringBuilder pptInfoBuilder = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)context.getTitleContent())) {
            pptInfoBuilder.append("PPT\u6807\u9898\uff1a").append(context.getTitleContent()).append("\n");
        }
        if (StringUtils.isNotBlank((CharSequence)context.getCreationContent())) {
            pptInfoBuilder.append("PPT\u5185\u5bb9\uff1a").append(context.getCreationContent()).append("\n");
        }
        return pptInfoBuilder;
    }

    @Override
    protected String buildReason(JSONObject templateResult, JSONObject avatarResult, JSONObject audioResult) {
        if (templateResult != null && avatarResult != null && audioResult != null) {
            return "\u57fa\u4e8eHTML PPT\u6807\u9898\u548c\u524d10\u9875\u5185\u5bb9\u7684AI\u4e92\u52a8\u5f0f\u63a8\u8350\uff08\u6a21\u677f+\u6570\u5b57\u4eba+\u80cc\u666f\u97f3\u4e50\uff09";
        }
        if (templateResult != null && avatarResult != null) {
            return "\u57fa\u4e8eHTML PPT\u6807\u9898\u548c\u5185\u5bb9\u7684AI\u63a8\u8350\uff08\u6a21\u677f+\u6570\u5b57\u4eba\uff09+ \u9ed8\u8ba4\u80cc\u666f\u97f3\u4e50\u7b56\u7565";
        }
        if (templateResult != null && audioResult != null) {
            return "\u57fa\u4e8eHTML PPT\u6807\u9898\u548c\u5185\u5bb9\u7684AI\u63a8\u8350\uff08\u6a21\u677f+\u80cc\u666f\u97f3\u4e50\uff09+ \u9ed8\u8ba4\u6570\u5b57\u4eba\u7b56\u7565";
        }
        if (avatarResult != null && audioResult != null) {
            return "\u9ed8\u8ba4\u6a21\u677f\u7b56\u7565 + \u57fa\u4e8eHTML PPT\u5185\u5bb9\u7684AI\u63a8\u8350\uff08\u6570\u5b57\u4eba+\u80cc\u666f\u97f3\u4e50\uff09";
        }
        if (templateResult != null) {
            return "\u57fa\u4e8eHTML PPT\u6807\u9898\u548c\u5185\u5bb9\u7684AI\u6a21\u677f\u63a8\u8350 + \u9ed8\u8ba4\u6570\u5b57\u4eba\u548c\u80cc\u666f\u97f3\u4e50\u7b56\u7565";
        }
        if (avatarResult != null) {
            return "\u9ed8\u8ba4\u6a21\u677f\u548c\u80cc\u666f\u97f3\u4e50\u7b56\u7565 + \u57fa\u4e8eHTML PPT\u5185\u5bb9\u7684AI\u6570\u5b57\u4eba\u63a8\u8350";
        }
        if (audioResult != null) {
            return "\u9ed8\u8ba4\u6a21\u677f\u548c\u6570\u5b57\u4eba\u7b56\u7565 + \u57fa\u4e8eHTML PPT\u5185\u5bb9\u7684AI\u80cc\u666f\u97f3\u4e50\u63a8\u8350";
        }
        return "\u57fa\u4e8eHTML PPT\u7c7b\u578b\u7684\u9ed8\u8ba4\u4e92\u52a8\u5f0f\u63a8\u8350\u7b56\u7565";
    }
}

