/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.tdh.aimatch.strategy;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nbchat.train.api.tdh.enums.PptTypeEnum;
import com.tydic.nbchat.train.core.service.tdh.aimatch.PptContext;
import com.tydic.nbchat.train.core.service.tdh.aimatch.strategy.AbstractRecommender;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class PlatformRecommender
extends AbstractRecommender {
    private static final Logger log = LoggerFactory.getLogger(PlatformRecommender.class);

    @Override
    protected String getRecommenderType() {
        return PptTypeEnum.PLATFORM.getDescription();
    }

    @Override
    protected PptTypeEnum getSupportedPptType() {
        return PptTypeEnum.PLATFORM;
    }

    @Override
    protected StringBuilder buildPptContent(PptContext context) {
        StringBuilder pptInfoBuilder = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)context.getTitleContent())) {
            pptInfoBuilder.append("PPT\u6807\u9898\uff1a").append(context.getTitleContent()).append("\n");
        }
        if (StringUtils.isNotBlank((CharSequence)context.getCreationContent())) {
            pptInfoBuilder.append("PPT\u5185\u5bb9\uff1a").append(context.getCreationContent()).append("\n");
        }
        if (!CollectionUtils.isEmpty(context.getScene())) {
            pptInfoBuilder.append("\u573a\u666f\uff1a").append(context.getScene()).append("\n");
        }
        if (!CollectionUtils.isEmpty(context.getStyle())) {
            pptInfoBuilder.append("\u98ce\u683c\uff1a").append(context.getStyle());
        }
        if (!CollectionUtils.isEmpty(context.getColor())) {
            pptInfoBuilder.append("\u989c\u8272\uff1a").append(context.getColor());
        }
        return pptInfoBuilder;
    }

    @Override
    protected String buildReason(JSONObject templateResult, JSONObject avatarResult, JSONObject audioResult) {
        if (templateResult != null && avatarResult != null && audioResult != null) {
            return "\u57fa\u4e8e\u5e73\u53f0\u6807\u51c6PPT\u6a21\u677f\u7684AI\u4e13\u4e1a\u63a8\u8350\uff0c\u5305\u542b\u5b8c\u6574\u7684\u6807\u9898\u3001\u5185\u5bb9\u3001\u573a\u666f\u3001\u98ce\u683c\u548c\u8272\u5f69\u5206\u6790\uff08\u6a21\u677f+\u6570\u5b57\u4eba+\u80cc\u666f\u97f3\u4e50\uff09";
        }
        if (templateResult != null && avatarResult != null) {
            return "\u57fa\u4e8e\u5e73\u53f0PPT\u5b8c\u6574\u4fe1\u606f\u7684AI\u63a8\u8350\uff08\u6a21\u677f+\u6570\u5b57\u4eba\uff09+ \u9ed8\u8ba4\u80cc\u666f\u97f3\u4e50\u7b56\u7565";
        }
        if (templateResult != null && audioResult != null) {
            return "\u57fa\u4e8e\u5e73\u53f0PPT\u5b8c\u6574\u4fe1\u606f\u7684AI\u63a8\u8350\uff08\u6a21\u677f+\u80cc\u666f\u97f3\u4e50\uff09+ \u9ed8\u8ba4\u6570\u5b57\u4eba\u7b56\u7565";
        }
        if (avatarResult != null && audioResult != null) {
            return "\u9ed8\u8ba4\u6a21\u677f\u7b56\u7565 + \u57fa\u4e8e\u5e73\u53f0PPT\u4fe1\u606f\u7684AI\u63a8\u8350\uff08\u6570\u5b57\u4eba+\u80cc\u666f\u97f3\u4e50\uff09";
        }
        if (templateResult != null) {
            return "\u57fa\u4e8e\u5e73\u53f0PPT\u5b8c\u6574\u4fe1\u606f\u7684AI\u6a21\u677f\u63a8\u8350 + \u9ed8\u8ba4\u6570\u5b57\u4eba\u548c\u80cc\u666f\u97f3\u4e50\u7b56\u7565";
        }
        if (avatarResult != null) {
            return "\u9ed8\u8ba4\u6a21\u677f\u548c\u80cc\u666f\u97f3\u4e50\u7b56\u7565 + \u57fa\u4e8e\u5e73\u53f0PPT\u4fe1\u606f\u7684AI\u6570\u5b57\u4eba\u63a8\u8350";
        }
        if (audioResult != null) {
            return "\u9ed8\u8ba4\u6a21\u677f\u548c\u6570\u5b57\u4eba\u7b56\u7565 + \u57fa\u4e8e\u5e73\u53f0PPT\u4fe1\u606f\u7684AI\u80cc\u666f\u97f3\u4e50\u63a8\u8350";
        }
        return "\u57fa\u4e8e\u5e73\u53f0\u6807\u51c6PPT\u7c7b\u578b\u7684\u9ed8\u8ba4\u4e13\u4e1a\u63a8\u8350\u7b56\u7565";
    }

    @Override
    protected List<String> executeTemplateMatching(PptContext context, JSONObject templateAiResult) {
        return this.matchTemplateIdsWithAi(context, templateAiResult, this.listToString(context.getScene()), this.listToString(context.getStyle()), this.listToString(context.getColor()));
    }

    @Override
    protected String executeAudioMatching(PptContext context, JSONObject audioAiResult) {
        return this.matchAudioWithAi(context, audioAiResult, this.listToString(context.getScene()), this.listToString(context.getStyle()));
    }

    private String listToString(List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return String.join((CharSequence)",", list);
    }
}

