/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.tdh.aimatch.strategy;

import com.tydic.nbchat.train.core.service.tdh.aimatch.strategy.AudioMatchStrategy;
import com.tydic.nbchat.train.mapper.TdhAudioMapper;
import com.tydic.nbchat.train.mapper.po.TdhAudio;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TdhAudioMatchStrategy
implements AudioMatchStrategy {
    private static final Logger log = LoggerFactory.getLogger(TdhAudioMatchStrategy.class);
    @Resource
    private TdhAudioMapper tdhAudioMapper;

    @Override
    public List<TdhAudio> findCandidateAudios(String tenantCode, String userId, String userVipFlag) {
        log.info("\u67e5\u8be2\u5019\u9009\u80cc\u666f\u97f3\u4e50 - tenantCode: {}, userId: {}, userVipFlag: {}", new Object[]{tenantCode, userId, userVipFlag});
        List audios = this.tdhAudioMapper.findCandidateAudios(tenantCode, userId, userVipFlag);
        log.info("\u67e5\u8be2\u5230\u5019\u9009\u80cc\u666f\u97f3\u4e50\u6570\u91cf: {}", (Object)audios.size());
        return audios;
    }

    @Override
    public Optional<TdhAudio> findBestMatch(List<TdhAudio> candidates, String scene, List<String> styles) {
        if (CollectionUtils.isEmpty(candidates)) {
            return Optional.empty();
        }
        try {
            List sortedCandidates = candidates.stream().sorted((a1, a2) -> {
                int score1 = this.calculateMatchScore((TdhAudio)a1, scene, styles);
                int score2 = this.calculateMatchScore((TdhAudio)a2, scene, styles);
                return Integer.compare(score2, score1);
            }).collect(Collectors.toList());
            if (!sortedCandidates.isEmpty()) {
                TdhAudio bestMatch = (TdhAudio)sortedCandidates.get(0);
                log.info("\u627e\u5230\u6700\u4f73\u5339\u914d\u80cc\u666f\u97f3\u4e50: {}, \u573a\u666f: {}, \u98ce\u683c: {}, \u5339\u914d\u5206\u6570: {}", new Object[]{bestMatch.getObjectName(), scene, styles, this.calculateMatchScore(bestMatch, scene, styles)});
                return Optional.of(bestMatch);
            }
            return Optional.empty();
        }
        catch (Exception e) {
            log.error("\u67e5\u627e\u6700\u4f73\u5339\u914d\u80cc\u666f\u97f3\u4e50\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
            return Optional.empty();
        }
    }

    @Override
    public List<String> findBestMatchIds(List<TdhAudio> candidates, String scene, List<String> styles) {
        if (CollectionUtils.isEmpty(candidates)) {
            return Collections.emptyList();
        }
        try {
            return candidates.stream().sorted((a1, a2) -> {
                int score1 = this.calculateMatchScore((TdhAudio)a1, scene, styles);
                int score2 = this.calculateMatchScore((TdhAudio)a2, scene, styles);
                return Integer.compare(score2, score1);
            }).limit(3L).map(TdhAudio::getObjectId).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("\u67e5\u627e\u6700\u4f73\u5339\u914d\u80cc\u666f\u97f3\u4e50ID\u5217\u8868\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
            return Collections.emptyList();
        }
    }

    @Override
    public String getRandomAudioId(String tenantCode, String userId, String userVipFlag) {
        try {
            List<TdhAudio> candidates = this.findCandidateAudios(tenantCode, userId, userVipFlag);
            if (CollectionUtils.isEmpty(candidates)) {
                log.warn("\u65e0\u6cd5\u83b7\u53d6\u968f\u673a\u80cc\u666f\u97f3\u4e50ID - \u65e0\u5019\u9009\u80cc\u666f\u97f3\u4e50");
                return null;
            }
            Random random = new Random();
            TdhAudio randomAudio = candidates.get(random.nextInt(candidates.size()));
            log.info("\u83b7\u53d6\u968f\u673a\u80cc\u666f\u97f3\u4e50ID: {}, \u540d\u79f0: {}", (Object)randomAudio.getObjectId(), (Object)randomAudio.getObjectName());
            return randomAudio.getObjectId();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u968f\u673a\u80cc\u666f\u97f3\u4e50ID\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    @Override
    public boolean isAudioExists(String audioId, String tenantCode, String userId, String userVipFlag) {
        log.info("\u68c0\u67e5\u80cc\u666f\u97f3\u4e50\u662f\u5426\u5b58\u5728 - audioId: {}, tenantCode: {}, userId: {}, userVipFlag: {}", new Object[]{audioId, tenantCode, userId, userVipFlag});
        if (StringUtils.isBlank((CharSequence)audioId)) {
            return false;
        }
        int count = this.tdhAudioMapper.checkAudioExists(audioId, tenantCode, userId, userVipFlag);
        boolean exists = count > 0;
        log.info("\u80cc\u666f\u97f3\u4e50\u5b58\u5728\u6027\u68c0\u67e5\u7ed3\u679c - audioId: {}, exists: {}", (Object)audioId, (Object)exists);
        return exists;
    }

    @Override
    public String extractAudioId(TdhAudio audio) {
        return audio != null ? audio.getObjectId() : null;
    }

    private int calculateMatchScore(TdhAudio audio, String scene, List<String> styles) {
        String targetScene;
        String audioScene;
        int score = 0;
        if (StringUtils.isNotBlank((CharSequence)scene) && StringUtils.isNotBlank((CharSequence)audio.getScene()) && ((audioScene = audio.getScene().toLowerCase()).contains(targetScene = scene.toLowerCase()) || targetScene.contains(audioScene))) {
            score += 10;
        }
        if (CollectionUtils.isNotEmpty(styles) && StringUtils.isNotBlank((CharSequence)audio.getStyle())) {
            String audioStyle = audio.getStyle().toLowerCase();
            for (String style : styles) {
                String targetStyle = style.toLowerCase();
                if (!audioStyle.contains(targetStyle) && !targetStyle.contains(audioStyle)) continue;
                score += 5;
            }
        }
        if (audio.getOrderIndex() != null) {
            if (audio.getOrderIndex() <= 100) {
                score += 3;
            } else if (audio.getOrderIndex() <= 500) {
                ++score;
            }
        }
        if ("0".equals(audio.getObjectSource())) {
            score += 2;
        }
        return score;
    }
}

