/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.timer;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nbchat.train.core.bo.BatchJobReportBO;
import com.tydic.nbchat.train.core.service.impl.tdh.TdhAnalysisService;
import com.tydic.nbchat.train.mapper.TdhCreationTaskMapper;
import com.tydic.nicc.dc.boot.starter.entity.RedisLockEntity;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.volcengine.tos.model.object.UploadedPartV2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.task.TaskRejectedException;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class AiTrainVideoAnalysisTimer {
    private static final Logger log = LoggerFactory.getLogger(AiTrainVideoAnalysisTimer.class);
    private static final String REDIS_KEY_FOR_VIDEO_ANALYSIS = "nbchat-train:video-analysis:batch-job-id";
    private static final String NBCHAT_TRAIN_VIDEO_ANALYSIS_LOCK_KEY = "nbchat-train:lock:video-analysis";
    private static final String NBCHAT_TRAIN_VIDEO_ANALYSIS_REPORT_LOCK_KEY = "nbchat-train:lock:video-analysis-report";
    @Value(value="${nbchat-train.config.video-analysis.limit:1000}")
    private int tdhVideoAnalysisLimit;
    @Resource
    private RedisHelper redisHelper;
    @Resource
    private TdhAnalysisService tdhAnalysisService;
    @Resource
    private TdhCreationTaskMapper tdhCreationTaskMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        RedisLockEntity redisLockEntity = RedisLockEntity.builder().lockKey(NBCHAT_TRAIN_VIDEO_ANALYSIS_LOCK_KEY).requestId(IdWorker.nextAutoIdStr()).build();
        boolean locked = this.redisHelper.lock(redisLockEntity, 10L, 1200L);
        try {
            log.info("\u89c6\u9891\u5206\u6790\u4efb\u52a1,\u5f00\u59cb\u6267\u884c:{}-{}", (Object)redisLockEntity, (Object)locked);
            if (locked) {
                this.videoAnalysis();
            }
            log.info("\u89c6\u9891\u5206\u6790\u4efb\u52a1,\u6267\u884c\u5b8c\u6210:{}", (Object)redisLockEntity);
        }
        catch (TaskRejectedException e) {
            log.warn("\u89c6\u9891\u5206\u6790\u4efb\u52a1,\u6267\u884c\u5f02\u5e38\uff0c\u7ebf\u7a0b\u6c60\u5df2\u6ee1:{}", (Object)redisLockEntity);
        }
        catch (Exception e) {
            log.error("\u89c6\u9891\u5206\u6790\u4efb\u52a1,\u6267\u884c\u5f02\u5e38:{}", (Object)redisLockEntity, (Object)e);
        }
        finally {
            if (locked) {
                this.redisHelper.unlockLua(redisLockEntity);
            }
        }
    }

    private void videoAnalysis() {
        String dateStr = DateTimeUtil.getTimeShortString((Date)new Date(), (String)"yyyyMMdd");
        String inputObjectKey = this.tdhAnalysisService.getInputObjectKey(dateStr);
        int count = this.tdhCreationTaskMapper.countTdhForAnalysis();
        if (count < 1500) {
            List tdhAnalysisList = this.tdhCreationTaskMapper.selectTdhForAnalysis();
            String batchJobId = this.tdhAnalysisService.analysisTdh(tdhAnalysisList);
            this.redisHelper.sSet(REDIS_KEY_FOR_VIDEO_ANALYSIS, new Object[]{batchJobId});
            return;
        }
        String uploadId = this.tdhAnalysisService.createMultipartUploadToTos(inputObjectKey);
        if (StringUtils.isBlank((CharSequence)uploadId)) {
            return;
        }
        ArrayList<UploadedPartV2> parts = new ArrayList<UploadedPartV2>();
        int pageNum = 1;
        while (true) {
            log.info("\u89c6\u9891\u5206\u6790\u4efb\u52a1,\u67e5\u8be2\u7b2c {} \u9875\u7684\u9700\u8981\u505a\u5206\u6790\u7684\u89c6\u9891\u4efb\u52a1", (Object)pageNum);
            Page page = PageHelper.startPage((int)pageNum++, (int)this.tdhVideoAnalysisLimit);
            try {
                this.tdhCreationTaskMapper.selectTdhForAnalysis();
                if (page.getTotal() == 0L) {
                    log.info("\u89c6\u9891\u5206\u6790\u4efb\u52a1,\u4e0d\u5b58\u5728\u9700\u8981\u5206\u6790\u7684\u89c6\u9891\u53e3\u64ad\u7a3f");
                    this.tdhAnalysisService.abortMultipartUploadToTos(inputObjectKey, uploadId);
                    return;
                }
                if (CollectionUtils.isEmpty((Collection)page.getResult())) {
                    log.info("\u89c6\u9891\u5206\u6790\u4efb\u52a1,\u4e0d\u518d\u5b58\u5728\u9700\u8981\u5206\u6790\u7684\u89c6\u9891\u53e3\u64ad\u7a3f");
                    break;
                }
                log.info("\u89c6\u9891\u5206\u6790\u4efb\u52a1\uff0c\u6570\u91cf\uff1a{}", (Object)page.getResult().size());
                String eTag = this.tdhAnalysisService.uploadPartToTos(inputObjectKey, uploadId, pageNum, page.getResult());
                if (!StringUtils.isNotBlank((CharSequence)eTag)) continue;
                UploadedPartV2 part = UploadedPartV2.builder().partNumber(pageNum).etag(eTag).build();
                parts.add(part);
                continue;
            }
            finally {
                if (page == null) continue;
                page.close();
                continue;
            }
            break;
        }
        this.tdhAnalysisService.completeMultipartUploadToTos(inputObjectKey, uploadId, parts);
        String batchJobId = this.tdhAnalysisService.analysisTdh(inputObjectKey, dateStr);
        this.redisHelper.sSet(REDIS_KEY_FOR_VIDEO_ANALYSIS, new Object[]{batchJobId});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="0 0/10 1-8 * * ?")
    public void runReport() {
        RedisLockEntity redisLockEntity = RedisLockEntity.builder().lockKey(NBCHAT_TRAIN_VIDEO_ANALYSIS_REPORT_LOCK_KEY).requestId(IdWorker.nextAutoIdStr()).build();
        boolean locked = this.redisHelper.lock(redisLockEntity, 10L, 600L);
        try {
            log.info("\u89c6\u9891\u5206\u6790\u4efb\u52a1,\u5f00\u59cb\u6267\u884c:{}-{}", (Object)redisLockEntity, (Object)locked);
            if (locked) {
                this.videoAnalysisReport();
            }
            log.info("\u89c6\u9891\u5206\u6790\u4efb\u52a1,\u6267\u884c\u5b8c\u6210:{}", (Object)redisLockEntity);
        }
        catch (TaskRejectedException e) {
            log.warn("\u89c6\u9891\u5206\u6790\u4efb\u52a1,\u6267\u884c\u5f02\u5e38\uff0c\u7ebf\u7a0b\u6c60\u5df2\u6ee1:{}", (Object)redisLockEntity);
        }
        catch (Exception e) {
            log.error("\u89c6\u9891\u5206\u6790\u4efb\u52a1,\u6267\u884c\u5f02\u5e38:{}", (Object)redisLockEntity, (Object)e);
        }
        finally {
            if (locked) {
                this.redisHelper.unlockLua(redisLockEntity);
            }
        }
    }

    private void videoAnalysisReport() {
        if (!this.redisHelper.hasKey(REDIS_KEY_FOR_VIDEO_ANALYSIS)) {
            return;
        }
        Set batchJobIdList = this.redisHelper.sGet(REDIS_KEY_FOR_VIDEO_ANALYSIS);
        if (CollectionUtils.isEmpty((Collection)batchJobIdList)) {
            return;
        }
        List<String> batchJobIds = batchJobIdList.stream().map(o -> (String)o).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List<BatchJobReportBO> reports = this.tdhAnalysisService.analysisVideochatReports(batchJobIds);
        reports.forEach(o -> {
            switch (o.getStatus()) {
                case "Queued": 
                case "Initializing": 
                case "Running": {
                    break;
                }
                case "Completed": {
                    this.tdhAnalysisService.videoAnalysisReport(o.getId(), o.getOutputObjectKey());
                }
                case "Terminating": 
                case "Terminated": 
                case "Failed": {
                    this.redisHelper.setRemove(REDIS_KEY_FOR_VIDEO_ANALYSIS, new Object[]{o.getId()});
                }
            }
        });
    }
}

