/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.timer;

import com.tydic.nbchat.train.api.bo.asr_tts.TtsVoiceTaskContext;
import com.tydic.nbchat.train.api.bo.asr_tts.TtsVoiceTaskRequest;
import com.tydic.nbchat.train.api.bo.eums.AnchorType;
import com.tydic.nbchat.train.api.bo.eums.FileUploadDirEnum;
import com.tydic.nbchat.train.core.config.NbchatTrainConfigProperties;
import com.tydic.nbchat.train.core.helper.NlsStrategyInvokeFactory;
import com.tydic.nbchat.train.mapper.NbchatTrainSceneDialogueMapper;
import com.tydic.nbchat.train.mapper.po.NbchatTrainSceneDialogue;
import com.tydic.nicc.dc.boot.starter.entity.RedisLockEntity;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(value={"nbchat-train.config.scene-audio-enable"}, havingValue="true")
@EnableScheduling
@Component
public class AutoGeneSceneAudioTimer {
    private static final Logger log = LoggerFactory.getLogger(AutoGeneSceneAudioTimer.class);
    private final NlsStrategyInvokeFactory nlsStrategyInvokeFactory;
    private final NbchatTrainConfigProperties nbchatTrainConfigProperties;
    private final RedisHelper redisHelper;
    @Resource
    private NbchatTrainSceneDialogueMapper nbchatTrainSceneDialogueMapper;
    private static final String NBCHAT_TRAIN_GENE_SCENE_AUDIO_LOCK_KEY = "nbchat-train:lock:gene-scene-audio";

    public AutoGeneSceneAudioTimer(NlsStrategyInvokeFactory nlsStrategyInvokeFactory, NbchatTrainConfigProperties nbchatTrainConfigProperties, RedisHelper redisHelper) {
        this.nlsStrategyInvokeFactory = nlsStrategyInvokeFactory;
        this.nbchatTrainConfigProperties = nbchatTrainConfigProperties;
        this.redisHelper = redisHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedRate=5000L)
    public void run() {
        RedisLockEntity redisLockEntity = RedisLockEntity.builder().lockKey(NBCHAT_TRAIN_GENE_SCENE_AUDIO_LOCK_KEY).requestId(IdWorker.nextAutoIdStr()).build();
        boolean locked = this.redisHelper.lock(redisLockEntity, 10L, 1200L);
        try {
            if (locked) {
                NbchatTrainSceneDialogue record = new NbchatTrainSceneDialogue();
                record.setAudioState("0");
                record.setStartTime(DateTimeUtil.DateAddHour((int)-2));
                record.setEndTime(new Date());
                List dialogues = this.nbchatTrainSceneDialogueMapper.selectByCondition(record);
                log.info("\u81ea\u52a8\u751f\u6210\u573a\u666f\u97f3\u9891\u4efb\u52a1: \u5bf9\u8bdd\u6570\u91cf = {}", (Object)dialogues.size());
                for (NbchatTrainSceneDialogue dialogue : dialogues) {
                    TtsVoiceTaskRequest request = new TtsVoiceTaskRequest();
                    request.setAsync(false);
                    request.setCourseId("0");
                    request.setSectionId(FileUploadDirEnum.TTS_DIR.getCode());
                    request.setAnchorType(this.nbchatTrainConfigProperties.getTtsType());
                    request.setVoice(AnchorType.getDefaultVoiceByCode((String)request.getAnchorType()));
                    request.setText(dialogue.getContent());
                    TtsVoiceTaskContext context = this.nlsStrategyInvokeFactory.getApi().createAudioTask(request);
                    if (context == null || !StringUtils.isNotBlank((CharSequence)context.getAudio_address())) continue;
                    dialogue.setAudioState("1");
                    dialogue.setAudioUrl(context.getAudio_address());
                    dialogue.setId(dialogue.getId());
                    this.nbchatTrainSceneDialogueMapper.updateByPrimaryKeySelective(dialogue);
                }
            }
        }
        catch (Exception e) {
            log.error("\u81ea\u52a8\u751f\u6210\u573a\u666f\u97f3\u9891\u4efb\u52a1-\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            if (locked) {
                this.redisHelper.unlockLua(redisLockEntity);
            }
        }
    }
}

