/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.timer;

import com.tydic.nbchat.train.mapper.NbchatTrainTaskDegreeMapper;
import com.tydic.nbchat.train.mapper.po.NbchatTrainTaskDegree;
import com.tydic.nicc.dc.boot.starter.entity.RedisLockEntity;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(value={"nbchat-train.config.degree-timer-enable"}, havingValue="true")
@EnableScheduling
@Component
public class DegreeCheckTimer {
    private static final Logger log = LoggerFactory.getLogger(DegreeCheckTimer.class);
    @Resource
    NbchatTrainTaskDegreeMapper nbchatTrainTaskDegreeMapper;
    private final RedisHelper redisHelper;
    private static final String NBCHAT_TRAIN_DEGREE_CHECK_LOCK_KEY = "nbchat-train:lock:degree-check";

    public DegreeCheckTimer(RedisHelper redisHelper) {
        this.redisHelper = redisHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="0 0 1 * * ?")
    public void run() {
        RedisLockEntity redisLockEntity = RedisLockEntity.builder().lockKey(NBCHAT_TRAIN_DEGREE_CHECK_LOCK_KEY).requestId(IdWorker.nextAutoIdStr()).build();
        boolean locked = this.redisHelper.lock(redisLockEntity, 10L, 300L);
        try {
            if (locked) {
                NbchatTrainTaskDegree po = new NbchatTrainTaskDegree();
                po.setStatus("1");
                List degrees = this.nbchatTrainTaskDegreeMapper.selectAll(po);
                if (CollectionUtils.isEmpty((Collection)degrees)) {
                    return;
                }
                log.info("\u8bc1\u4e66\u6709\u6548\u671f\u68c0\u67e5: size = {}", (Object)degrees.size());
                for (NbchatTrainTaskDegree degree : degrees) {
                    LocalDate localDate = degree.getIssueDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                    if (!(localDate = localDate.plusMonths(degree.getValidityPeriod().intValue())).isBefore(LocalDate.now())) continue;
                    degree.setStatus("2");
                    this.nbchatTrainTaskDegreeMapper.update(degree);
                }
            }
        }
        catch (Exception e) {
            log.error("\u8bc1\u4e66\u6709\u6548\u671f\u68c0\u67e5-\u5f02\u5e38: ", (Throwable)e);
        }
        finally {
            if (locked) {
                this.redisHelper.unlock(redisLockEntity);
            }
        }
    }
}

