/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.timer;

import com.alibaba.fastjson.JSON;
import com.tydic.nbchat.train.api.bo.tdh.TdhNoticeTaskBO;
import com.tydic.nbchat.train.api.tdh.TdhNoticeApi;
import com.tydic.nbchat.train.mapper.NameMapper;
import com.tydic.nbchat.train.mapper.PptCreationRecordMapper;
import com.tydic.nbchat.train.mapper.TdhCreationTaskMapper;
import com.tydic.nbchat.train.mapper.TdhNoticeTaskMapper;
import com.tydic.nbchat.train.mapper.po.PptCreationRecord;
import com.tydic.nbchat.train.mapper.po.TdhCreationTask;
import com.tydic.nbchat.train.mapper.po.TdhNoticeTask;
import com.tydic.nbchat.user.api.NoticeApi;
import com.tydic.nbchat.user.api.bo.eums.SmsTemplateEnum;
import com.tydic.nbchat.user.api.bo.eums.WxTemplateEnum;
import com.tydic.nbchat.user.api.bo.notice.NoticeContext;
import com.tydic.nicc.common.nbchat.msg.SendMessageContext;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.entity.RedisLockEntity;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.mq.starter.api.KKMqProducerHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
@ConditionalOnProperty(value={"nbchat-train.config.notice-timer-enable"}, havingValue="true")
public class TdhNoticeTimer {
    private static final Logger log = LoggerFactory.getLogger(TdhNoticeTimer.class);
    @Resource
    private NameMapper nameMapper;
    @Resource
    private RedisHelper redisHelper;
    @Resource
    private TdhNoticeApi tdhNoticeApi;
    @Resource
    private KKMqProducerHelper kkMqProducerHelper;
    @Resource
    private TdhNoticeTaskMapper tdhNoticeTaskMapper;
    @Resource
    private TdhCreationTaskMapper tdhCreationTaskMapper;
    @Resource
    private PptCreationRecordMapper pptCreationRecordMapper;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=3000)
    private NoticeApi noticeApi;
    public static final String VIDEO_NOTICE_LOCK_KEY = "nbchat-train:lock:video-notice";
    public static final String PPT_NOTICE_LOCK_KEY = "nbchat-train:lock:ppt-notice";
    public static final String CUSTOM_NOTICE_LOCK_KEY = "nbchat-train:lock:custom-notice";
    private static final String EVENT_TYPE_1 = "1";
    private static final String EVENT_TYPE_2 = "2";
    private static final String EVENT_TYPE_3 = "3";
    private static final String EVENT_TYPE_4 = "4";
    private static final String EVENT_TYPE_5 = "5";
    private static final String MP_PATH_PPT = "pages/pptPreview/index?pptId=";
    private static final String MP_PATH_VIDEO = "pages/workList/previewPage?taskId=";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedRate=60000L)
    public void runVideo() {
        RedisLockEntity redisLockEntity = RedisLockEntity.builder().lockKey(VIDEO_NOTICE_LOCK_KEY).requestId(IdWorker.nextAutoIdStr()).build();
        boolean locked = this.redisHelper.lock(redisLockEntity);
        try {
            if (!locked) {
                return;
            }
            this.processNoticeTasks(() -> this.tdhNoticeTaskMapper.getVideoNoticeList(), task -> {
                TdhCreationTask res = this.tdhCreationTaskMapper.queryById(task.getTaskId());
                return TdhNoticeTaskBO.builder().userId(task.getUserId()).taskId(task.getTaskId()).smsTempCode(SmsTemplateEnum.FIRST_VIDEO_FINISH.getTemplateID()).creationName(res.getCreationName()).build();
            });
            List tdhNoticeTasks = this.tdhNoticeTaskMapper.selectVideoFin();
            if (CollectionUtils.isEmpty((Collection)tdhNoticeTasks)) {
                return;
            }
            tdhNoticeTasks.forEach(task -> this.sendNotice((TdhNoticeTask)task, EVENT_TYPE_1, task.getCreationName()));
        }
        catch (Exception e) {
            log.error("\u901a\u77e5,\u6267\u884c\u5f02\u5e38:{}", (Object)redisLockEntity, (Object)e);
        }
        finally {
            if (locked) {
                this.redisHelper.unlockLua(redisLockEntity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedRate=60000L)
    public void runPPT() {
        RedisLockEntity redisLockEntity = RedisLockEntity.builder().lockKey(PPT_NOTICE_LOCK_KEY).requestId(IdWorker.nextAutoIdStr()).build();
        boolean locked = this.redisHelper.lock(redisLockEntity);
        try {
            if (!locked) {
                return;
            }
            this.processNoticeTasks(() -> this.tdhNoticeTaskMapper.getPptNoticeList(), task -> {
                PptCreationRecord res = this.pptCreationRecordMapper.queryById(task.getTaskId());
                return TdhNoticeTaskBO.builder().userId(task.getUserId()).taskId(task.getTaskId()).smsTempCode(SmsTemplateEnum.FIRST_PPT_FINISH.getTemplateID()).creationName(res.getCreationName()).build();
            });
            List tdhNoticeTasks = this.tdhNoticeTaskMapper.selectPPTFin();
            if (CollectionUtils.isEmpty((Collection)tdhNoticeTasks)) {
                return;
            }
            tdhNoticeTasks.forEach(task -> this.sendNotice((TdhNoticeTask)task, EVENT_TYPE_5, task.getCreationName()));
        }
        catch (Exception e) {
            log.error("\u901a\u77e5,\u6267\u884c\u5f02\u5e38:{}", (Object)redisLockEntity, (Object)e);
        }
        finally {
            if (locked) {
                this.redisHelper.unlockLua(redisLockEntity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedRate=60000L)
    public void runCustom() {
        RedisLockEntity redisLockEntity = RedisLockEntity.builder().lockKey(CUSTOM_NOTICE_LOCK_KEY).requestId(IdWorker.nextAutoIdStr()).build();
        boolean locked = this.redisHelper.lock(redisLockEntity);
        try {
            if (!locked) {
                return;
            }
            List tdhNoticeTasks = this.tdhNoticeTaskMapper.selectCustFin();
            if (CollectionUtils.isEmpty((Collection)tdhNoticeTasks)) {
                return;
            }
            this.processNoticeTasks(() -> tdhNoticeTasks, task -> {
                TdhNoticeTaskBO.TdhNoticeTaskBOBuilder builder = TdhNoticeTaskBO.builder().userId(task.getUserId()).taskId(null);
                if (EVENT_TYPE_3.equals(task.getEventType())) {
                    builder.smsTempCode(SmsTemplateEnum.HUMAN_CUSTOMIZATION_COMPLETED.getTemplateID());
                } else if (EVENT_TYPE_4.equals(task.getEventType())) {
                    builder.smsTempCode(SmsTemplateEnum.VOICE_CUSTOMIZATION_COMPLETED.getTemplateID());
                }
                builder.creationName(this.nameMapper.queryCustomizeRecord(task.getTaskId()));
                return builder.build();
            });
            tdhNoticeTasks.forEach(task -> this.sendNotice((TdhNoticeTask)task, task.getEventType(), this.nameMapper.queryCustomizeRecord(task.getTaskId())));
        }
        catch (Exception e) {
            log.error("\u901a\u77e5,\u6267\u884c\u5f02\u5e38:{}", (Object)redisLockEntity, (Object)e);
        }
        finally {
            if (locked) {
                this.redisHelper.unlockLua(redisLockEntity);
            }
        }
    }

    private void sendNotice(TdhNoticeTask task, String eventType, String creationName) {
        this.sendWxNotice(this.buildCreationTask(task, eventType, creationName));
        this.sendMsgNotice(task, eventType);
        task.setNoteState(EVENT_TYPE_1);
        task.setUpdateTime(new Date());
        this.tdhNoticeTaskMapper.update(task);
    }

    private TdhCreationTask buildCreationTask(TdhNoticeTask task, String eventType, String creationName) {
        TdhCreationTask creationTask = new TdhCreationTask();
        creationTask.setTaskId(task.getTaskId());
        creationTask.setCreationName(creationName);
        creationTask.setEndTime(task.getCreateTime());
        creationTask.setUserId(task.getUserId());
        creationTask.setEventType(eventType);
        return creationTask;
    }

    private void processNoticeTasks(Supplier<List<TdhNoticeTask>> taskSupplier, Function<TdhNoticeTask, TdhNoticeTaskBO> smsBuilder) {
        List<TdhNoticeTask> tasks = taskSupplier.get();
        for (TdhNoticeTask task : tasks) {
            if (this.redisHelper.sHasKey("nbchat-user:notice:gray_list", (Object)task.getTenantCode())) {
                log.info("\u901a\u77e5-\u79df\u6237\u5728\u7070\u540d\u5355\u4e2d\uff0c\u4e0d\u901a\u77e5:{}", (Object)task.getTenantCode());
                continue;
            }
            TdhNoticeTaskBO request = smsBuilder.apply(task);
            Rsp<?> send = this.sendSMS(request);
            task.setNoteResult(JSON.toJSONString(send));
            task.setUpdateTime(new Date());
            this.tdhNoticeTaskMapper.update(task);
        }
    }

    public Rsp<?> sendSMS(TdhNoticeTaskBO request) {
        try {
            return this.tdhNoticeApi.sendNotice(request);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u77ed\u4fe1\u5f02\u5e38\uff1a", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)"\u53d1\u9001\u77ed\u4fe1\u5f02\u5e38");
        }
    }

    public void sendWxNotice(TdhCreationTask creationTask) {
        try {
            String eventType;
            NoticeContext context = new NoticeContext();
            ArrayList<Object> params = new ArrayList<Object>();
            Object name = creationTask.getCreationName();
            if (name != null && ((String)name).length() > 14) {
                name = ((String)name).substring(0, 10) + "...";
            }
            switch (eventType = creationTask.getEventType()) {
                case "1": {
                    params.add("\u300a" + (String)name + "\u300b\u89c6\u9891\u751f\u6210");
                    context.setPath(MP_PATH_VIDEO + creationTask.getTaskId());
                    break;
                }
                case "3": {
                    params.add("\u300a" + (String)name + "\u300b\u6570\u5b57\u4eba\u5f62\u8c61\u5b9a\u5236");
                    break;
                }
                case "4": {
                    params.add("\u300a" + (String)name + "\u300b\u58f0\u97f3\u97f3\u8272\u590d\u523b");
                    break;
                }
                case "5": {
                    params.add("\u300a" + (String)name + "\u300bPPT\u751f\u6210");
                    context.setPath(MP_PATH_PPT + creationTask.getTaskId());
                    break;
                }
                default: {
                    params.add("\u300a" + (String)name + "\u300b");
                }
            }
            params.add(ObjectUtils.isEmpty((Object)creationTask.getTaskId()) ? "\u5df2\u590d\u523b\u5b8c\u6210" : "\u5df2\u5236\u4f5c\u5b8c\u6210");
            params.add(DateTimeUtil.getTimeShortString((Date)creationTask.getEndTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            context.setUserId(creationTask.getUserId());
            context.setTemplateType(WxTemplateEnum.VIDEO.getCode());
            context.setParams(params);
            context.setUrl(creationTask.getPlayUrl());
            this.noticeApi.officialNotice(context);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u516c\u4f17\u53f7\u901a\u77e5\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    private void sendMsgNotice(TdhNoticeTask task, String eventType) {
        try {
            SendMessageContext context;
            switch (eventType) {
                case "1": {
                    context = SendMessageContext.buildForVideoFinish((String)task.getTenantCode(), (String)task.getUserId(), (String)task.getTaskId(), (String)task.getCreationName());
                    break;
                }
                case "3": {
                    context = SendMessageContext.buildForTdhFinish((String)task.getTenantCode(), (String)task.getUserId());
                    break;
                }
                case "4": {
                    context = SendMessageContext.buildForAudioFinish((String)task.getTenantCode(), (String)task.getUserId());
                    break;
                }
                case "5": {
                    context = SendMessageContext.buildForPptFinish((String)task.getTenantCode(), (String)task.getUserId(), (String)task.getTaskId(), (String)task.getCreationName());
                    break;
                }
                default: {
                    return;
                }
            }
            log.info("\u53d1\u9001\u7ad9\u5185\u4fe1\u901a\u77e5\u4e8b\u4ef6\u6d88\u606f: {}", (Object)context);
            this.kkMqProducerHelper.sendMsg("NBCHAT_SYS_MESSAGE_RECORD_TOPIC", (Object)SendMessageContext.buildForPptFinish((String)task.getTenantCode(), (String)task.getUserId(), (String)task.getTaskId(), (String)task.getCreationName()));
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u7ad9\u5185\u4fe1\u901a\u77e5\u4e8b\u4ef6\u6d88\u606f\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }
}

