/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.util;

import com.tydic.nbchat.train.api.bo.asr_tts.TtsVoiceResult;
import com.tydic.nbchat.train.api.bo.asr_tts.TtsWordResult;
import com.tydic.nbchat.train.core.util.TrainCommonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class OptimizedSubtitlesUtil {
    private static final Pattern CHINESE_CHAR_PATTERN = Pattern.compile("[\\u4e00-\\u9fa5]");
    private static final Pattern JAPANESE_CHAR_PATTERN = Pattern.compile("[\\u3040-\\u30FF\\u31F0-\\u31FF\\uFF65-\\uFF9F]");

    public static boolean isEnglishSubtitles(List<TtsVoiceResult> subtitles) {
        StringBuilder textBuilder = new StringBuilder();
        for (TtsVoiceResult tts : subtitles) {
            textBuilder.append(TrainCommonUtil.removeXMLTags(tts.getText()));
        }
        String text = textBuilder.toString();
        if (text.isEmpty()) {
            return false;
        }
        if ((text = text.trim()).isEmpty()) {
            return false;
        }
        int englishCount = 0;
        int chineseCount = 0;
        for (char c : text.toCharArray()) {
            if (c >= '\u4e00' && c <= '\u9fa5') {
                ++chineseCount;
                continue;
            }
            ++englishCount;
        }
        return (double)englishCount / (double)(englishCount + chineseCount) > 0.9;
    }

    public static boolean isChineseDominant(String text) {
        String content = TrainCommonUtil.removeXMLTags(text);
        if (StringUtils.isEmpty((CharSequence)content)) {
            return false;
        }
        int chineseCount = 0;
        int japaneseCount = 0;
        int totalCount = 0;
        for (char c : content.toCharArray()) {
            if (Character.isWhitespace(c)) continue;
            ++totalCount;
            if (OptimizedSubtitlesUtil.isChineseCharacter(c)) {
                ++chineseCount;
                continue;
            }
            if (!OptimizedSubtitlesUtil.isJapaneseCharacter(c)) continue;
            ++japaneseCount;
        }
        return totalCount > 0 && (double)chineseCount / (double)totalCount > 0.7 && chineseCount > japaneseCount;
    }

    private static boolean isChineseCharacter(char c) {
        Matcher matcher = CHINESE_CHAR_PATTERN.matcher(String.valueOf(c));
        return matcher.find();
    }

    private static boolean isJapaneseCharacter(char c) {
        Matcher matcher = JAPANESE_CHAR_PATTERN.matcher(String.valueOf(c));
        return matcher.find();
    }

    public static String removeLastPunctuation(String text) {
        if (text == null) {
            return "";
        }
        if (text.length() > 1 && (text.endsWith(",") || text.endsWith("\uff0c") || text.endsWith(".") || text.endsWith("!") || text.endsWith("\uff01") || text.endsWith("\u3001") || text.endsWith("\uff1b") || text.endsWith(";") || text.endsWith("\u3002") || text.endsWith("\uff1a"))) {
            return text.substring(0, text.length() - 1);
        }
        return text;
    }

    public static String trim_enter_blank(String text) {
        if (text != null) {
            text = text.trim();
            text = text.replaceAll("\t|\n|\r\n", "");
        }
        return text;
    }

    public static List<TtsVoiceResult> optimizeSubtitles(List<TtsVoiceResult> list) {
        boolean is_optimized = true;
        ArrayList<TtsVoiceResult> optimizedList = new ArrayList<TtsVoiceResult>();
        for (TtsVoiceResult tts : list) {
            int start_time = tts.getBegin_Time();
            int end_time = tts.getEnd_time();
            String text = tts.getText();
            if ((text = OptimizedSubtitlesUtil.trim_enter_blank(text)).isEmpty()) continue;
            if (text.length() > 22) {
                float durationPerChar = (float)(end_time - start_time) / (float)text.length();
                String[] sentences = text.split("(?<=([\u3002\uff01\uff1f\uff1b]))");
                for (int i = 0; i < sentences.length; ++i) {
                    String sentence = sentences[i];
                    end_time = Math.round((float)start_time + (float)sentence.length() * durationPerChar);
                    if (sentence.isEmpty()) continue;
                    TtsVoiceResult obj = OptimizedSubtitlesUtil.buildTtsObject(start_time, end_time, sentence);
                    optimizedList.add(obj);
                    start_time = i < sentences.length - 1 ? end_time : tts.getEnd_time();
                    if (sentence.length() <= 22) continue;
                    is_optimized = false;
                }
                continue;
            }
            optimizedList.add(tts);
        }
        if (!is_optimized) {
            return OptimizedSubtitlesUtil.optimizeSubtitlesSub(optimizedList, 22);
        }
        return optimizedList;
    }

    public static List<String> splitText(String text, int maxLine) {
        ArrayList<String> list = new ArrayList<String>();
        int len = text.length();
        int start = 0;
        int end = maxLine;
        while (start < len) {
            if (end > len) {
                end = len;
            }
            list.add(text.substring(start, end));
            start = end;
            end += maxLine;
        }
        return list;
    }

    public static List<TtsVoiceResult> splitByCharLen(TtsVoiceResult tts) {
        int start_time = tts.getBegin_Time();
        int end_time = tts.getEnd_time();
        float durationPerChar = (float)(end_time - start_time) / (float)tts.getText().length();
        List<String> list = OptimizedSubtitlesUtil.splitText(tts.getText(), 25);
        ArrayList<TtsVoiceResult> resultList = new ArrayList<TtsVoiceResult>();
        for (int i = 0; i < list.size(); ++i) {
            String text = list.get(i);
            end_time = Math.round((float)start_time + (float)text.length() * durationPerChar);
            TtsVoiceResult obj = OptimizedSubtitlesUtil.buildTtsObject(start_time, end_time, text);
            start_time = i < list.size() - 1 ? end_time : tts.getEnd_time();
            resultList.add(obj);
        }
        return resultList;
    }

    public static List<TtsVoiceResult> optimizeSubtitlesSub(List<TtsVoiceResult> tts, int lineLimit) {
        ArrayList<TtsVoiceResult> optimizedList = new ArrayList<TtsVoiceResult>();
        for (TtsVoiceResult ttsVoiceResult : tts) {
            String text = ttsVoiceResult.getText();
            int start_time = ttsVoiceResult.getBegin_Time();
            int end_time = ttsVoiceResult.getEnd_time();
            if (text.isEmpty()) continue;
            if (text.length() > lineLimit) {
                float durationPerChar = (float)(end_time - start_time) / (float)text.length();
                String[] sentences = text.split("(?<=([\uff0c\u3001]))");
                List<String> newSentences = Arrays.asList(sentences);
                for (int i = 0; i < newSentences.size(); ++i) {
                    String sentence = newSentences.get(i);
                    end_time = Math.round((float)start_time + (float)sentence.length() * durationPerChar);
                    if (sentence.isEmpty()) continue;
                    TtsVoiceResult obj = OptimizedSubtitlesUtil.buildTtsObject(start_time, end_time, sentence);
                    start_time = i < newSentences.size() - 1 ? end_time : ttsVoiceResult.getEnd_time();
                    if (obj.getText().length() > 22) {
                        optimizedList.addAll(OptimizedSubtitlesUtil.splitByCharLen(obj));
                        continue;
                    }
                    optimizedList.add(obj);
                }
                continue;
            }
            TtsVoiceResult obj = new TtsVoiceResult();
            obj.setBegin_Time(ttsVoiceResult.getBegin_Time());
            obj.setEnd_time(ttsVoiceResult.getEnd_time());
            obj.setText(OptimizedSubtitlesUtil.removeLastPunctuation(text));
            optimizedList.add(obj);
        }
        return optimizedList;
    }

    private static TtsVoiceResult buildTtsObject(int start_time, int end_time, String text) {
        TtsVoiceResult ttsVoiceResult = new TtsVoiceResult();
        ttsVoiceResult.setBegin_Time(Integer.valueOf(start_time));
        ttsVoiceResult.setEnd_time(Integer.valueOf(end_time));
        ttsVoiceResult.setText(text);
        return ttsVoiceResult;
    }

    public static List<TtsWordResult> calculateWordTime(String sentence, int start, int end) {
        ArrayList<TtsWordResult> words = new ArrayList<TtsWordResult>();
        if (sentence != null && !sentence.isEmpty()) {
            float word_time = (float)(end - start) / (float)sentence.length();
            for (int i = 0; i < sentence.length(); ++i) {
                TtsWordResult result = new TtsWordResult();
                result.setS(sentence.substring(i, i + 1));
                result.setStart(Integer.valueOf(Math.round((float)start + word_time * (float)i)));
                result.setEnd(Integer.valueOf(Math.round((float)start + word_time * (float)(i + 1))));
                words.add(result);
            }
        }
        return words;
    }

    public static List<TtsVoiceResult> optimizeEnglishSubtitles(List<TtsVoiceResult> list) {
        ArrayList<TtsVoiceResult> optimizedSubtitles = new ArrayList<TtsVoiceResult>();
        int lineLimit = 50;
        for (TtsVoiceResult subtitle : list) {
            String text = subtitle.getText();
            int startTime = subtitle.getBegin_Time();
            int endTime = subtitle.getEnd_time();
            if (text.isEmpty()) continue;
            if (text.length() > lineLimit) {
                double durationPerChar = (double)(endTime - startTime) / (double)text.length();
                String[] sentences = text.split("\\. ");
                ArrayList<String> newSentences = new ArrayList<String>();
                for (String sentence : sentences) {
                    if (sentence.length() > lineLimit) {
                        String[] subSentences;
                        for (String subSentence : subSentences = sentence.split(", ")) {
                            if (subSentence.length() > lineLimit) {
                                String[] subSubSentences;
                                for (String subSubSentence : subSubSentences = subSentence.split("; ")) {
                                    if (subSubSentence.length() > lineLimit) {
                                        String[] words = subSubSentence.split(" ");
                                        StringBuilder tempSentence = new StringBuilder();
                                        for (String word : words) {
                                            if (tempSentence.length() + word.length() + 1 > lineLimit) {
                                                newSentences.add(tempSentence.toString().trim());
                                                tempSentence = new StringBuilder(word);
                                                continue;
                                            }
                                            tempSentence.append(" ").append(word);
                                        }
                                        if (tempSentence.length() <= 0) continue;
                                        newSentences.add(tempSentence.toString().trim());
                                        continue;
                                    }
                                    newSentences.add(subSubSentence.trim());
                                }
                                continue;
                            }
                            newSentences.add(subSentence.trim());
                        }
                        continue;
                    }
                    newSentences.add(sentence.trim());
                }
                for (String newSentence : newSentences) {
                    if (newSentence.trim().isEmpty()) continue;
                    int newEndTime = startTime + (int)((double)newSentence.length() * durationPerChar);
                    optimizedSubtitles.add(new TtsVoiceResult(Integer.valueOf(startTime), Integer.valueOf(newEndTime), newSentence, ""));
                    startTime = newEndTime;
                }
                continue;
            }
            optimizedSubtitles.add(new TtsVoiceResult(Integer.valueOf(startTime), Integer.valueOf(endTime), text, ""));
        }
        return optimizedSubtitles;
    }

    public static void main(String[] args) {
        String text1 = "\u4ee5\u4e0b\u306e\u8bf4\u660e\u3067\u306f\u3001\u65f6\u4ee3\u80cc\u666f\u3068\u793e\u4f1a\u6784\u9020\u3001\u5929\u4e0b\u7edf\u4e00\u3092\u76ee\u6307\u3057\u305f\u4e09\u4eba\u306e\u6770\u51fa\u3057\u305f\u4eba\u7269\u3001\u6226\u56fd\u5927\u540d\u306e\u30bf\u30a4\u30d7\u5206\u6790\u3001\u305d\u3057\u3066\u6226\u56fd\u65f6\u4ee3\u306e\u6b74\u53f2\u7684\u5f71\u54cd\u3068\u3044\u3046\u4fa7\u9762\u304b\u3089\u5c55\u5f00\u3057\u307e\u3059\u3002";
        String text2 = "\u3053\u308c\u306f\u30c6\u30b9\u30c8\u3067\u3059\u3002\u5c11\u3057\u3060\u3051\u4e2d\u6587\u304c\u3042\u308a\u307e\u3059\u3002";
        System.out.println("Text1 is Chinese dominant: " + OptimizedSubtitlesUtil.isChineseDominant(text1));
        System.out.println("Text2 is Chinese dominant: " + OptimizedSubtitlesUtil.isChineseDominant(text2));
    }
}

