/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.util;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.tydic.nbchat.train.core.util.RegularUtil;
import com.tydic.nbchat.train.mapper.po.PptTheme;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PptThemeMatcherProcessor {
    private static final Logger log = LoggerFactory.getLogger(PptThemeMatcherProcessor.class);

    public static Optional<PptTheme> findBestMatch(List<PptTheme> themes, List<String> targetStyles, List<String> targetColors) {
        ArrayList<MatchScore> fullMatches = new ArrayList<MatchScore>();
        ArrayList<MatchScore> styleMatches = new ArrayList<MatchScore>();
        ArrayList<MatchScore> sceneMatches = new ArrayList<MatchScore>();
        for (PptTheme theme : themes) {
            List<String> styles = RegularUtil.arryStrParseToList(theme.getStyle());
            List<String> colors = RegularUtil.arryStrParseToList(theme.getColor());
            int styleMatchCount = PptThemeMatcherProcessor.countMatches(styles, targetStyles);
            int colorMatchCount = PptThemeMatcherProcessor.countMatches(colors, targetColors);
            if (styleMatchCount > 0 && colorMatchCount > 0) {
                fullMatches.add(new MatchScore(theme));
                continue;
            }
            if (styleMatchCount > 0) {
                styleMatches.add(new MatchScore(theme));
                continue;
            }
            sceneMatches.add(new MatchScore(theme));
        }
        if (!fullMatches.isEmpty()) {
            return PptThemeMatcherProcessor.pickBestByStar(fullMatches);
        }
        if (!styleMatches.isEmpty()) {
            return PptThemeMatcherProcessor.pickBestByStar(styleMatches);
        }
        return PptThemeMatcherProcessor.pickBestByStar(sceneMatches);
    }

    private static int countMatches(List<String> themeAttributes, List<String> targetAttributes) {
        int matchCount = 0;
        if (CollectionUtils.isEmpty(themeAttributes) || CollectionUtils.isEmpty(targetAttributes)) {
            return matchCount;
        }
        for (String targetAttribute : targetAttributes) {
            if (!themeAttributes.contains(targetAttribute)) continue;
            ++matchCount;
        }
        return matchCount;
    }

    private static Optional<PptTheme> pickBestByStar(List<MatchScore> matches) {
        if (matches.isEmpty()) {
            return Optional.empty();
        }
        Map<Integer, List<MatchScore>> starMap = matches.stream().collect(Collectors.groupingBy(MatchScore::getStar));
        for (int starLevel = 3; starLevel >= 0; --starLevel) {
            List<MatchScore> starList = starMap.get(starLevel);
            if (starList == null || starList.isEmpty()) continue;
            return Optional.of(starList.get(ThreadLocalRandom.current().nextInt(starList.size())).getTheme());
        }
        return Optional.of(matches.get(ThreadLocalRandom.current().nextInt(matches.size())).getTheme());
    }

    static class MatchScore {
        private final PptTheme theme;
        private final int star;

        public MatchScore(PptTheme theme) {
            this.theme = theme;
            this.star = MatchScore.parseStar(theme.getStar());
        }

        public PptTheme getTheme() {
            return this.theme;
        }

        public int getStar() {
            return this.star;
        }

        private static int parseStar(String starStr) {
            if (starStr == null) {
                return 0;
            }
            try {
                return Integer.parseInt(starStr.trim());
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
    }
}

