/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.util;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.HashMap;

public class QRCodeGenerator {
    public static String generateQRCodeImage(String text) throws Exception {
        String filePath = "/tmp/" + System.currentTimeMillis() + "_qr.png";
        QRCodeGenerator.generateQRCodeImage(text, 140, 140, filePath);
        return filePath;
    }

    private static void generateQRCodeImage(String text, int width, int height, String filePath) throws WriterException, IOException {
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        HashMap<EncodeHintType, ErrorCorrectionLevel> hints = new HashMap<EncodeHintType, ErrorCorrectionLevel>();
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.L);
        BitMatrix bitMatrix = qrCodeWriter.encode(text, BarcodeFormat.QR_CODE, width, height, hints);
        bitMatrix = QRCodeGenerator.deleteWhite(bitMatrix);
        Path path = FileSystems.getDefault().getPath(filePath, new String[0]);
        MatrixToImageWriter.writeToPath((BitMatrix)bitMatrix, (String)"PNG", (Path)path);
    }

    private static BitMatrix deleteWhite(BitMatrix matrix) {
        int[] rec = matrix.getEnclosingRectangle();
        int resWidth = rec[2] + 1;
        int resHeight = rec[3] + 1;
        BitMatrix resMatrix = new BitMatrix(resWidth, resHeight);
        resMatrix.clear();
        for (int i = 0; i < resWidth; ++i) {
            for (int j = 0; j < resHeight; ++j) {
                if (!matrix.get(i + rec[0], j + rec[1])) continue;
                resMatrix.set(i, j);
            }
        }
        return resMatrix;
    }

    public static void main(String[] args) {
        try {
            QRCodeGenerator.generateQRCodeImage("https://chatfiles-test.tydiczt.com/files/202408/c4882cd18ce53181361aaa6ab779ff40.png", 140, 140, "/tmp/2.png");
            System.out.println("QR Code image created successfully!");
        }
        catch (Exception e) {
            System.err.println("Could not generate QR Code, WriterException :: " + e.getMessage());
        }
    }
}

