/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.util;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegularUtil {
    public static String extractFileNameWithoutExtension(String urlString) {
        Pattern pattern = Pattern.compile("/([^/]+)\\.[^\\.]+$");
        Matcher matcher = pattern.matcher(urlString);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String extractJsonString(String content) {
        char endChar;
        char startChar;
        int startIndex;
        if (content == null || content.trim().isEmpty()) {
            return null;
        }
        int startObjIndex = content.indexOf(123);
        int startArrIndex = content.indexOf(91);
        if (startObjIndex >= 0 && (startArrIndex < 0 || startObjIndex < startArrIndex)) {
            startIndex = startObjIndex;
            startChar = '{';
            endChar = '}';
        } else if (startArrIndex >= 0) {
            startIndex = startArrIndex;
            startChar = '[';
            endChar = ']';
        } else {
            return null;
        }
        int depth = 0;
        boolean inQuotes = false;
        boolean escape = false;
        for (int i = startIndex; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (escape) {
                escape = false;
                continue;
            }
            if (c == '\\') {
                escape = true;
                continue;
            }
            if (c == '\"') {
                inQuotes = !inQuotes;
                continue;
            }
            if (inQuotes) continue;
            if (c == startChar) {
                ++depth;
                continue;
            }
            if (c != endChar || --depth != 0) continue;
            return content.substring(startIndex, i + 1);
        }
        return null;
    }

    public static List<String> arryStrParseToList(String input) {
        return input != null ? Arrays.asList(input.replace("[", "").replace("]", "").replace("\"", "").trim().split(",")) : List.of();
    }
}

