/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.tydic.nbchat.train.api.bo.asr_tts.TtsVoiceResult;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SrtToJsonConverter {
    private static int timeToMillis(String time) {
        String[] parts = time.split(":|,");
        int h = Integer.parseInt(parts[0]);
        int m = Integer.parseInt(parts[1]);
        int s = Integer.parseInt(parts[2]);
        int ms = Integer.parseInt(parts[3]);
        return h * 3600000 + m * 60000 + s * 1000 + ms;
    }

    public static List<TtsVoiceResult> parseSrt(String srtContent) {
        ArrayList<TtsVoiceResult> list = new ArrayList<TtsVoiceResult>();
        Pattern pattern = Pattern.compile("(\\d+)\\s+([\\d:,]+)\\s-->\\s([\\d:,]+)\\s+([\\s\\S]*?)(?=\\n\\d+|\\z)", 8);
        Matcher matcher = pattern.matcher(srtContent);
        while (matcher.find()) {
            String start = matcher.group(2).trim();
            String end = matcher.group(3).trim();
            String text = matcher.group(4).replace("\n", "").replace("\r", "").trim();
            list.add(new TtsVoiceResult(Integer.valueOf(SrtToJsonConverter.timeToMillis(start)), Integer.valueOf(SrtToJsonConverter.timeToMillis(end)), text, text, ""));
        }
        return list;
    }

    public static String toJson(List<TtsVoiceResult> subtitles) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        return mapper.writeValueAsString(subtitles);
    }

    public static String toTtsResu(List<TtsVoiceResult> subtitles) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        return mapper.writeValueAsString(subtitles);
    }

    public static void main(String[] args) throws IOException {
        String srt = new String(Files.readAllBytes(Paths.get("/Users/kangkang/Downloads/sample.srt", new String[0])), "UTF-8");
        List<TtsVoiceResult> subtitles = SrtToJsonConverter.parseSrt(srt);
        String json = SrtToJsonConverter.toJson(subtitles);
        System.out.println(json);
    }
}

