/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.util;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.tydic.nbchat.train.core.util.RegularUtil;
import com.tydic.nbchat.train.mapper.po.TdhTemplate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TdhTemplateMatcherProcessor {
    private static final Logger log = LoggerFactory.getLogger(TdhTemplateMatcherProcessor.class);

    public static List<String> findBestMatchIds(List<TdhTemplate> templates, List<String> targetStyles, List<String> targetColors) {
        if (CollectionUtils.isEmpty(templates)) {
            return new ArrayList<String>();
        }
        ArrayList<MatchScore> fullMatches = new ArrayList<MatchScore>();
        ArrayList<MatchScore> styleMatches = new ArrayList<MatchScore>();
        ArrayList<MatchScore> sceneMatches = new ArrayList<MatchScore>();
        for (TdhTemplate template : templates) {
            List<String> styles = RegularUtil.arryStrParseToList(template.getStyle());
            List<String> colors = RegularUtil.arryStrParseToList(template.getColor());
            int styleMatchCount = TdhTemplateMatcherProcessor.countMatches(styles, targetStyles);
            int colorMatchCount = TdhTemplateMatcherProcessor.countMatches(colors, targetColors);
            if (styleMatchCount > 0 && colorMatchCount > 0) {
                fullMatches.add(new MatchScore(template));
                continue;
            }
            if (styleMatchCount > 0) {
                styleMatches.add(new MatchScore(template));
                continue;
            }
            sceneMatches.add(new MatchScore(template));
        }
        List<String> result = !fullMatches.isEmpty() ? TdhTemplateMatcherProcessor.pickBestMatchesByPriorityWithLimit(fullMatches, 3) : (!styleMatches.isEmpty() ? TdhTemplateMatcherProcessor.pickBestMatchesByPriorityWithLimit(styleMatches, 3) : TdhTemplateMatcherProcessor.pickBestMatchesByPriorityWithLimit(sceneMatches, 3));
        return result;
    }

    public static Optional<TdhTemplate> findBestMatch(List<TdhTemplate> templates, List<String> targetStyles, List<String> targetColors) {
        List<String> templateIds = TdhTemplateMatcherProcessor.findBestMatchIds(templates, targetStyles, targetColors);
        if (templateIds.isEmpty()) {
            return Optional.empty();
        }
        String selectedId = templateIds.get(ThreadLocalRandom.current().nextInt(templateIds.size()));
        return templates.stream().filter(template -> selectedId.equals(template.getTpId())).findFirst();
    }

    private static int countMatches(List<String> templateAttributes, List<String> targetAttributes) {
        int matchCount = 0;
        if (CollectionUtils.isEmpty(templateAttributes) || CollectionUtils.isEmpty(targetAttributes)) {
            return matchCount;
        }
        for (String targetAttribute : targetAttributes) {
            if (!templateAttributes.contains(targetAttribute)) continue;
            ++matchCount;
        }
        return matchCount;
    }

    private static List<String> pickBestMatchesByPriority(List<MatchScore> matches) {
        if (matches.isEmpty()) {
            return new ArrayList<String>();
        }
        Map<Integer, List<MatchScore>> priorityMap = matches.stream().collect(Collectors.groupingBy(MatchScore::getPriority));
        List sortedPriorities = priorityMap.keySet().stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        for (Integer priority : sortedPriorities) {
            List<MatchScore> priorityList = priorityMap.get(priority);
            if (priorityList == null || priorityList.isEmpty()) continue;
            return priorityList.stream().map(matchScore -> matchScore.getTemplate().getTpId()).collect(Collectors.toList());
        }
        return matches.stream().map(matchScore -> matchScore.getTemplate().getTpId()).collect(Collectors.toList());
    }

    private static List<String> pickBestMatchesByPriorityWithLimit(List<MatchScore> matches, int limit) {
        List sortedPriorities;
        Integer highestPriority;
        if (matches.isEmpty() || limit <= 0) {
            return new ArrayList<String>();
        }
        Map<Integer, List<MatchScore>> priorityMap = matches.stream().collect(Collectors.groupingBy(MatchScore::getPriority));
        List<MatchScore> highestPriorityList = priorityMap.get(highestPriority = (Integer)(sortedPriorities = priorityMap.keySet().stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList())).get(0));
        if (highestPriorityList != null && highestPriorityList.size() >= limit) {
            return highestPriorityList.stream().map(matchScore -> matchScore.getTemplate().getTpId()).collect(Collectors.toList());
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Integer priority : sortedPriorities) {
            List<MatchScore> priorityList = priorityMap.get(priority);
            if (priorityList == null || priorityList.isEmpty()) continue;
            List priorityIds = priorityList.stream().map(matchScore -> matchScore.getTemplate().getTpId()).collect(Collectors.toList());
            int remaining = limit - result.size();
            if (priorityIds.size() <= remaining) {
                result.addAll(priorityIds);
            } else {
                result.addAll(priorityIds.subList(0, remaining));
            }
            if (result.size() < limit) continue;
            break;
        }
        return result;
    }

    private static Optional<TdhTemplate> pickBestByPriority(List<MatchScore> matches) {
        if (matches.isEmpty()) {
            return Optional.empty();
        }
        Map<Integer, List<MatchScore>> priorityMap = matches.stream().collect(Collectors.groupingBy(MatchScore::getPriority));
        List sortedPriorities = priorityMap.keySet().stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        for (Integer priority : sortedPriorities) {
            List<MatchScore> priorityList = priorityMap.get(priority);
            if (priorityList == null || priorityList.isEmpty()) continue;
            return Optional.of(priorityList.get(ThreadLocalRandom.current().nextInt(priorityList.size())).getTemplate());
        }
        return Optional.of(matches.get(ThreadLocalRandom.current().nextInt(matches.size())).getTemplate());
    }

    static class MatchScore {
        private final TdhTemplate template;
        private final int priority;

        public MatchScore(TdhTemplate template) {
            this.template = template;
            this.priority = template.getPriority() != null ? template.getPriority() : 1;
        }

        public TdhTemplate getTemplate() {
            return this.template;
        }

        public int getPriority() {
            return this.priority;
        }
    }
}

