/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainCommonUtil {
    private static final Logger log = LoggerFactory.getLogger(TrainCommonUtil.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static void main(String[] args) {
        String text = "<speak><emotion style=''>\u5927\u5bb6\u597d\u3002\u6211\u662f\u53c2\u5c55\u4eba\u5c0f\u753b\u5bb6\u3002\u975e\u5e38\u8363\u5e78\u80fd\u4e0e\u5927\u5bb6\u5206\u4eab\u6211\u7684\u7ed8\u753b\u4e16\u754c\u3002\u4eca\u5929\u3002\u6211\u8981\u5411\u5927\u5bb6\u4ecb\u7ecd\u7684\u7b2c\u4e00\u5e45\u4f5c\u54c1\u662f\u300a\u6d77\u5929\u4e00\u8272\u300b\u3002\u8fd9\u5e45\u753b\u662f\u6211\u5bf9\u81ea\u7136\u4e4b\u7f8e\u7684\u8d5e\u6b4c\u3002\u5b83\u4e0d\u4ec5\u5c55\u73b0\u4e86\u6211\u5bf9\u827a\u672f\u7684\u70ed\u7231\u3002\u66f4\u662f\u6211\u5185\u5fc3\u4e16\u754c\u7684\u53cd\u6620\u3002\u5728\u8fd9\u7247\u5e7f\u88a4\u7684\u5927\u6d77\u4e0a\u3002\u5929\u7a7a\u4e0e\u6d77\u6d0b\u4eff\u4f5b\u65e0\u7f1d\u8854\u63a5\u3002\u5206\u4e0d\u6e05\u54ea\u91cc\u662f\u5929\u3002\u54ea\u91cc\u662f\u6d77\u3002\u6211\u7528\u660e\u4eae\u7684\u8272\u5f69\u548c\u7ec6\u817b\u7684\u7b14\u89e6\u3002\u5c3d\u529b\u6355\u6349\u8fd9\u5b81\u9759\u800c\u58ee\u4e3d\u7684\u666f\u8c61\u3002\u521b\u4f5c\u8fd9\u5e45\u753b\u7684\u8fc7\u7a0b\u4e2d\u3002\u6211\u6df1\u53d7\u5927\u81ea\u7136\u7684\u529b\u91cf\u548c\u548c\u8c10\u6240\u542f\u53d1\u3002\u6211\u5e0c\u671b\u89c2\u8005\u80fd\u5728\u8fd9\u5e45\u4f5c\u54c1\u4e2d\u611f\u53d7\u5230\u6211\u5bf9\u4e16\u754c\u7684\u656c\u754f\u4ee5\u53ca\u6211\u5bf9\u7f8e\u597d\u751f\u6d3b\u7684\u5411\u5f80\u3002\u5728\u63a5\u4e0b\u6765\u7684\u65e5\u5b50\u91cc\u3002\u6211\u8fd8\u5c06\u5206\u4eab\u66f4\u591a\u6211\u5fc3\u4e2d\u7684\u8272\u5f69\u548c\u6545\u4e8b\u3002\u656c\u8bf7\u671f\u5f85\u3002\\n</emotion></speak>";
        System.out.println(TrainCommonUtil.trimXmlTagName(text, "emotion"));
    }

    public static void writeWavFromBase64(String base64, String filePath) {
        byte[] bytes = Base64.getDecoder().decode(base64);
        TrainCommonUtil.writeBytesToFile(bytes, filePath);
    }

    public static void writeBytesToFile(byte[] bytes, String filePath) {
        try {
            Files.write(Paths.get(filePath, new String[0]), bytes, new OpenOption[0]);
        }
        catch (IOException e) {
            log.error("Failed to write bytes to file", (Throwable)e);
        }
    }

    public static String hmacSha256AndBase64Encode(String text, String secret) {
        try {
            Mac sha256HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), "HmacSHA256");
            sha256HMAC.init(secretKey);
            byte[] hashedBytes = sha256HMAC.doFinal(text.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(hashedBytes);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to calculate HMAC-SHA256", e);
        }
    }

    public static String removeXMLTags(String text) {
        String regex = "<[^>]+>";
        Pattern pattern = Pattern.compile(regex);
        String result = pattern.matcher(text).replaceAll("");
        return result;
    }

    public static String trimXmlTagName(String content, String tagName) {
        String regex = "<" + tagName + ".*?>|</" + tagName + ">";
        return content.replaceAll(regex, "");
    }

    public static String extractJson(String text) {
        log.info("\u63d0\u53d6json\u6570\u7ec4\uff1a{}", (Object)text);
        if (StringUtils.isBlank((CharSequence)text)) {
            return text;
        }
        int index1 = text.indexOf("[");
        int index2 = text.indexOf("{");
        String jsonString = "";
        if (index1 == -1 && index2 == -1) {
            log.info("\u63d0\u53d6json\u6570\u7ec4-\u63d0\u53d6\u6765\u6e90\u4e2d\u4e0d\u5305\u542bjson\u4e32");
            return text;
        }
        try {
            if (index1 < index2) {
                startIndex = text.indexOf("[");
                int endIndex = text.lastIndexOf("]");
                jsonString = text.substring(startIndex, endIndex + 1);
            } else {
                startIndex = text.indexOf("{");
                int endIndex = text.lastIndexOf("}");
                jsonString = text.substring(startIndex, endIndex + 1);
            }
            JsonNode jsonNode = objectMapper.readTree(jsonString);
            log.debug("Extracted JSON:{}", (Object)jsonNode.toString());
            return jsonNode.toString();
        }
        catch (Exception e) {
            log.warn("\u63d0\u53d6json\u6570\u7ec4-\u5f02\u5e38:text = {},err = {}", (Object)text, (Object)e.getMessage());
            return text;
        }
    }
}

