/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.web;

import com.tydic.nbchat.train.api.bo.ppt.ImageConversionReqBO;
import com.tydic.nbchat.train.api.bo.ppt.PPTCounterQueryReqBO;
import com.tydic.nbchat.train.api.bo.ppt.PPTCreationRecordBO;
import com.tydic.nbchat.train.api.bo.ppt.PPTLayoutBO;
import com.tydic.nbchat.train.api.bo.ppt.PPTSortReqBO;
import com.tydic.nbchat.train.api.bo.ppt.PPTThemeBO;
import com.tydic.nbchat.train.api.bo.ppt.PPTThemeMatchReqBO;
import com.tydic.nbchat.train.api.bo.ppt.PPTThemeReqBO;
import com.tydic.nbchat.train.api.ppt.PPTApi;
import com.tydic.nbchat.train.api.ppt.PPTThemeApi;
import com.tydic.nicc.common.bo.premission.Logical;
import com.tydic.nicc.common.bo.premission.RequiresRole;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/train/ppt"})
public class PPTController {
    private static final Logger log = LoggerFactory.getLogger(PPTController.class);
    private final PPTApi pptApi;
    private final PPTThemeApi pptThemeApi;

    public PPTController(PPTApi pptApi, PPTThemeApi pptThemeApi) {
        this.pptApi = pptApi;
        this.pptThemeApi = pptThemeApi;
    }

    @PostMapping(value={"/day/count"})
    public Rsp pptDayCount(@Validated @RequestBody PPTCounterQueryReqBO request) {
        return BaseRspUtils.createSuccessRsp((Object)this.pptApi.getPptCounterDay(request));
    }

    @PostMapping(value={"/save"})
    public Rsp save(@RequestBody PPTCreationRecordBO request) {
        return this.pptApi.save(request);
    }

    @PostMapping(value={"/theme/delete"})
    public Rsp delete(@RequestBody PPTCreationRecordBO request) {
        return this.pptApi.delete(request);
    }

    @PostMapping(value={"/theme/copy"})
    public Rsp copyTheme(@RequestBody PPTCreationRecordBO request) {
        return this.pptApi.copyTheme(request);
    }

    @PostMapping(value={"query"})
    public Rsp query(@RequestBody PPTCreationRecordBO request) {
        return this.pptApi.query(request);
    }

    @PostMapping(value={"layout/query"})
    public Rsp layoutQuery(@RequestBody PPTLayoutBO request) {
        return this.pptApi.layoutQuery(request);
    }

    @PostMapping(value={"layout/info"})
    public Rsp layoutQueryInfo(@RequestBody PPTLayoutBO request) {
        request.setTenantCode(null);
        request.setUserId(null);
        return this.pptApi.layoutQuery(request);
    }

    @PostMapping(value={"theme/query"})
    public RspList themeQuery(@RequestBody PPTThemeBO request) {
        return this.pptApi.themeQuery(request);
    }

    @PostMapping(value={"theme/star/list"})
    public RspList themeStarList(@RequestBody PPTThemeBO request) {
        return this.pptApi.themeStarList(request);
    }

    @PostMapping(value={"theme/info"})
    public Rsp themeInfo(@RequestBody PPTThemeBO request) {
        return this.pptApi.themeInfo(request);
    }

    @RequiresRole(value={"sysAdmin", "tenantAdmin"}, logical=Logical.OR)
    @PostMapping(value={"/theme/admin_list"})
    public RspList themeAdminList(@RequestBody PPTThemeBO request) {
        return this.pptApi.themeAdminList(request);
    }

    @PostMapping(value={"theme/save"})
    public Rsp themeSave(@RequestBody PPTThemeReqBO request) {
        return this.pptApi.themeSave(request);
    }

    @PostMapping(value={"image/conversion"})
    public RspList imageConversion(@RequestBody ImageConversionReqBO reqBO) {
        return this.pptApi.imageConversion(reqBO);
    }

    @PostMapping(value={"/query/create/history"})
    public RspList queryCreateHistory(@RequestBody PPTCreationRecordBO request) {
        return this.pptApi.queryCreateHistory(request);
    }

    @PostMapping(value={"/copy/history"})
    public Rsp copyHistory(@RequestBody PPTCreationRecordBO request) {
        return this.pptApi.copyHistory(request);
    }

    @PostMapping(value={"/release/template"})
    public Rsp releaseTemplate(@RequestBody PPTThemeReqBO request) {
        return this.pptApi.releaseTemplate(request);
    }

    @PostMapping(value={"/sort/update"})
    public Rsp sort(@RequestBody PPTSortReqBO request) {
        return this.pptApi.sort(request);
    }

    @PostMapping(value={"/theme/match"})
    public Rsp matchTheme(@RequestBody PPTThemeMatchReqBO request) {
        return this.pptApi.matchTheme(request);
    }

    @PostMapping(value={"/theme/ai_match"})
    public Rsp aiMatchTheme(@RequestBody PPTThemeMatchReqBO request) {
        return this.pptThemeApi.aiMatchTheme(request);
    }

    @PostMapping(value={"/query/content"})
    public Rsp queryContent(@RequestBody PPTCreationRecordBO request) {
        return this.pptApi.queryByPptId(request);
    }
}

