/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.web;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nbchat.train.core.service.impl.tdh.TdhAnalysisService;
import com.tydic.nbchat.train.core.timer.AiTrainVideoAnalysisTimer;
import com.tydic.nbchat.train.mapper.TdhCreationAnalysisMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/train/tdh/analysis"})
public class TdhAnalysisTaskController {
    private static final Logger log = LoggerFactory.getLogger(TdhAnalysisTaskController.class);
    private final TdhAnalysisService tdhAnalysisService;
    private final TdhCreationAnalysisMapper tdhCreationAnalysisMapper;
    private final AiTrainVideoAnalysisTimer aiTrainVideoAnalysisTimer;

    @PostMapping(value={"/run"})
    public void run() {
        this.aiTrainVideoAnalysisTimer.run();
    }

    @PostMapping(value={"/runReport"})
    public void runReport() {
        this.aiTrainVideoAnalysisTimer.runReport();
    }

    @PostMapping(value={"/manual/upload"})
    public void manualUpload(@RequestParam(value="file") MultipartFile file) {
        log.info("\u624b\u52a8\u4e0a\u4f20\u89c6\u9891\u89e3\u6790\u7ed3\u679c");
        if (file.isEmpty()) {
            log.info("\u624b\u52a8\u4e0a\u4f20\u89c6\u9891\u89e3\u6790\u7ed3\u679c\u5f02\u5e38\uff1a\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        JSONArray jsonArray = new JSONArray();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(file.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                jsonArray.add((Object)JSONObject.parseObject((String)line));
            }
        }
        catch (IOException e) {
            log.info("\u6587\u4ef6\u5904\u7406\u5931\u8d25", (Throwable)e);
            return;
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            this.tdhAnalysisService.analysisContent(jsonArray.getJSONObject(i));
        }
    }

    public TdhAnalysisTaskController(TdhAnalysisService tdhAnalysisService, TdhCreationAnalysisMapper tdhCreationAnalysisMapper, AiTrainVideoAnalysisTimer aiTrainVideoAnalysisTimer) {
        this.tdhAnalysisService = tdhAnalysisService;
        this.tdhCreationAnalysisMapper = tdhCreationAnalysisMapper;
        this.aiTrainVideoAnalysisTimer = aiTrainVideoAnalysisTimer;
    }
}

