/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.web;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nbchat.robot.api.bo.RobotMessageRequest;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@RestController
@RequestMapping(value={"/v1"})
public class TestV1ApiController {
    private static final Logger log = LoggerFactory.getLogger(TestV1ApiController.class);
    private static final SseEmitter emitter = new SseEmitter();

    @PostMapping(value={"/chat/completions"})
    public void chatProcessEvent1(@RequestBody RobotMessageRequest request, HttpServletResponse res) throws Exception {
        res.setContentType("text/event-stream;charset=UTF-8");
        String result = "\u6211\u662f\u767e\u5ea6\u516c\u53f8\u5f00\u53d1\u7684\u4eba\u5de5\u667a\u80fd\u8bed\u8a00\u6a21\u578b\uff0c\u6211\u7684\u4e2d\u6587\u540d\u662f\u6587\u5fc3\u4e00\u8a00\uff0c\u82f1\u6587\u540d\u662fERNIE Bot\uff0c\u53ef\u4ee5\u534f\u52a9\u60a8\u5b8c\u6210\u8303\u56f4\u5e7f\u6cdb\u7684\u4efb\u52a1\u5e76\u63d0\u4f9b\u6709\u5173\u5404\u79cd\u4e3b\u9898\u7684\u4fe1\u606f\uff0c\u6bd4\u5982\u56de\u7b54\u95ee\u9898\uff0c\u63d0\u4f9b\u5b9a\u4e49\u548c\u89e3\u91ca\u53ca\u5efa\u8bae\u3002\u5982\u679c\u60a8\u6709\u4efb\u4f55\u95ee\u9898\uff0c\u8bf7\u968f\u65f6\u5411\u6211\u63d0\u95ee\u3002";
        int start = 0;
        int step = 5;
        String content = "";
        boolean finish = false;
        do {
            JSONObject context = null;
            if (start + step >= result.length()) {
                content = result.substring(start, result.length());
                step = result.length();
                context = TestV1ApiController.buildContext("stop", content);
                finish = true;
            } else {
                content = result.substring(start, start + step);
                start += 5;
                context = TestV1ApiController.buildContext("", content);
            }
            log.info("\u63a8\u9001\u6570\u636e:{}", (Object)context);
            try {
                res.getWriter().write("data: " + context.toJSONString() + "\n\n");
                res.getWriter().flush();
            }
            catch (Exception e) {
                log.error("\u63a8\u9001\u6570\u636e-\u5f02\u5e38:{}", (Object)context, (Object)e);
            }
        } while (!finish);
        res.getWriter().write("data: [done]\n\n");
        res.getWriter().flush();
    }

    @PostMapping(value={"/chat/completions1"})
    public SseEmitter chatProcessEvent(@RequestBody RobotMessageRequest request) {
        String result = "\u6211\u662f\u767e\u5ea6\u516c\u53f8\u5f00\u53d1\u7684\u4eba\u5de5\u667a\u80fd\u8bed\u8a00\u6a21\u578b\uff0c\u6211\u7684\u4e2d\u6587\u540d\u662f\u6587\u5fc3\u4e00\u8a00\uff0c\u82f1\u6587\u540d\u662fERNIE Bot\uff0c\u53ef\u4ee5\u534f\u52a9\u60a8\u5b8c\u6210\u8303\u56f4\u5e7f\u6cdb\u7684\u4efb\u52a1\u5e76\u63d0\u4f9b\u6709\u5173\u5404\u79cd\u4e3b\u9898\u7684\u4fe1\u606f\uff0c\u6bd4\u5982\u56de\u7b54\u95ee\u9898\uff0c\u63d0\u4f9b\u5b9a\u4e49\u548c\u89e3\u91ca\u53ca\u5efa\u8bae\u3002\u5982\u679c\u60a8\u6709\u4efb\u4f55\u95ee\u9898\uff0c\u8bf7\u968f\u65f6\u5411\u6211\u63d0\u95ee\u3002";
        int start = 0;
        int step = 5;
        String content = "";
        boolean finish = false;
        do {
            JSONObject context = null;
            if (start + step >= result.length()) {
                content = result.substring(start, result.length());
                step = result.length();
                context = TestV1ApiController.buildContext("stop", content);
                finish = true;
            } else {
                content = result.substring(start, start + step);
                start += 5;
                context = TestV1ApiController.buildContext("", content);
            }
            log.info("\u63a8\u9001\u6570\u636e:{}", (Object)context);
            try {
                TimeUnit.MILLISECONDS.sleep(1000L);
                emitter.send((Object)context);
            }
            catch (Exception e) {
                log.error("\u63a8\u9001\u6570\u636e-\u5f02\u5e38:{}", (Object)context, (Object)e);
            }
        } while (!finish);
        log.info("\u63a8\u9001\u6570\u636e:\u7ed3\u675f");
        emitter.complete();
        return emitter;
    }

    public static JSONObject buildContext(String finish, String text) {
        String autoId = IdWorker.nextAutoIdStr();
        String template = "{\n  \"id\": \"" + autoId + "\",\n  \"object\": \"chat.completion\",\n  \"created\": " + System.currentTimeMillis() + ",\n  \"model\": \"dic-knoledge\",\n  \"choices\": [{\n    \"index\": 0, \n    \"message\": {\n      \"role\": \"assistant\", \n      \"content\": \"" + text + "\" \n    },\n    \"finish_reason\": \"" + finish + "\" \n  }],\n  \"usage\": {\n    \"prompt_tokens\": 0,\n    \"total_tokens\": 0,\n    \"completion_tokens\": 0 \n  }\n}";
        return JSONObject.parseObject((String)template);
    }
}

