/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.web;

import com.tydic.nbchat.train.api.NbchatTrainCourseApi;
import com.tydic.nbchat.train.api.bo.course.NbchatTrainCourseTextBO;
import com.tydic.nbchat.train.api.bo.course.TrainCourseHotHubBO;
import com.tydic.nbchat.train.api.bo.course.TrainCourseSectionsQueryReqBO;
import com.tydic.nbchat.train.api.bo.course.TranCourseQueryReqBO;
import com.tydic.nbchat.train.api.bo.course.TranCourseSaveReqBO;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/train/course"})
public class TrainCourseController {
    private static final Logger log = LoggerFactory.getLogger(TrainCourseController.class);
    private final NbchatTrainCourseApi nbchatTrainCourseApi;

    public TrainCourseController(NbchatTrainCourseApi nbchatTrainCourseApi) {
        this.nbchatTrainCourseApi = nbchatTrainCourseApi;
    }

    @PostMapping(value={"/list"})
    public RspList getCourses(@RequestBody TranCourseQueryReqBO request) {
        return this.nbchatTrainCourseApi.getCourses(request);
    }

    @PostMapping(value={"/get"})
    public Rsp getCourse(@RequestBody TranCourseQueryReqBO request) {
        return this.nbchatTrainCourseApi.getCourse(request);
    }

    @PostMapping(value={"/delete"})
    public Rsp deleteCourse(@RequestBody TranCourseQueryReqBO request) {
        return this.nbchatTrainCourseApi.deleteCourse(request);
    }

    @PostMapping(value={"/save"})
    public Rsp saveCourse(@RequestBody TranCourseSaveReqBO request) {
        return this.nbchatTrainCourseApi.saveCourse(request);
    }

    @PostMapping(value={"/newType"})
    public Rsp newCourse(@RequestBody TranCourseSaveReqBO request) {
        return this.nbchatTrainCourseApi.newCourse(request);
    }

    @PostMapping(value={"/topHub"})
    public RspList getTopHubCourse(@RequestBody TrainCourseHotHubBO request) {
        return this.nbchatTrainCourseApi.getTopHubCourse(request);
    }

    @PostMapping(value={"/content"})
    public Rsp getCourseContent(@RequestBody NbchatTrainCourseTextBO request) {
        return this.nbchatTrainCourseApi.getCourseContent(request);
    }

    @PostMapping(value={"/content/save"})
    public Rsp saveCourseContent(@RequestBody NbchatTrainCourseTextBO request) {
        return this.nbchatTrainCourseApi.saveCourseContent(request);
    }

    @PostMapping(value={"/sections/save"})
    public Rsp saveCourseSections(@RequestBody TrainCourseSectionsQueryReqBO request) {
        return this.nbchatTrainCourseApi.saveCourseSections(request);
    }

    @PostMapping(value={"/sections/query"})
    public Rsp queryCourseSections(@RequestBody TrainCourseSectionsQueryReqBO request) {
        return this.nbchatTrainCourseApi.queryCourseSections(request);
    }
}

