/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.web;

import com.tydic.nbchat.train.api.NbchatExamRuleTestApi;
import com.tydic.nbchat.train.api.bo.examRule.ExamRuleBO;
import com.tydic.nbchat.train.api.bo.examRule.ExamRuleReqBO;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/train/exam/rule"})
public class TrainExamRuleController {
    private static final Logger log = LoggerFactory.getLogger(TrainExamRuleController.class);
    private final NbchatExamRuleTestApi nbchatExamRuleTestApi;

    @PostMapping(value={"/save"})
    public Rsp save(@RequestBody ExamRuleBO request) {
        Rsp rsp = this.nbchatExamRuleTestApi.save(request);
        return rsp;
    }

    @PostMapping(value={"/query"})
    public Rsp query(@RequestBody ExamRuleReqBO request) {
        Rsp rsp = this.nbchatExamRuleTestApi.query(request);
        return rsp;
    }

    @PostMapping(value={"/queryExamRule"})
    public RspList queryExamRule(@RequestBody ExamRuleReqBO request) {
        return this.nbchatExamRuleTestApi.getCourseExamList(request);
    }

    @PostMapping(value={"/putOnShelves"})
    public Rsp putOnShelves(@RequestBody ExamRuleReqBO request) {
        return this.nbchatExamRuleTestApi.putOnShelves(request);
    }

    @PostMapping(value={"/export"})
    public Rsp export(@RequestBody ExamRuleReqBO request) {
        return this.nbchatExamRuleTestApi.export(request);
    }

    @PostMapping(value={"/export/question"})
    public Rsp exportQuestion(@RequestBody ExamRuleReqBO request) {
        return this.nbchatExamRuleTestApi.exportQuestion(request);
    }

    @PostMapping(value={"/import"})
    public Rsp importFile(HttpServletRequest request) throws Exception {
        String courseId = request.getParameter("courseId");
        String tenantCode = request.getParameter("tenantCode");
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{courseId, tenantCode})) {
            return BaseRspUtils.createErrorRsp((String)"\u8bfe\u7a0bid\u3001\u79df\u6237\u7f16\u7801\u4e0d\u5f97\u4e3a\u7a7a");
        }
        log.info("\u8bd5\u9898\u5bfc\u5165\u8bf7\u6c42\u4f53: {}|{}", (Object)courseId, (Object)tenantCode);
        MultipartHttpServletRequest req = (MultipartHttpServletRequest)request;
        List files = req.getFiles("files");
        InputStream inputStream = ((MultipartFile)files.get(0)).getInputStream();
        return this.nbchatExamRuleTestApi.importFile(inputStream, courseId, tenantCode);
    }

    public TrainExamRuleController(NbchatExamRuleTestApi nbchatExamRuleTestApi) {
        this.nbchatExamRuleTestApi = nbchatExamRuleTestApi;
    }
}

