/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.web;

import com.tydic.nbchat.train.api.NbchatExamTestApi;
import com.tydic.nbchat.train.api.bo.eums.TrainCommonState;
import com.tydic.nbchat.train.api.bo.exam.ExamTestCreateReqBO;
import com.tydic.nbchat.train.api.bo.exam.ExamTestResultReqBO;
import com.tydic.nbchat.train.api.bo.exam.ExamTestResultRspBO;
import com.tydic.nbchat.train.api.bo.exam.ExamTestSubmitReqBO;
import com.tydic.nbchat.train.core.service.impl.event.EventPublishFactory;
import com.tydic.nbchat.train.mapper.po.NbchatTrainRecord;
import com.tydic.nicc.dc.base.bo.Rsp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/train/exam"})
public class TrainExamTestController {
    private static final Logger log = LoggerFactory.getLogger(TrainExamTestController.class);
    private final NbchatExamTestApi nbchatExamTestApi;

    public TrainExamTestController(NbchatExamTestApi nbchatExamTestApi) {
        this.nbchatExamTestApi = nbchatExamTestApi;
    }

    @PostMapping(value={"/user/test/paper"})
    public Rsp getExamTestPaper(@RequestBody ExamTestCreateReqBO request) {
        return this.nbchatExamTestApi.createExamTest(request);
    }

    @PostMapping(value={"/user/test/submit"})
    public Rsp submitExamTestPaper(@RequestBody ExamTestSubmitReqBO request) {
        Rsp rsp = this.nbchatExamTestApi.submitExamTestPaper(request);
        if (rsp.isSuccess()) {
            NbchatTrainRecord data = (NbchatTrainRecord)rsp.getData();
            if (TrainCommonState.PASS.getCode().equals(data.getTestPassState())) {
                EventPublishFactory.publishUserCompleteTaskEvent(request.getTenantCode(), request.getUserId());
            }
        }
        ExamTestResultReqBO req = new ExamTestResultReqBO();
        req.setCourseId(request.getCourseId());
        req.setUserId(request.getUserId());
        return this.getExamTestResult(req);
    }

    @PostMapping(value={"/user/test/result"})
    public Rsp<ExamTestResultRspBO> getExamTestResult(@RequestBody ExamTestResultReqBO request) {
        return this.nbchatExamTestApi.getExamTestResult(request);
    }
}

