/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.web;

import com.tydic.nbchat.train.api.bo.asr_tts.AsrVoiceTaskContext;
import com.tydic.nbchat.train.api.bo.asr_tts.TtsReqBO;
import com.tydic.nbchat.train.api.bo.asr_tts.TtsVoiceTaskContext;
import com.tydic.nbchat.train.api.bo.asr_tts.TtsVoiceTaskRequest;
import com.tydic.nbchat.train.core.helper.NlsStrategyInvokeFactory;
import com.tydic.nbchat.train.core.util.TrainCommonUtil;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/train/course/tts"})
public class TrainTTSController {
    private static final Logger log = LoggerFactory.getLogger(TrainTTSController.class);
    private final NlsStrategyInvokeFactory nlsStrategyInvokeFactory;

    public TrainTTSController(NlsStrategyInvokeFactory nlsStrategyInvokeFactory) {
        this.nlsStrategyInvokeFactory = nlsStrategyInvokeFactory;
    }

    @PostMapping(value={"/task/create"})
    public Rsp<AsrVoiceTaskContext> createTtsTask(@RequestBody TtsVoiceTaskRequest request) {
        String text = TrainCommonUtil.removeXMLTags(request.getText()).trim();
        if (StringUtils.isBlank((CharSequence)text.trim())) {
            return BaseRspUtils.createErrorRsp((String)"\u8bf7\u8f93\u5165\u6587\u672c\u5185\u5bb9!");
        }
        TtsVoiceTaskContext context = this.nlsStrategyInvokeFactory.createAudioTask(request);
        if (context.isSuccess()) {
            return BaseRspUtils.createSuccessRsp((Object)context);
        }
        return BaseRspUtils.createErrorRsp((Object)context, (String)"\u8bed\u97f3\u5408\u6210\u5f02\u5e38!");
    }

    @PostMapping(value={"new"})
    public TtsVoiceTaskContext createTts(@RequestBody TtsReqBO reqBO) {
        log.info("tts\u5f00\u59cb :{}", (Object)reqBO);
        return this.nlsStrategyInvokeFactory.getApi().createAudioTask(reqBO.getCourseId(), reqBO.getSectionId(), reqBO.getTxt(), true);
    }

    @Deprecated
    @PostMapping(value={"course"})
    public void createCourseTts(@RequestBody TtsReqBO reqBO) {
        log.info("tts\u5f00\u59cb :{}", (Object)reqBO);
    }
}

