/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.web;

import com.tydic.nbchat.train.api.bo.train.scene.NbchatTrainTaskBO;
import com.tydic.nbchat.train.api.bo.train.scene.NbchatTrainTaskConfigBO;
import com.tydic.nbchat.train.api.trainTask.TrainTaskApi;
import com.tydic.nbchat.train.core.service.impl.event.EventPublishFactory;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/train/task"})
public class TrainTaskController {
    private static final Logger log = LoggerFactory.getLogger(TrainTaskController.class);
    private final TrainTaskApi trainTaskApi;

    public TrainTaskController(TrainTaskApi trainTaskApi) {
        this.trainTaskApi = trainTaskApi;
    }

    @PostMapping(value={"save"})
    public Rsp save(@RequestBody NbchatTrainTaskConfigBO request) {
        Rsp save = this.trainTaskApi.save(request);
        Integer taskId = request.getTaskConfig().getId();
        String startStatus = request.getTaskConfig().getStartStatus();
        if ("1".equals(startStatus) && ObjectUtils.isNotEmpty((Object)taskId)) {
            EventPublishFactory.publishModifyTaskEvent(request.getTenantCode(), String.valueOf(taskId));
        }
        return save;
    }

    @PostMapping(value={"list"})
    public RspList list(@RequestBody NbchatTrainTaskBO request) {
        return this.trainTaskApi.list(request);
    }

    @PostMapping(value={"info"})
    public Rsp info(@RequestBody NbchatTrainTaskBO request) {
        return this.trainTaskApi.info(request);
    }

    @PostMapping(value={"user/list"})
    public RspList queryTask(@RequestBody NbchatTrainTaskBO request) {
        return this.trainTaskApi.queryTask(request);
    }

    @PostMapping(value={"type/course"})
    public RspList typeCourse(@RequestBody NbchatTrainTaskBO request) {
        return this.trainTaskApi.queryTaskCourse(request);
    }

    @PostMapping(value={"analysis"})
    public RspList analysis(@RequestBody NbchatTrainTaskBO request) {
        return this.trainTaskApi.analysis(request);
    }

    @PostMapping(value={"course/list"})
    public RspList queryTaskCourseList(@RequestBody NbchatTrainTaskBO request) {
        return this.trainTaskApi.queryTaskCourseList(request);
    }

    @PostMapping(value={"/course/list/noauth"})
    public RspList queryTaskCourseListNoAuth(@RequestBody NbchatTrainTaskBO request) {
        return this.trainTaskApi.queryTaskCourseList(request);
    }
}

