/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.web;

import com.tydic.nbchat.train.api.bo.tdh.TdhAudioBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhAudioReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhAudioSortReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhBackgroundQueryReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhBatchDeleteTaskReqBo;
import com.tydic.nbchat.train.api.bo.tdh.TdhCreationRecordAdminReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhCreationRecordReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhCreationTaskReqBo;
import com.tydic.nbchat.train.api.bo.tdh.TdhCreationTaskRspBo;
import com.tydic.nbchat.train.api.bo.tdh.TdhForegroundAdminReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhForegroundQueryReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhForegroundSortReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhVirtualAnchorQueryReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhVirtualHumanQueryReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhVirtualHumanSortReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhVirtualHumanUpdateReqBO;
import com.tydic.nbchat.train.api.tdh.TdhAudioApi;
import com.tydic.nbchat.train.api.tdh.TdhBackgroundApi;
import com.tydic.nbchat.train.api.tdh.TdhCreationRecordApi;
import com.tydic.nbchat.train.api.tdh.TdhCreationTaskApi;
import com.tydic.nbchat.train.api.tdh.TdhForegroundApi;
import com.tydic.nbchat.train.api.tdh.TdhVirtualAnchorApi;
import com.tydic.nbchat.train.api.tdh.TdhVirtualHumanApi;
import com.tydic.nicc.common.bo.premission.Logical;
import com.tydic.nicc.common.bo.premission.RequiresRole;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/train/tdh"})
public class TrainTdhController {
    private static final Logger log = LoggerFactory.getLogger(TrainTdhController.class);
    private final TdhBackgroundApi tdhBackgroundApi;
    private final TdhForegroundApi tdhForegroundApi;
    private final TdhVirtualHumanApi tdhVirtualHumanApi;
    private final TdhVirtualAnchorApi tdhVirtualAnchorApi;
    private final TdhCreationRecordApi tdhCreationRecordApi;
    private final TdhCreationTaskApi tdhCreationTaskApi;
    private final TdhAudioApi tdhAudioApi;

    public TrainTdhController(TdhBackgroundApi tdhBackgroundApi, TdhForegroundApi tdhForegroundApi, TdhVirtualHumanApi tdhVirtualHumanApi, TdhVirtualAnchorApi tdhVirtualAnchorApi, TdhCreationRecordApi tdhCreationRecordApi, TdhCreationTaskApi tdhCreationTaskApi, TdhAudioApi tdhAudioApi) {
        this.tdhBackgroundApi = tdhBackgroundApi;
        this.tdhForegroundApi = tdhForegroundApi;
        this.tdhVirtualHumanApi = tdhVirtualHumanApi;
        this.tdhVirtualAnchorApi = tdhVirtualAnchorApi;
        this.tdhCreationRecordApi = tdhCreationRecordApi;
        this.tdhCreationTaskApi = tdhCreationTaskApi;
        this.tdhAudioApi = tdhAudioApi;
    }

    @PostMapping(value={"/background/list"})
    public RspList getBackgroundList(@RequestBody TdhBackgroundQueryReqBO request) {
        return this.tdhBackgroundApi.getBackgroundList(request);
    }

    @PostMapping(value={"/background/save"})
    public RspList saveBackground(@RequestBody TdhBackgroundQueryReqBO request) {
        return this.tdhBackgroundApi.save(request);
    }

    @PostMapping(value={"/foreground/list"})
    public RspList getBackgroundList(@RequestBody TdhForegroundQueryReqBO request) {
        return this.tdhForegroundApi.getForegroundList(request);
    }

    @PostMapping(value={"/foreground/save"})
    public RspList saveBackground(@RequestBody TdhForegroundQueryReqBO request) {
        return this.tdhForegroundApi.save(request);
    }

    @RequiresRole(value={"sysAdmin", "tenantAdmin"}, logical=Logical.OR)
    @PostMapping(value={"/foreground/admin_list"})
    public RspList getBackgroundAdminList(@RequestBody TdhForegroundQueryReqBO request) {
        return this.tdhForegroundApi.getForegroundAdminList(request);
    }

    @RequiresRole(value={"sysAdmin", "tenantAdmin"}, logical=Logical.OR)
    @PostMapping(value={"/foreground/admin_save"})
    public RspList saveBackgroundAdmin(@RequestBody TdhForegroundAdminReqBO request) {
        return this.tdhForegroundApi.saveAdmin(request);
    }

    @PostMapping(value={"/foreground/sort"})
    @RequiresRole(value={"sysAdmin", "tenantAdmin"}, logical=Logical.OR)
    public Rsp sortForeground(@RequestBody TdhForegroundSortReqBO request) {
        return this.tdhForegroundApi.sort(request);
    }

    @PostMapping(value={"/foreground/query"})
    public Rsp getForeground(@RequestBody TdhForegroundQueryReqBO request) {
        return this.tdhForegroundApi.getForeground(request);
    }

    @PostMapping(value={"/human/list"})
    public RspList getVirtualHumanList(@RequestBody TdhVirtualHumanQueryReqBO request) {
        return this.tdhVirtualHumanApi.getVirtualHumanList(request);
    }

    @PostMapping(value={"/human/update"})
    @RequiresRole(value={"sysAdmin"})
    public Rsp saveOrUpdateVirtualHuman(@RequestBody TdhVirtualHumanUpdateReqBO request) {
        return this.tdhVirtualHumanApi.saveOrUpdateVirtualHuman(request);
    }

    @PostMapping(value={"/human/sort"})
    @RequiresRole(value={"sysAdmin"})
    public Rsp sortVirtualHuman(@RequestBody TdhVirtualHumanSortReqBO request) {
        return this.tdhVirtualHumanApi.sort(request);
    }

    @PostMapping(value={"/human/save"})
    @RequiresRole(value={"sysAdmin"})
    public Rsp saveVirtualHuman(@RequestBody TdhVirtualHumanUpdateReqBO request) {
        return this.tdhVirtualHumanApi.updateStatus(request);
    }

    @PostMapping(value={"/human/delete"})
    @RequiresRole(value={"sysAdmin"})
    public Rsp deleteVirtualHuman(@RequestBody TdhVirtualHumanUpdateReqBO request) {
        return this.tdhVirtualHumanApi.delete(request);
    }

    @PostMapping(value={"/human/query"})
    public RspList getQueryVirtualHumanList(@RequestBody TdhVirtualHumanQueryReqBO request) {
        return this.tdhVirtualHumanApi.getQueryVirtualHumanList(request);
    }

    @PostMapping(value={"/human/index/list"})
    public RspList getUserVirtualHumanList(@RequestBody TdhVirtualHumanQueryReqBO request) {
        return this.tdhVirtualHumanApi.getUserVirtualHumanList(request);
    }

    @PostMapping(value={"/anchor/list"})
    public RspList getVirtualAnchorList(@RequestBody TdhVirtualAnchorQueryReqBO request) {
        return this.tdhVirtualAnchorApi.getVirtualAnchorList(request);
    }

    @PostMapping(value={"/anchor/update"})
    public Rsp updateVirtualAnchor(@RequestBody TdhVirtualAnchorQueryReqBO request) {
        return this.tdhVirtualAnchorApi.updateEmotion(request);
    }

    @PostMapping(value={"/draft/list"})
    public RspList getCreationRecordList(@RequestBody TdhCreationRecordReqBO request) {
        return this.tdhCreationRecordApi.queryList(request);
    }

    @RequiresRole(value={"sysAdmin", "tenantAdmin"}, logical=Logical.OR)
    @PostMapping(value={"/draft/admin_list"})
    public RspList getCreationRecordAdminList(@RequestBody TdhCreationRecordAdminReqBO request) {
        return this.tdhCreationRecordApi.queryAdminList(request);
    }

    @PostMapping(value={"/draft/query"})
    public Rsp queryCreation(@RequestBody TdhCreationRecordReqBO request) {
        return this.tdhCreationRecordApi.queryRecord(request);
    }

    @PostMapping(value={"/draft/checkVersion"})
    public Rsp checkVersion(@RequestBody TdhCreationRecordReqBO request) {
        return this.tdhCreationRecordApi.checkVersion(request);
    }

    @PostMapping(value={"/draft/save"})
    public Rsp updateDraft(@RequestBody TdhCreationRecordReqBO request) {
        return this.tdhCreationRecordApi.save(request);
    }

    @PostMapping(value={"/opus/list"})
    public RspList getCreationTaskList(@RequestBody TdhCreationTaskReqBo request) {
        return this.tdhCreationTaskApi.getCreationList(request);
    }

    @PostMapping(value={"/opus/info"})
    public Rsp<TdhCreationTaskRspBo> getCreationInfo(@RequestBody TdhCreationTaskReqBo request) {
        return this.tdhCreationTaskApi.getCreationInfo(request);
    }

    @PostMapping(value={"/task/info"})
    public Rsp getTaskInfo(@RequestBody TdhCreationTaskReqBo request) {
        HashMap<String, String> taskMap = new HashMap<String, String>();
        Rsp taskInfo = this.tdhCreationTaskApi.getCreationInfo(request);
        if (taskInfo.isSuccess() && taskInfo.getData() != null) {
            TdhCreationTaskRspBo data = (TdhCreationTaskRspBo)taskInfo.getData();
            taskMap.put("taskId", data.getTaskId());
            taskMap.put("creationName", data.getCreationName());
            taskMap.put("videoUrl", data.getVideoUrl());
            taskMap.put("previewUrl", data.getPreviewUrl());
            taskMap.put("playUrl", data.getPlayUrl());
            taskMap.put("duration", String.valueOf(data.getDuration()));
        }
        return BaseRspUtils.createSuccessRsp(taskMap);
    }

    @PostMapping(value={"/opus/update"})
    public Rsp updateCreationTaskList(@RequestBody TdhCreationTaskReqBo request) {
        return this.tdhCreationTaskApi.update(request);
    }

    @PostMapping(value={"/opus/delete"})
    public Rsp deleteTask(@RequestBody TdhCreationTaskReqBo request) {
        return this.tdhCreationTaskApi.delete(request);
    }

    @PostMapping(value={"/opus/batch/delete"})
    public Rsp batchDeleteTask(@RequestBody TdhBatchDeleteTaskReqBo request) {
        return this.tdhCreationTaskApi.batchDelete(request);
    }

    @PostMapping(value={"/audio/save"})
    public Rsp saveAudio(@RequestBody TdhAudioBO request) {
        return this.tdhAudioApi.save(request);
    }

    @PostMapping(value={"/audio/query"})
    public RspList getAudioList(@RequestBody TdhAudioBO request) {
        return this.tdhAudioApi.query(request);
    }

    @PostMapping(value={"/audio/delete"})
    public Rsp deleteAudio(@RequestBody TdhAudioBO request) {
        return this.tdhAudioApi.delete(request);
    }

    @PostMapping(value={"/audio/admin_save"})
    public Rsp saveAudioForAdmin(@RequestBody @Validated TdhAudioReqBO request) {
        return this.tdhAudioApi.saveAudioForAdmin(request);
    }

    @PostMapping(value={"/audio/admin_list"})
    public RspList getAudioAdminList(@RequestBody TdhAudioBO request) {
        return this.tdhAudioApi.queryAudioForAdmin(request);
    }

    @PostMapping(value={"/audio/admin_sort"})
    public Rsp sortAudioForAdmin(@RequestBody TdhAudioSortReqBO request) {
        return this.tdhAudioApi.sortAudioForAdmin(request);
    }

    @PostMapping(value={"/audio/admin_delete"})
    public Rsp deleteAudioForAdmin(@RequestBody TdhAudioBO request) {
        return this.tdhAudioApi.deleteAudioForAdmin(request);
    }
}

