/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.web;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson2.JSON;
import com.tydic.nbchat.train.api.bo.train.SceneDialogueContent;
import com.tydic.nbchat.train.mapper.NbchatTrainCatalogMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainRecordMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainSceneDialogueMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainUserRecordMapper;
import com.tydic.nbchat.train.mapper.po.NbchatTrainCatalog;
import com.tydic.nbchat.train.mapper.po.NbchatTrainRecord;
import com.tydic.nbchat.train.mapper.po.NbchatTrainSceneDialogue;
import com.tydic.nbchat.train.mapper.po.NbchatTrainUserRecord;
import java.awt.GraphicsEnvironment;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/train/utils"})
public class UtilsController {
    private static final Logger log = LoggerFactory.getLogger(UtilsController.class);
    @Resource
    NbchatTrainRecordMapper nbchatTrainRecordMapper;
    @Resource
    NbchatTrainCatalogMapper nbchatTrainCatalogMapper;
    @Resource
    NbchatTrainUserRecordMapper nbchatTrainUserRecordMapper;
    @Resource
    NbchatTrainSceneDialogueMapper nbchatTrainSceneDialogueMapper;

    @GetMapping(value={"/fonts"})
    public String fonts() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = ge.getAvailableFontFamilyNames();
        StringBuilder sb = new StringBuilder();
        for (String fontName : fontNames) {
            sb.append(fontName).append("<br>");
        }
        return sb.toString();
    }

    @PostMapping(value={"studied"})
    public void doStudied() {
        List catalogs = this.nbchatTrainCatalogMapper.selectByCondition();
        for (NbchatTrainCatalog catalog : catalogs) {
            catalog.setSectionIds(catalog.getSectionIds().replaceAll("\"|\\[|\\]", ""));
        }
        Map<String, String> map = catalogs.stream().collect(Collectors.toMap(NbchatTrainCatalog::getSectionIds, NbchatTrainCatalog::getCatalogId));
        List records = this.nbchatTrainRecordMapper.selectTrainRecord(null);
        for (NbchatTrainRecord record : records) {
            List sections = JSON.parseArray((String)record.getTrainSections(), String.class);
            for (String section : sections) {
                String s = map.get(section);
                if (!StringUtils.isNotEmpty((CharSequence)s)) continue;
                NbchatTrainUserRecord insert = new NbchatTrainUserRecord();
                insert.setCreateTime(new Date());
                insert.setUserId(record.getUserId());
                insert.setCatalogId(s);
                this.nbchatTrainUserRecordMapper.insert(insert);
            }
        }
    }

    @PostMapping(value={"importDialogue"})
    public String importDialogue(@RequestBody JSONObject obj) {
        String courseId = (String)obj.get((Object)"courseId");
        String content = (String)obj.get((Object)"content");
        String tenantCode = (String)obj.get((Object)"tenantCode");
        List dialogueContents = JSONObject.parseArray((String)content, SceneDialogueContent.class);
        for (SceneDialogueContent dialogueContent : dialogueContents) {
            NbchatTrainSceneDialogue dialogue = new NbchatTrainSceneDialogue();
            dialogue.setRole("user");
            dialogue.setContent(dialogueContent.getUser());
            dialogue.setDateTime(new Date());
            dialogue.setCourseId(courseId);
            dialogue.setTenantCode(tenantCode);
            this.nbchatTrainSceneDialogueMapper.insertSelective(dialogue);
            NbchatTrainSceneDialogue dialogue1 = new NbchatTrainSceneDialogue();
            dialogue1.setRole("assistant");
            dialogue1.setContent(dialogueContent.getAssistant());
            dialogue1.setDateTime(new Date());
            dialogue1.setCourseId(courseId);
            dialogue1.setTenantCode(tenantCode);
            this.nbchatTrainSceneDialogueMapper.insertSelective(dialogue1);
        }
        return "\u5bfc\u5165\u5bf9\u8bdd\u6d41\u5b8c\u6210";
    }
}

