/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.web.tdh;

import com.tydic.nbchat.train.core.service.impl.tdh.TdhCacheManagementService;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/train/tdh/cache"})
public class TdhCacheController {
    private static final Logger log = LoggerFactory.getLogger(TdhCacheController.class);
    @Resource
    private TdhCacheManagementService cacheManagementService;
    @Resource
    private RedisTemplate<String, Object> redisTemplate;

    @PostMapping(value={"/emergency/clear"})
    public Rsp emergencyClearAllCache() {
        log.warn("\u7d27\u6025\u6e05\u7406\u6240\u6709\u6570\u5b57\u4eba\u7f13\u5b58 - \u7528\u4e8e\u89e3\u51b3\u5e8f\u5217\u5316\u517c\u5bb9\u6027\u95ee\u9898");
        try {
            String[] cachePatterns = new String[]{"nbchat-train:tdh_virtual_human*", "nbchat-train:tdh_template*", "nbchat-train:tdh_virtual_anchor*", "nbchat-train:tdh_foreground*", "nbchat-train:tdh_background*", "nbchat-train:tdh_audio*", "nbchat-train:tdh_ai_match*"};
            int totalDeleted = 0;
            for (String pattern : cachePatterns) {
                Set keys = this.redisTemplate.keys((Object)pattern);
                if (keys == null || keys.isEmpty()) continue;
                Long deleted = this.redisTemplate.delete((Collection)keys);
                totalDeleted += deleted != null ? deleted.intValue() : 0;
                log.info("\u6e05\u7406\u7f13\u5b58\u6a21\u5f0f: {}, \u5220\u9664\u952e\u6570\u91cf: {}", (Object)pattern, (Object)deleted);
            }
            log.warn("\u7d27\u6025\u7f13\u5b58\u6e05\u7406\u5b8c\u6210\uff0c\u603b\u5171\u5220\u9664 {} \u4e2a\u7f13\u5b58\u952e", (Object)totalDeleted);
            return BaseRspUtils.createSuccessRsp((Object)("\u7d27\u6025\u7f13\u5b58\u6e05\u7406\u5b8c\u6210\uff0c\u5220\u9664\u4e86 " + totalDeleted + " \u4e2a\u7f13\u5b58\u952e"));
        }
        catch (Exception e) {
            log.error("\u7d27\u6025\u6e05\u7406\u7f13\u5b58\u5931\u8d25", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)("\u7d27\u6025\u6e05\u7406\u7f13\u5b58\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @PostMapping(value={"/clear/all"})
    public Rsp clearAllCache() {
        log.info("\u7ba1\u7406\u5458\u8bf7\u6c42\u6e05\u9664\u6240\u6709\u6570\u5b57\u4eba\u7f13\u5b58");
        try {
            this.cacheManagementService.clearAllTdhCache();
            return BaseRspUtils.createSuccessRsp((Object)"\u6240\u6709\u6570\u5b57\u4eba\u7f13\u5b58\u5df2\u6e05\u9664");
        }
        catch (Exception e) {
            log.error("\u6e05\u9664\u6240\u6709\u7f13\u5b58\u5931\u8d25", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)("\u6e05\u9664\u7f13\u5b58\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @PostMapping(value={"/clear/virtual-human"})
    public Rsp clearVirtualHumanCache() {
        log.info("\u7ba1\u7406\u5458\u8bf7\u6c42\u6e05\u9664\u865a\u62df\u4eba\u5f62\u8c61\u7f13\u5b58");
        try {
            this.cacheManagementService.clearVirtualHumanCache();
            return BaseRspUtils.createSuccessRsp((Object)"\u865a\u62df\u4eba\u5f62\u8c61\u7f13\u5b58\u5df2\u6e05\u9664");
        }
        catch (Exception e) {
            log.error("\u6e05\u9664\u865a\u62df\u4eba\u5f62\u8c61\u7f13\u5b58\u5931\u8d25", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)("\u6e05\u9664\u7f13\u5b58\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @PostMapping(value={"/clear/template"})
    public Rsp clearTemplateCache() {
        log.info("\u7ba1\u7406\u5458\u8bf7\u6c42\u6e05\u9664\u6a21\u677f\u7f13\u5b58");
        try {
            this.cacheManagementService.clearTemplateCache();
            return BaseRspUtils.createSuccessRsp((Object)"\u6a21\u677f\u7f13\u5b58\u5df2\u6e05\u9664");
        }
        catch (Exception e) {
            log.error("\u6e05\u9664\u6a21\u677f\u7f13\u5b58\u5931\u8d25", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)("\u6e05\u9664\u7f13\u5b58\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @PostMapping(value={"/clear/virtual-anchor"})
    public Rsp clearVirtualAnchorCache() {
        log.info("\u7ba1\u7406\u5458\u8bf7\u6c42\u6e05\u9664\u865a\u62df\u4e3b\u64ad\u7f13\u5b58");
        try {
            this.cacheManagementService.clearVirtualAnchorCache();
            return BaseRspUtils.createSuccessRsp((Object)"\u865a\u62df\u4e3b\u64ad\u7f13\u5b58\u5df2\u6e05\u9664");
        }
        catch (Exception e) {
            log.error("\u6e05\u9664\u865a\u62df\u4e3b\u64ad\u7f13\u5b58\u5931\u8d25", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)("\u6e05\u9664\u7f13\u5b58\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @PostMapping(value={"/clear/foreground"})
    public Rsp clearForegroundCache() {
        log.info("\u7ba1\u7406\u5458\u8bf7\u6c42\u6e05\u9664\u524d\u666f\u7f13\u5b58");
        try {
            this.cacheManagementService.clearForegroundCache();
            return BaseRspUtils.createSuccessRsp((Object)"\u524d\u666f\u7f13\u5b58\u5df2\u6e05\u9664");
        }
        catch (Exception e) {
            log.error("\u6e05\u9664\u524d\u666f\u7f13\u5b58\u5931\u8d25", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)("\u6e05\u9664\u7f13\u5b58\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @PostMapping(value={"/clear/background"})
    public Rsp clearBackgroundCache() {
        log.info("\u7ba1\u7406\u5458\u8bf7\u6c42\u6e05\u9664\u80cc\u666f\u7f13\u5b58");
        try {
            this.cacheManagementService.clearBackgroundCache();
            return BaseRspUtils.createSuccessRsp((Object)"\u80cc\u666f\u7f13\u5b58\u5df2\u6e05\u9664");
        }
        catch (Exception e) {
            log.error("\u6e05\u9664\u80cc\u666f\u7f13\u5b58\u5931\u8d25", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)("\u6e05\u9664\u7f13\u5b58\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @PostMapping(value={"/clear/audio"})
    public Rsp clearAudioCache() {
        log.info("\u7ba1\u7406\u5458\u8bf7\u6c42\u6e05\u9664\u97f3\u9891\u7f13\u5b58");
        try {
            this.cacheManagementService.clearAudioCache();
            return BaseRspUtils.createSuccessRsp((Object)"\u97f3\u9891\u7f13\u5b58\u5df2\u6e05\u9664");
        }
        catch (Exception e) {
            log.error("\u6e05\u9664\u97f3\u9891\u7f13\u5b58\u5931\u8d25", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)("\u6e05\u9664\u7f13\u5b58\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @PostMapping(value={"/clear/ai-match"})
    public Rsp clearAiMatchCache() {
        log.info("\u7ba1\u7406\u5458\u8bf7\u6c42\u6e05\u9664AI\u5339\u914d\u7f13\u5b58");
        try {
            this.cacheManagementService.clearAiMatchCache();
            return BaseRspUtils.createSuccessRsp((Object)"AI\u5339\u914d\u7f13\u5b58\u5df2\u6e05\u9664");
        }
        catch (Exception e) {
            log.error("\u6e05\u9664AI\u5339\u914d\u7f13\u5b58\u5931\u8d25", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)("\u6e05\u9664\u7f13\u5b58\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @PostMapping(value={"/clear/tenant/{tenantCode}"})
    public Rsp clearTenantCache(@PathVariable String tenantCode) {
        log.info("\u7ba1\u7406\u5458\u8bf7\u6c42\u6e05\u9664\u79df\u6237\u7f13\u5b58 - \u79df\u6237: {}", (Object)tenantCode);
        try {
            this.cacheManagementService.clearVirtualHumanCacheByTenant(tenantCode);
            return BaseRspUtils.createSuccessRsp((Object)("\u79df\u6237 " + tenantCode + " \u7684\u7f13\u5b58\u5df2\u6e05\u9664"));
        }
        catch (Exception e) {
            log.error("\u6e05\u9664\u79df\u6237\u7f13\u5b58\u5931\u8d25 - \u79df\u6237: {}", (Object)tenantCode, (Object)e);
            return BaseRspUtils.createErrorRsp((String)("\u6e05\u9664\u7f13\u5b58\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @PostMapping(value={"/clear/user/{userId}"})
    public Rsp clearUserCache(@PathVariable String userId, @RequestParam(required=false) String tenantCode) {
        log.info("\u7ba1\u7406\u5458\u8bf7\u6c42\u6e05\u9664\u7528\u6237\u7f13\u5b58 - \u7528\u6237: {}, \u79df\u6237: {}", (Object)userId, (Object)tenantCode);
        try {
            this.cacheManagementService.clearUserRelatedCache(userId, tenantCode);
            return BaseRspUtils.createSuccessRsp((Object)("\u7528\u6237 " + userId + " \u7684\u7f13\u5b58\u5df2\u6e05\u9664"));
        }
        catch (Exception e) {
            log.error("\u6e05\u9664\u7528\u6237\u7f13\u5b58\u5931\u8d25 - \u7528\u6237: {}", (Object)userId, (Object)e);
            return BaseRspUtils.createErrorRsp((String)("\u6e05\u9664\u7f13\u5b58\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }
}

