/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.web.tdh;

import com.tydic.nbchat.train.api.bo.tdh.TdhCustomizeQcUpdateReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhCustomizeRecordModifyStatusReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhCustomizeRecordPriceChangeReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhCustomizeRecordQueryReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhCustomizeRecordShareReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhCustomizeRecordUpdateInfoReqBO;
import com.tydic.nbchat.train.api.tdh.TdhCustomizeRecordApi;
import com.tydic.nbchat.train.api.tdh.TdhCustomizeRecordOperationsApi;
import com.tydic.nbchat.train.api.tdh.TdhQualInspTempApi;
import com.tydic.nbchat.train.api.tdh.TdhQualInspTempDataBO;
import com.tydic.nbchat.train.api.tdh.TdhQualInspTempQueryReqBO;
import com.tydic.nicc.common.bo.premission.Logical;
import com.tydic.nicc.common.bo.premission.RequiresRole;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/train/tdh_customize"})
public class TdhCustomizeRecordController {
    private static final Logger log = LoggerFactory.getLogger(TdhCustomizeRecordController.class);
    private final TdhQualInspTempApi tdhQualInspTempApi;
    private final TdhCustomizeRecordApi tdhCustomizeRecordApi;
    private final TdhCustomizeRecordOperationsApi tdhCustomizeRecordOperationsApi;

    @PostMapping(value={"/admin_list"})
    @RequiresRole(value={"sysAdmin"}, logical=Logical.OR)
    public RspList list(@RequestBody TdhCustomizeRecordQueryReqBO reqBO) {
        return this.tdhCustomizeRecordOperationsApi.list(reqBO);
    }

    @PostMapping(value={"/info"})
    @RequiresRole(value={"sysAdmin"}, logical=Logical.OR)
    public Rsp info(@RequestBody TdhCustomizeRecordQueryReqBO reqBO) {
        return this.tdhCustomizeRecordOperationsApi.info(reqBO);
    }

    @PostMapping(value={"/qualInspTemp/list"})
    public RspList<TdhQualInspTempDataBO> list(@RequestBody TdhQualInspTempQueryReqBO param) {
        return this.tdhQualInspTempApi.list(param);
    }

    @PostMapping(value={"/qualInspTemp/info"})
    public Rsp<TdhQualInspTempDataBO> info(@RequestBody TdhQualInspTempQueryReqBO param) {
        return this.tdhQualInspTempApi.info(param);
    }

    @PostMapping(value={"/qualInspTemp/save"})
    public Rsp<?> save(@RequestBody TdhQualInspTempDataBO param) {
        return this.tdhQualInspTempApi.save(param);
    }

    @PostMapping(value={"/order_list"})
    public RspList orderList(@RequestBody TdhCustomizeRecordQueryReqBO reqBO) {
        return this.tdhCustomizeRecordApi.orderList(reqBO);
    }

    @PostMapping(value={"/order_info"})
    public Rsp orderInfo(@RequestBody TdhCustomizeRecordQueryReqBO reqBO) {
        return this.tdhCustomizeRecordApi.orderInfo(reqBO);
    }

    @PostMapping(value={"/price_change"})
    @RequiresRole(value={"sysAdmin"}, logical=Logical.OR)
    public Rsp priceChange(@RequestBody TdhCustomizeRecordPriceChangeReqBO request) {
        return this.tdhCustomizeRecordOperationsApi.priceChange(request);
    }

    @PostMapping(value={"/admin_update_qc"})
    @RequiresRole(value={"sysAdmin"}, logical=Logical.OR)
    public Rsp updateQc(@Validated @RequestBody TdhCustomizeQcUpdateReqBO request) {
        return this.tdhCustomizeRecordOperationsApi.updateQc(request);
    }

    @Deprecated
    @PostMapping(value={"/admin_update"})
    @RequiresRole(value={"sysAdmin"}, logical=Logical.OR)
    public Rsp modifyStatus(@RequestBody TdhCustomizeRecordModifyStatusReqBO request) {
        return this.tdhCustomizeRecordOperationsApi.modifyStatus(request);
    }

    @PostMapping(value={"/update"})
    public Rsp updateInfo(@RequestBody TdhCustomizeRecordUpdateInfoReqBO request) {
        return this.tdhCustomizeRecordApi.updateInfo(request);
    }

    @PostMapping(value={"/update/view_time"})
    public Rsp updateFirstViewTime(@RequestBody TdhCustomizeRecordQueryReqBO request) {
        return this.tdhCustomizeRecordApi.updateFirstViewTime(request);
    }

    @PostMapping(value={"/share/update"})
    public Rsp updateShare(@RequestBody TdhCustomizeRecordShareReqBO request) {
        return this.tdhCustomizeRecordApi.updateShare(request);
    }

    public TdhCustomizeRecordController(TdhQualInspTempApi tdhQualInspTempApi, TdhCustomizeRecordApi tdhCustomizeRecordApi, TdhCustomizeRecordOperationsApi tdhCustomizeRecordOperationsApi) {
        this.tdhQualInspTempApi = tdhQualInspTempApi;
        this.tdhCustomizeRecordApi = tdhCustomizeRecordApi;
        this.tdhCustomizeRecordOperationsApi = tdhCustomizeRecordOperationsApi;
    }
}

