/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.web.tdh;

import com.tydic.nbchat.train.api.bo.tdh.TdhIndexHumanQueryRspBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhIndexTemplateDeleteReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhIndexTemplateQueryReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhIndexTemplateQueryRspBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhIndexTemplateSortReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhIndexTemplateStatusReqBO;
import com.tydic.nbchat.train.api.tdh.TdhIndexTemplateApi;
import com.tydic.nicc.common.bo.premission.RequiresRole;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/train/tdh"})
public class TdhIndexTemplateController {
    private static final Logger log = LoggerFactory.getLogger(TdhIndexTemplateController.class);
    private final TdhIndexTemplateApi tdhIndexTemplateApi;

    public TdhIndexTemplateController(TdhIndexTemplateApi tdhIndexTemplateApi) {
        this.tdhIndexTemplateApi = tdhIndexTemplateApi;
    }

    @PostMapping(value={"/index/templates"})
    public RspList<TdhIndexTemplateQueryRspBO> list(@RequestBody TdhIndexTemplateQueryReqBO request) {
        return this.tdhIndexTemplateApi.list(request);
    }

    @PostMapping(value={"/index/template/info"})
    public Rsp info(@RequestBody TdhIndexTemplateQueryReqBO reqBO) {
        return this.tdhIndexTemplateApi.info(reqBO);
    }

    @PostMapping(value={"/index/humans"})
    public RspList<TdhIndexHumanQueryRspBO> getIndexHumans(@RequestBody TdhIndexTemplateQueryReqBO request) {
        return this.tdhIndexTemplateApi.getIndexHumans(request);
    }

    @PostMapping(value={"/admin/index/templates"})
    @RequiresRole(value={"sysAdmin"})
    public RspList<TdhIndexTemplateQueryRspBO> adminList(@RequestBody TdhIndexTemplateQueryReqBO request) {
        return this.tdhIndexTemplateApi.adminList(request);
    }

    @PostMapping(value={"/admin/index/template/add"})
    @RequiresRole(value={"sysAdmin"})
    public Rsp addTemplate(@RequestBody TdhIndexTemplateQueryReqBO reqBO) {
        return this.tdhIndexTemplateApi.addTemplate(reqBO);
    }

    @PostMapping(value={"/admin/index/template/update"})
    @RequiresRole(value={"sysAdmin"})
    public Rsp updateTemplate(@RequestBody TdhIndexTemplateQueryReqBO reqBO) {
        return this.tdhIndexTemplateApi.updateTemplate(reqBO);
    }

    @PostMapping(value={"/admin/index/template/delete"})
    @RequiresRole(value={"sysAdmin"})
    public Rsp deleteTemplate(@RequestBody TdhIndexTemplateDeleteReqBO request) {
        return this.tdhIndexTemplateApi.deleteTemplate(request);
    }

    @PostMapping(value={"/admin/index/template/sort"})
    @RequiresRole(value={"sysAdmin"})
    public Rsp sortTemplates(@RequestBody TdhIndexTemplateSortReqBO reqBO) {
        return this.tdhIndexTemplateApi.sortTemplates(reqBO);
    }

    @PostMapping(value={"/admin/index/template/status"})
    @RequiresRole(value={"sysAdmin"})
    public Rsp updateTemplateStatus(@RequestBody TdhIndexTemplateStatusReqBO request) {
        return this.tdhIndexTemplateApi.updateTemplateStatus(request);
    }
}

