/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.web.tdh;

import com.tydic.nbchat.train.api.TdhMaterialPackageApi;
import com.tydic.nbchat.train.api.bo.tdh.TdhMaterialLibraryQueryBo;
import com.tydic.nbchat.train.api.bo.tdh.TdhMaterialLibraryRspBo;
import com.tydic.nicc.common.bo.premission.RequiresRole;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/train/tdh_material"})
public class TdhMaterialLibraryController {
    private static final Logger log = LoggerFactory.getLogger(TdhMaterialLibraryController.class);
    private final TdhMaterialPackageApi tdhMaterialPackageApi;

    public TdhMaterialLibraryController(TdhMaterialPackageApi tdhMaterialPackageApi) {
        this.tdhMaterialPackageApi = tdhMaterialPackageApi;
    }

    @PostMapping(value={"/library/list"})
    @RequiresRole(value={"sysAdmin"})
    public RspList<TdhMaterialLibraryRspBo> getMaterialLibraryList(@RequestBody TdhMaterialLibraryQueryBo queryBo) {
        return this.tdhMaterialPackageApi.getMaterialLibraryId(queryBo);
    }

    @PostMapping(value={"/library/save"})
    @RequiresRole(value={"sysAdmin"})
    public Rsp<TdhMaterialLibraryRspBo> saveMaterialLibrary(@RequestBody TdhMaterialLibraryQueryBo queryBo) {
        return this.tdhMaterialPackageApi.saveMaterialLibrary(queryBo);
    }

    @PostMapping(value={"/library/match"})
    public RspList<TdhMaterialLibraryRspBo> getMaterialLibraryId(@RequestBody TdhMaterialLibraryQueryBo queryBo) {
        return this.tdhMaterialPackageApi.getMaterialPackageAndLibrary(queryBo);
    }
}

