/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.web.tdh;

import com.tydic.nbchat.train.api.TdhMaterialPackageApi;
import com.tydic.nbchat.train.api.bo.tdh.TdhMaterialPackageQueryBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhMaterialPackageRspBo;
import com.tydic.nicc.common.bo.premission.RequiresRole;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/train/tdh_material"})
public class TdhMaterialPackageController {
    private static final Logger log = LoggerFactory.getLogger(TdhMaterialPackageController.class);
    private final TdhMaterialPackageApi tdhMaterialPackageApi;

    public TdhMaterialPackageController(TdhMaterialPackageApi tdhMaterialPackageApi) {
        this.tdhMaterialPackageApi = tdhMaterialPackageApi;
    }

    @PostMapping(value={"/package/list"})
    public RspList<TdhMaterialPackageRspBo> getMaterialPackageList(@RequestBody TdhMaterialPackageQueryBO request) {
        return this.tdhMaterialPackageApi.getMaterialPackageList(request);
    }

    @PostMapping(value={"/package/save"})
    @RequiresRole(value={"sysAdmin"})
    public Rsp<TdhMaterialPackageRspBo> saveMaterialPackage(@RequestBody TdhMaterialPackageQueryBO request) {
        return this.tdhMaterialPackageApi.saveMaterialPackage(request);
    }

    @PostMapping(value={"/package/delete"})
    @RequiresRole(value={"sysAdmin"})
    public Rsp deleteMaterialPackage(@RequestBody TdhMaterialPackageQueryBO request) {
        return this.tdhMaterialPackageApi.deleteMaterialPackage(request.getPkgId(), request.getIsValid());
    }
}

