/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.web.tdh;

import com.tydic.nbchat.train.api.CustomizeOrderApi;
import com.tydic.nbchat.train.api.bo.tdh.TdhCustomizeRecordQueryReqBO;
import com.tydic.nbchat.user.api.bo.vip.NbchatUserVipRightsBO;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/train/tdh_customize"})
public class TdhOrderController {
    private static final Logger log = LoggerFactory.getLogger(TdhOrderController.class);
    private final CustomizeOrderApi customizeOrderApi;

    @PostMapping(value={"/create_order"})
    public Rsp create(@RequestBody TdhCustomizeRecordQueryReqBO request) {
        return this.customizeOrderApi.createOrder(request);
    }

    @PostMapping(value={"/confirm_order"})
    public Rsp confirmOrder(@RequestBody NbchatUserVipRightsBO request) {
        return this.customizeOrderApi.updateRights(request);
    }

    @PostMapping(value={"profess/free"})
    public Rsp freeCustomize(@RequestBody NbchatUserVipRightsBO request) {
        return this.customizeOrderApi.freeCustomize(request);
    }

    @PostMapping(value={"first/free"})
    public Rsp firstFree(@RequestBody NbchatUserVipRightsBO request) {
        request.setIsFreeExperience(Boolean.valueOf(true));
        request.setStartTime(new Date());
        request.setEndTime(DateTimeUtil.DateAddHour((int)24));
        return this.customizeOrderApi.freeCustomize(request);
    }

    public TdhOrderController(CustomizeOrderApi customizeOrderApi) {
        this.customizeOrderApi = customizeOrderApi;
    }
}

