/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.web.tdh;

import com.tydic.nbchat.train.api.bo.tdh.TdhTemplateQueryReqBO;
import com.tydic.nbchat.train.api.bo.template.TdhSortBO;
import com.tydic.nbchat.train.api.bo.template.TdhTemplateLayoutBO;
import com.tydic.nbchat.train.api.bo.template.TdhTemplateLayoutReq;
import com.tydic.nbchat.train.api.tdh.TdhLayoutApi;
import com.tydic.nbchat.train.api.tdh.TdhTemplateApi;
import com.tydic.nicc.common.bo.premission.Logical;
import com.tydic.nicc.common.bo.premission.RequiresRole;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/train/tdh/template"})
public class TdhTmplController {
    private static final Logger log = LoggerFactory.getLogger(TdhTmplController.class);
    private final TdhTemplateApi tdhTemplateApi;
    private final TdhLayoutApi tdhLayoutApi;

    public TdhTmplController(TdhTemplateApi tdhTemplateApi, TdhLayoutApi tdhLayoutApi) {
        this.tdhTemplateApi = tdhTemplateApi;
        this.tdhLayoutApi = tdhLayoutApi;
    }

    @PostMapping(value={"list"})
    public RspList getTemplateList(@RequestBody TdhTemplateQueryReqBO request) {
        return this.tdhTemplateApi.getTemplateList(request);
    }

    @PostMapping(value={"star/list"})
    public RspList getStarTemplateList(@RequestBody TdhTemplateQueryReqBO request) {
        return this.tdhTemplateApi.getStarTemplateList(request);
    }

    @RequiresRole(value={"sysAdmin", "tenantAdmin"}, logical=Logical.OR)
    @PostMapping(value={"admin_list"})
    public RspList getTemplateAdminList(@RequestBody TdhTemplateQueryReqBO request) {
        return this.tdhTemplateApi.getTemplateAdminList(request);
    }

    @PostMapping(value={"hot"})
    public RspList getHotTemplateList(@RequestBody TdhTemplateQueryReqBO request) {
        return this.tdhTemplateApi.getHotTemplateList(request);
    }

    @PostMapping(value={"query"})
    public Rsp getTemplate(@RequestBody TdhTemplateQueryReqBO request) {
        return this.tdhTemplateApi.getTemplate(request);
    }

    @PostMapping(value={"save"})
    public Rsp saveTemplate(@RequestBody TdhTemplateQueryReqBO request) {
        return this.tdhTemplateApi.save(request);
    }

    @PostMapping(value={"layout/save"})
    public Rsp saveLayout(@RequestBody TdhTemplateLayoutBO request) {
        return this.tdhLayoutApi.save(request);
    }

    @RequiresRole(value={"sysAdmin", "tenantAdmin"}, logical=Logical.OR)
    @PostMapping(value={"layout/admin/list"})
    public RspList adminQueryLayout(@RequestBody TdhTemplateLayoutReq request) {
        if (StringUtils.isNotEmpty((CharSequence)request.getTargetTenantCode())) {
            request.setTenantCode(null);
        }
        request.setUserId(null);
        return this.tdhLayoutApi.list(request);
    }

    @RequiresRole(value={"sysAdmin", "tenantAdmin"}, logical=Logical.OR)
    @PostMapping(value={"layout/admin/rel/list"})
    public RspList queryRelLayout(@RequestBody TdhTemplateLayoutReq request) {
        if (StringUtils.isNotEmpty((CharSequence)request.getTargetTenantCode())) {
            request.setTenantCode(request.getTargetTenantCode());
            request.setTargetTenantCode(null);
        }
        request.setUserId(null);
        return this.tdhLayoutApi.list(request);
    }

    @PostMapping(value={"layout/list"})
    public RspList userQueryLayout(@RequestBody TdhTemplateLayoutReq request) {
        return this.tdhLayoutApi.list(request);
    }

    @PostMapping(value={"layout/info"})
    public Rsp layoutInfo(@RequestBody TdhTemplateLayoutReq request) {
        return this.tdhLayoutApi.info(request);
    }

    @PostMapping(value={"layout/rels"})
    public RspList layoutRels(@RequestBody TdhTemplateLayoutReq request) {
        return this.tdhLayoutApi.listByRel(request);
    }

    @PostMapping(value={"layout/sort"})
    public Rsp sort(@RequestBody TdhSortBO request) {
        return this.tdhLayoutApi.sort(request);
    }
}

