/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.report.promotion.baidu;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class AESUtils {
    public static SecretKey loadKeyAES(String keyString) {
        return new SecretKeySpec(keyString.getBytes(StandardCharsets.UTF_8), "AES");
    }

    public static String encryptAES(byte[] source, SecretKey key, String vectorKey) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        IvParameterSpec iv = new IvParameterSpec(vectorKey.getBytes(StandardCharsets.UTF_8));
        int dataLength = source.length;
        if (dataLength % 16 != 0) {
            dataLength += 16 - dataLength % 16;
        }
        byte[] paddingBytes = new byte[dataLength];
        System.arraycopy(source, 0, paddingBytes, 0, source.length);
        Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
        cipher.init(1, (Key)key, iv);
        byte[] encryped = cipher.doFinal(paddingBytes);
        return AESUtils.bin2HexStr(encryped);
    }

    public static String encryptAES(byte[] source, SecretKey key) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        int dataLength = source.length;
        if (dataLength % 16 != 0) {
            dataLength += 16 - dataLength % 16;
        }
        byte[] paddingBytes = new byte[dataLength];
        System.arraycopy(source, 0, paddingBytes, 0, source.length);
        Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
        cipher.init(1, key);
        byte[] encryped = cipher.doFinal(paddingBytes);
        return Base64.getEncoder().encodeToString(encryped);
    }

    public static String decryptAES(String encrypedStr, SecretKey key) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        byte[] source = Base64.getDecoder().decode(encrypedStr);
        Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
        cipher.init(2, key);
        byte[] retBytes = cipher.doFinal(source);
        return new String(retBytes, StandardCharsets.UTF_8);
    }

    public static String decryptAES(String encrypedStr, SecretKey key, String vectorKey) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        IvParameterSpec iv = new IvParameterSpec(vectorKey.getBytes());
        byte[] source = AESUtils.hexStringToByte(encrypedStr);
        Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
        cipher.init(2, (Key)key, iv);
        byte[] retBytes = cipher.doFinal(source);
        return new String(retBytes, StandardCharsets.UTF_8);
    }

    public static String bin2HexStr(byte[] bytes) {
        String hexStr = "0123456789ABCDEF";
        StringBuilder result = new StringBuilder();
        for (byte aByte : bytes) {
            Object hex = String.valueOf(hexStr.charAt((aByte & 0xF0) >> 4));
            hex = (String)hex + String.valueOf(hexStr.charAt(aByte & 0xF));
            result.append((String)hex);
        }
        return result.toString();
    }

    private static int parse(char c) {
        if (c >= 'a') {
            return c - 97 + 10 & 0xF;
        }
        if (c >= 'A') {
            return c - 65 + 10 & 0xF;
        }
        return c - 48 & 0xF;
    }

    public static byte[] hexStringToByte(String hex) {
        byte[] b = new byte[hex.length() / 2];
        int j = 0;
        for (int i = 0; i < b.length; ++i) {
            char c0 = hex.charAt(j++);
            char c1 = hex.charAt(j++);
            b[i] = (byte)(AESUtils.parse(c0) << 4 | AESUtils.parse(c1));
        }
        return b;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

