/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.report.promotion.e360;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nbchat.train.mapper.po.RpSearchLog;
import com.tydic.nbchat.train.report.promotion.AppService;
import com.tydic.nbchat.train.report.promotion.bo.AccountTokenBO;
import com.tydic.nbchat.train.report.promotion.bo.AppServiceEnum;
import com.tydic.nbchat.train.report.promotion.bo.PromotionTypeEnum;
import com.tydic.nbchat.train.report.promotion.e360.EncryptPasswordUtils;
import com.tydic.nbchat.train.report.promotion.e360.bo.ApplicationBO;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.http.RestApiHelper;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;

@Service
public class E360AppService
extends AppService {
    private static final Logger log = LoggerFactory.getLogger(E360AppService.class);
    private static final String ACCESS_TOKEN_URL = "https://api.e.360.cn/uc/account/clientLogin";
    private static final String REPORT_COUNT_URL = "https://api.e.360.cn/dianjing/report/querywordCount";
    private static final String REPORT_DATA_URL = "https://api.e.360.cn/dianjing/report/queryword";
    @Value(value="${nbchat-train.promotion.360.reportDataAppKey:5173797da114a15e940b7944704ff7d7}")
    private String reportDataApiKey;
    @Value(value="${nbchat-train.promotion.360.appConfig:[{\"apiKey\":\"5173797da114a15e940b7944704ff7d7\",\"apiSecret\":\"689441b4daa2597c1171c3742de1d152\",\"username\":\"zhangjb521@tydic.com\",\"passwd\":\"bjty360\"}]}")
    private String appConfigProperties;
    private Map<String, ApplicationBO> appConfigMap = new HashMap<String, ApplicationBO>();
    @Resource
    private RedisHelper redisHelper;
    @Resource
    private RestApiHelper restApiHelper;

    @PostConstruct
    public void init() {
        List applications = JSON.parseArray((String)this.appConfigProperties, ApplicationBO.class);
        this.appConfigMap = applications.stream().collect(Collectors.toMap(ApplicationBO::getApiKey, value -> value));
    }

    @Override
    public String getAppType() {
        return AppServiceEnum.E360.getCode();
    }

    @Override
    public RedisHelper getRedisHelper() {
        return this.redisHelper;
    }

    @Override
    public void doRefreshToken(String apiKey) {
        String responseJson;
        log.info("\u3010360\u8425\u9500\u3011\u5237\u65b0accessToken\uff1a{}", (Object)apiKey);
        ApplicationBO application = this.getAppByApiKey(apiKey);
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("username", application.getUsername());
        request.put("passwd", EncryptPasswordUtils.getAesEncrypt(application.getPasswd(), application.getApiSecret()));
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.add("apiKey", apiKey);
        try {
            log.info("360\u8425\u9500\u767b\u5f55\u5f00\u59cb\uff1a{}", (Object)JSON.toJSONString(request));
            responseJson = this.restApiHelper.post(ACCESS_TOKEN_URL, this.convertMapToFormDataWithEncoding(request), headers, new MediaType[0]);
            log.info("360\u8425\u9500\u767b\u5f55\u7ed3\u675f\uff1a{}", (Object)responseJson);
        }
        catch (Exception e) {
            log.warn("360\u8425\u9500\u767b\u5f55\u5931\u8d25", (Throwable)e);
            return;
        }
        JSONObject response = JSON.parseObject((String)responseJson);
        if (response.containsKey((Object)"failures")) {
            log.warn("360\u8425\u9500\u767b\u5f55\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)response.getJSONObject("failures"));
            return;
        }
        AccountTokenBO accountToken = AccountTokenBO.builder().accessToken(response.getString("accessToken")).expiresTime(DateTimeUtil.DateAddHour((int)10)).userId(response.getString("uid")).build();
        this.redisHelper.hset(this.REDIS_KEY_TOKEN, apiKey, (Object)JSON.toJSONString((Object)accountToken));
    }

    @Override
    public List<PromotionTypeEnum> getPromotionType() {
        return List.of(PromotionTypeEnum.COMPUTER, PromotionTypeEnum.MOBILE);
    }

    @Override
    public RspList<RpSearchLog> findRpSearchLog(Date startDate, Date endDate, PromotionTypeEnum promotionType, int page) {
        String dataResponseJson;
        log.info("\u3010360\u8425\u9500\u3011\u67e5\u627e\u641c\u7d22\u65e5\u5fd7\u8bb0\u5f55\uff1astartDate-{}, endDate-{}, page-{}", new Object[]{startDate, endDate, page});
        if (promotionType == null || PromotionTypeEnum.ALL_PROMOTION_TYPE.equals((Object)promotionType)) {
            return BaseRspUtils.createErrorRspList((String)"360\u8425\u9500\u6570\u636e\u65e0\u6cd5\u67e5\u8be2\u6240\u6709\u63a8\u5e7f\u7c7b\u578b\uff0c\u5fc5\u987b\u6307\u5b9a\u5176\u4e2d\u4e00\u4e2a\u63a8\u5e7f\u7c7b\u578b");
        }
        if (DateTimeUtil.differDay((Date)startDate, (Date)endDate) > 90) {
            return BaseRspUtils.createErrorRspList((String)"360\u8425\u9500\u6570\u636e\u65e0\u6cd5\u67e5\u8be2\u8de8\u5ea6\u5927\u4e8e90\u5929\u7684\u6570\u636e");
        }
        if (page < 1) {
            page = 1;
        }
        ApplicationBO application = this.getAppByApiKey(this.reportDataApiKey);
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("startDate", DateTimeUtil.getTimeShortString((Date)startDate, (String)"yyyy-MM-dd"));
        request.put("endDate", DateTimeUtil.getTimeShortString((Date)endDate, (String)"yyyy-MM-dd"));
        request.put("type", promotionType.getE360Type());
        request.put("page", page);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.add("apiKey", this.reportDataApiKey);
        headers.add("accessToken", this.getAccessToken(this.reportDataApiKey));
        long totalCount = 0L;
        if (page == 1) {
            String countResponseJson;
            try {
                log.info("\u67e5\u627e\u641c\u7d22\u65e5\u5fd7\u8bb0\u5f55\u603b\u6570\u5f00\u59cb\uff1a{}", (Object)JSON.toJSONString(request));
                countResponseJson = this.restApiHelper.post(REPORT_COUNT_URL, this.convertMapToFormDataWithEncoding(request), headers, new MediaType[0]);
                log.info("\u67e5\u627e\u641c\u7d22\u65e5\u5fd7\u8bb0\u5f55\u603b\u6570\u7ed3\u675f\uff1a{}", (Object)countResponseJson);
            }
            catch (Exception e) {
                log.warn("\u67e5\u627e\u641c\u7d22\u65e5\u5fd7\u8bb0\u5f55\u603b\u6570\u5931\u8d25", (Throwable)e);
                return BaseRspUtils.createErrorRspList((String)"\u67e5\u627e\u641c\u7d22\u65e5\u5fd7\u8bb0\u5f55\u603b\u6570\u5931\u8d25");
            }
            JSONObject countResponse = JSON.parseObject((String)countResponseJson);
            if (countResponse.containsKey((Object)"failures")) {
                log.warn("\u67e5\u627e\u641c\u7d22\u65e5\u5fd7\u8bb0\u5f55\u603b\u6570\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)countResponse.getJSONArray("failures"));
                return BaseRspUtils.createErrorRspList((String)"\u67e5\u627e\u641c\u7d22\u65e5\u5fd7\u8bb0\u5f55\u603b\u6570\u5931\u8d25");
            }
            totalCount = countResponse.getLongValue("totalNumber");
        }
        try {
            log.info("\u67e5\u627e\u641c\u7d22\u65e5\u5fd7\u8bb0\u5f55\u5f00\u59cb\uff1a{}", (Object)JSON.toJSONString(request));
            dataResponseJson = this.restApiHelper.post(REPORT_DATA_URL, this.convertMapToFormDataWithEncoding(request), headers, new MediaType[0]);
            log.info("\u67e5\u627e\u641c\u7d22\u65e5\u5fd7\u8bb0\u5f55\u7ed3\u675f\uff1a{}", (Object)dataResponseJson);
        }
        catch (Exception e) {
            log.warn("\u67e5\u627e\u641c\u7d22\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25", (Throwable)e);
            return BaseRspUtils.createErrorRspList((String)"\u67e5\u627e\u641c\u7d22\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25");
        }
        JSONObject dataResponse = JSON.parseObject((String)dataResponseJson);
        if (dataResponse.containsKey((Object)"failures")) {
            log.warn("\u67e5\u627e\u641c\u7d22\u65e5\u5fd7\u8bb0\u5f55\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)dataResponse.getJSONObject("failures"));
            return BaseRspUtils.createErrorRspList((String)"\u67e5\u627e\u641c\u7d22\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25");
        }
        JSONArray datas = dataResponse.getJSONArray("querywordList");
        long count = datas.size();
        ArrayList<RpSearchLog> rpSearchLogs = new ArrayList<RpSearchLog>();
        int i = 0;
        while ((long)i < count) {
            JSONObject data = datas.getJSONObject(i);
            int click = data.getIntValue("clicks");
            int impressions = data.getIntValue("views");
            int consumption = data.getBigDecimal("totalCost").multiply(BigDecimal.valueOf(100L)).intValue();
            RpSearchLog rpSearchLog = new RpSearchLog();
            rpSearchLog.setSources("360".concat(promotionType.getDesc()));
            rpSearchLog.setTerm(data.getString("queryword"));
            rpSearchLog.setDayData(DateTimeUtil.convertAsDate((String)data.getString("date")));
            rpSearchLog.setPlanScheme(data.getString("campaignName"));
            rpSearchLog.setKeywordGroups(data.getString("groupName"));
            rpSearchLog.setKeyword(data.getString("keyword"));
            rpSearchLog.setMatchMode(data.getString("triggerType"));
            rpSearchLog.setImpressions(Integer.valueOf(impressions));
            rpSearchLog.setClick(Integer.valueOf(click));
            rpSearchLog.setConsumption(Integer.valueOf(consumption));
            if (impressions == 0) {
                rpSearchLog.setClickRate(Integer.valueOf(0));
            } else {
                rpSearchLog.setClickRate(Integer.valueOf(BigDecimal.valueOf(click).multiply(BigDecimal.valueOf(10000L)).divide(BigDecimal.valueOf(impressions), RoundingMode.HALF_UP).intValue()));
            }
            if (click == 0) {
                rpSearchLog.setAvgClickPrice(Integer.valueOf(0));
            } else {
                rpSearchLog.setAvgClickPrice(Integer.valueOf(BigDecimal.valueOf(consumption).divide(BigDecimal.valueOf(click), RoundingMode.HALF_UP).intValue()));
            }
            rpSearchLogs.add(rpSearchLog);
            ++i;
        }
        return BaseRspUtils.createSuccessRspList(rpSearchLogs, (long)totalCount);
    }

    private ApplicationBO getAppByApiKey(String apiKey) {
        return this.appConfigMap.get(apiKey);
    }

    public String convertMapToFormDataWithEncoding(Map<String, Object> request) {
        if (request == null || request.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : request.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) continue;
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(URLEncoder.encode(key, StandardCharsets.UTF_8)).append("=").append(URLEncoder.encode(value.toString(), StandardCharsets.UTF_8));
        }
        return sb.toString();
    }
}

