/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.report.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tydic.nbchat.train.api.NbchatTrainExamReportApi;
import com.tydic.nbchat.train.api.bo.ScoreRangeCount;
import com.tydic.nbchat.train.api.bo.eums.RpCourseItemType;
import com.tydic.nbchat.train.api.bo.report.QueryReportRequest;
import com.tydic.nbchat.train.api.bo.report.course.TrainRpCourseDataAnalysisRspBO;
import com.tydic.nbchat.train.api.bo.report.exam.TrainRpExamStudentsQueryReqBO;
import com.tydic.nbchat.train.api.bo.report.exam.TrainRpExamStudentsQueryRspBO;
import com.tydic.nbchat.train.api.rp_course.NbcahtTrainRpCourseCountApi;
import com.tydic.nbchat.train.mapper.NbchatExamTestRecordMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainRpDayItemMapper;
import com.tydic.nbchat.train.mapper.po.NbchatExamTestRecordCodition;
import com.tydic.nbchat.train.mapper.po.NbchatTrainRpDayItemCondition;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class NbChatTrainRpExamImpl
implements NbchatTrainExamReportApi {
    private static final Logger log = LoggerFactory.getLogger(NbChatTrainRpExamImpl.class);
    private final NbchatTrainRpDayItemMapper nbchatTrainRpDayItemMapper;
    private final NbchatExamTestRecordMapper nbchatExamTestRecordMapper;
    private final NbcahtTrainRpCourseCountApi nbcahtTrainRpCourseCountApi;

    public Rsp getEvaluationCount(TrainRpExamStudentsQueryReqBO reqBO) {
        log.info("\u7edf\u8ba1\u73af\u6bd4\u6570\u636e\uff1a{}", (Object)reqBO);
        Rsp rsp = this.nbcahtTrainRpCourseCountApi.getEvaluationCount(reqBO);
        log.info("\u7edf\u8ba1\u73af\u6bd4\u6570\u636e-\u7ed3\u675f\uff1a{}", (Object)rsp);
        return BaseRspUtils.createSuccessRsp((Object)rsp);
    }

    public Rsp getCompositeScore(TrainRpExamStudentsQueryReqBO reqBO) {
        log.info("\u83b7\u53d6\u7efc\u5408\u8bc4\u5206\uff1a{}", (Object)reqBO);
        TrainRpExamStudentsQueryRspBO trainRpExamStudentsQueryRspBO = new TrainRpExamStudentsQueryRspBO();
        NbchatExamTestRecordCodition nbchatExamTestRecordCodition = new NbchatExamTestRecordCodition();
        BeanUtils.copyProperties((Object)reqBO, (Object)nbchatExamTestRecordCodition);
        nbchatExamTestRecordCodition = this.nbchatExamTestRecordMapper.getCompositeScore(nbchatExamTestRecordCodition);
        if (Objects.isNull(nbchatExamTestRecordCodition)) {
            log.warn("\u83b7\u53d6\u7efc\u5408\u8bc4\u5206-\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return BaseRspUtils.createSuccessRsp((Object)trainRpExamStudentsQueryRspBO, (String)"\u67e5\u8be2\u5931\u8d25");
        }
        BeanUtils.copyProperties((Object)nbchatExamTestRecordCodition, (Object)trainRpExamStudentsQueryRspBO);
        log.info("\u83b7\u53d6\u7efc\u5408\u8bc4\u5206-\u7ed3\u675f\uff1a{}", (Object)trainRpExamStudentsQueryRspBO);
        return BaseRspUtils.createSuccessRsp((Object)trainRpExamStudentsQueryRspBO, (String)"\u67e5\u8be2\u6210\u529f");
    }

    public RspList getDataTrend(QueryReportRequest request) {
        log.info("\u7edf\u8ba1\u8bfe\u7a0b\u5b66\u4e60\u8d8b\u52bf\uff1a{}", (Object)request);
        if (request.getStartDate() == null) {
            request.setStartDate(DateTimeUtil.DateAddDayOfYear((int)-30));
        }
        if (request.getEndDate() == null) {
            request.setEndDate(new Date());
        }
        ArrayList<TrainRpCourseDataAnalysisRspBO> res = new ArrayList<TrainRpCourseDataAnalysisRspBO>();
        for (RpCourseItemType value : RpCourseItemType.examItems()) {
            TrainRpCourseDataAnalysisRspBO bo = this.nbcahtTrainRpCourseCountApi.calGraph(request, value);
            res.add(bo);
        }
        return BaseRspUtils.createSuccessRspList(res);
    }

    public RspList getEvaluationRanking(TrainRpExamStudentsQueryReqBO reqBO) {
        log.info("\u83b7\u53d6\u6d4b\u8bc4\u6392\u884c\uff1a{}", (Object)reqBO);
        DateTimeUtil.DateAddDayOfYear((int)1);
        if (reqBO.getStartDate() == null || reqBO.getEndDate() == null) {
            reqBO.setStartDate(DateTimeUtil.DateAddDayOfYear((int)-7));
            reqBO.setEndDate(DateTimeUtil.DateAddDayOfYear((int)-1));
        }
        ArrayList<Object> res = new ArrayList();
        NbchatTrainRpDayItemCondition nbchatTrainRpDayItemCondition = new NbchatTrainRpDayItemCondition();
        BeanUtils.copyProperties((Object)reqBO, (Object)nbchatTrainRpDayItemCondition);
        List nbchatTrainRpDayItemConditionList = this.nbchatTrainRpDayItemMapper.getEvaluationRanking(nbchatTrainRpDayItemCondition);
        log.info("\u83b7\u53d6\u6d4b\u8bc4\u6392\u884c-\u6570\u636e\u5e93\u67e5\u8be2\u7ed3\u679c\u5171\u6709\uff1a{}\u6761", (Object)nbchatTrainRpDayItemConditionList.size());
        if (CollectionUtils.isEmpty((Collection)nbchatTrainRpDayItemConditionList)) {
            log.warn("\u83b7\u53d6\u6d4b\u8bc4\u6392\u884c-\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return BaseRspUtils.createSuccessRspList(res, (long)Long.parseLong("0"));
        }
        ObjectMapper objectMapper = new ObjectMapper();
        HashMap<String, TrainRpExamStudentsQueryRspBO> resultMap = new HashMap<String, TrainRpExamStudentsQueryRspBO>();
        for (NbchatTrainRpDayItemCondition item : nbchatTrainRpDayItemConditionList) {
            ArrayList<ScoreRangeCount> scoreData = new ArrayList<ScoreRangeCount>();
            try {
                List rawScoreData = (List)objectMapper.readValue(item.getItemValues(), (TypeReference)new TypeReference<List<Map<String, Integer>>>(){});
                for (Map map : rawScoreData) {
                    for (Map.Entry entry : map.entrySet()) {
                        scoreData.add(new ScoreRangeCount(entry));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Map<String, Integer> scoreCounts = scoreData.stream().collect(Collectors.toMap(ScoreRangeCount::getRange, ScoreRangeCount::getCount));
            TrainRpExamStudentsQueryRspBO rspBO = resultMap.getOrDefault(item.getCourseId(), new TrainRpExamStudentsQueryRspBO());
            rspBO.setCourseName(item.getCourseName());
            int existingStudents = 0;
            if (StringUtils.isNotBlank((CharSequence)rspBO.getStudents())) {
                existingStudents = Integer.parseInt(rspBO.getStudents());
            }
            int newStudents = (int)Double.parseDouble(item.getStudents());
            rspBO.setStudents(String.valueOf(existingStudents + newStudents));
            float existingAvgScore = 0.0f;
            if (StringUtils.isNotBlank((CharSequence)rspBO.getAvgScore())) {
                existingAvgScore = Float.parseFloat(rspBO.getAvgScore());
            }
            float combinedAvgScore = 0.0f;
            if (existingStudents + newStudents != 0) {
                combinedAvgScore = (existingAvgScore * (float)existingStudents + Float.parseFloat(item.getAvgScore()) * (float)newStudents) / (float)(existingStudents + newStudents);
            }
            rspBO.setAvgScore(String.format("%.2f", Float.valueOf(combinedAvgScore)));
            rspBO.setFailedStudents(String.valueOf(Integer.parseInt(rspBO.getFailedStudents()) + scoreCounts.getOrDefault("0-59", 0)));
            rspBO.setPassStudents(String.valueOf(Integer.parseInt(rspBO.getPassStudents()) + scoreCounts.getOrDefault("60-79", 0)));
            rspBO.setGoodStudents(String.valueOf(Integer.parseInt(rspBO.getGoodStudents()) + scoreCounts.getOrDefault("80-89", 0)));
            rspBO.setExcellentStudents(String.valueOf(Integer.parseInt(rspBO.getExcellentStudents()) + scoreCounts.getOrDefault("90-100", 0)));
            int totalStudents = Integer.parseInt(rspBO.getStudents());
            rspBO.setFailed(NbChatTrainRpExamImpl.calculatePercentage(Integer.parseInt(rspBO.getFailedStudents()), totalStudents));
            rspBO.setPass(NbChatTrainRpExamImpl.calculatePercentage(Integer.parseInt(rspBO.getPassStudents()), totalStudents));
            rspBO.setGood(NbChatTrainRpExamImpl.calculatePercentage(Integer.parseInt(rspBO.getGoodStudents()), totalStudents));
            rspBO.setExcellent(NbChatTrainRpExamImpl.calculatePercentage(Integer.parseInt(rspBO.getExcellentStudents()), totalStudents));
            resultMap.put(item.getCourseId(), rspBO);
        }
        res = new ArrayList(resultMap.values());
        log.info("\u83b7\u53d6\u6d4b\u8bc4\u6392\u884c-\u8ba1\u7b97\u7ed3\u679c\uff1a{}", (Object)res.size());
        res = StringUtils.isNotBlank((CharSequence)reqBO.getSort()) && reqBO.getSort().equals("1") ? (ArrayList)res.stream().sorted(Comparator.comparing(bo -> Double.parseDouble(this.sortKey(reqBO.getSortField()).apply((TrainRpExamStudentsQueryRspBO)bo)))).collect(Collectors.toList()) : (ArrayList)res.stream().sorted(Comparator.comparing(bo -> Double.parseDouble(this.sortKey(reqBO.getSortField()).apply((TrainRpExamStudentsQueryRspBO)bo))).reversed()).collect(Collectors.toList());
        ArrayList resList = res.stream().skip((reqBO.getPage() - 1) * reqBO.getLimit()).limit(reqBO.getLimit()).collect(Collectors.toCollection(ArrayList::new));
        log.info("\u83b7\u53d6\u6d4b\u8bc4\u6392\u884c-\u6392\u5e8f\u7ed3\u679c\uff1a{},\u5171\u6709\uff1a{}\u6761", (Object)resList, (Object)nbchatTrainRpDayItemConditionList.size());
        return BaseRspUtils.createSuccessRspList((List)resList, (long)nbchatTrainRpDayItemConditionList.size());
    }

    private static String calculatePercentage(int numerator, int denominator) {
        if (denominator == 0) {
            return "0.00";
        }
        return String.format("%.2f", (double)numerator / (double)denominator * 100.0);
    }

    public Function<TrainRpExamStudentsQueryRspBO, String> sortKey(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return TrainRpExamStudentsQueryRspBO::getStudents;
        }
        if (key.equals("failed")) {
            return TrainRpExamStudentsQueryRspBO::getFailed;
        }
        if (key.equals("pass")) {
            return TrainRpExamStudentsQueryRspBO::getPass;
        }
        if (key.equals("good")) {
            return TrainRpExamStudentsQueryRspBO::getGood;
        }
        if (key.equals("excellent")) {
            return TrainRpExamStudentsQueryRspBO::getExcellent;
        }
        if (key.equals("avgScore")) {
            return TrainRpExamStudentsQueryRspBO::getAvgScore;
        }
        if (key.equals("students")) {
            return TrainRpExamStudentsQueryRspBO::getStudents;
        }
        log.info("\u4e0d\u652f\u6301\u7684\u6392\u5e8f\u5b57\u6bb5\uff1a{}", (Object)key);
        return null;
    }

    public NbChatTrainRpExamImpl(NbchatTrainRpDayItemMapper nbchatTrainRpDayItemMapper, NbchatExamTestRecordMapper nbchatExamTestRecordMapper, NbcahtTrainRpCourseCountApi nbcahtTrainRpCourseCountApi) {
        this.nbchatTrainRpDayItemMapper = nbchatTrainRpDayItemMapper;
        this.nbchatExamTestRecordMapper = nbchatExamTestRecordMapper;
        this.nbcahtTrainRpCourseCountApi = nbcahtTrainRpCourseCountApi;
    }
}

