/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.report.service.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nbchat.admin.api.bo.SysTenantQueryReqBO;
import com.tydic.nbchat.admin.api.bo.SysTenantQueryRspBO;
import com.tydic.nbchat.train.api.NbchatOpRpStstPtService;
import com.tydic.nbchat.train.api.bo.eums.RpCourseItemType;
import com.tydic.nbchat.train.api.bo.report.CountRpDayItemRequest;
import com.tydic.nbchat.train.api.bo.report.op.TrainOpReportRspBO;
import com.tydic.nbchat.train.api.bo.report.op.TrainOpStstPtRequestBO;
import com.tydic.nbchat.train.api.bo.report.op.TrainOpTenantRspBO;
import com.tydic.nbchat.train.api.rp_course.NbcahtTrainRpDayItemApi;
import com.tydic.nbchat.train.mapper.OpRpStstDayItemMapper;
import com.tydic.nbchat.train.mapper.OpRpStstPtMapper;
import com.tydic.nbchat.train.mapper.po.NbchatSysTenant;
import com.tydic.nbchat.train.mapper.po.OpRpStstDayItem;
import com.tydic.nbchat.train.mapper.po.OpRpStstDayItemCondition;
import com.tydic.nbchat.train.mapper.po.OpRpStstPt;
import com.tydic.nbchat.train.mapper.po.TenantSelectCondition;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class NbchatOpRpStstPtServiceImpl
implements NbchatOpRpStstPtService {
    private static final Logger log = LoggerFactory.getLogger(NbchatOpRpStstPtServiceImpl.class);
    private final OpRpStstPtMapper opRpStstPtMapper;
    private final NbcahtTrainRpDayItemApi nbcahtTrainRpDayItemApi;
    private final OpRpStstDayItemMapper opRpStstDayItemMapper;

    public NbchatOpRpStstPtServiceImpl(OpRpStstPtMapper opRpStstPtMapper, OpRpStstDayItemMapper opRpStstDayItemMapper, NbcahtTrainRpDayItemApi nbcahtTrainRpDayItemApi) {
        this.opRpStstPtMapper = opRpStstPtMapper;
        this.opRpStstDayItemMapper = opRpStstDayItemMapper;
        this.nbcahtTrainRpDayItemApi = nbcahtTrainRpDayItemApi;
    }

    public Rsp save(TrainOpStstPtRequestBO requestBO) {
        int commonTenant = this.opRpStstPtMapper.selectTrueOrFalseCommon(requestBO.getUserId());
        if (commonTenant == 1) {
            String companyName = this.opRpStstPtMapper.selectUserEnterprise(requestBO.getUserId());
            if (StringUtils.isNotBlank((CharSequence)companyName)) {
                requestBO.setTenantCode(companyName);
            }
        } else {
            int tydic = this.opRpStstPtMapper.selectTrueOrFalseTydic(requestBO.getUserId());
            if (tydic == 1) {
                requestBO.setTenantCode("000TYDIC");
            } else {
                String tenantCode = this.opRpStstPtMapper.selectTenantCode(requestBO.getUserId());
                requestBO.setTenantCode(tenantCode);
            }
        }
        OpRpStstPt opRpStstPt = new OpRpStstPt();
        BeanUtils.copyProperties((Object)requestBO, (Object)opRpStstPt);
        this.opRpStstPtMapper.insertSelective(opRpStstPt);
        return BaseRspUtils.createSuccessRsp((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    public Rsp queryReport(TrainOpStstPtRequestBO requestBO) {
        TrainOpTenantRspBO commonOpTenantTotal;
        TrainOpTenantRspBO commonOpTenantRspBO;
        TrainOpTenantRspBO professionalTenantRspBO;
        Map<String, Long> summaryByTenantCode;
        requestBO.setLimit(99999);
        this.count();
        TrainOpReportRspBO reportRspBO = new TrainOpReportRspBO();
        SysTenantQueryReqBO reqBO = new SysTenantQueryReqBO();
        BeanUtils.copyProperties((Object)requestBO, (Object)reqBO);
        RspList rspList = this.selectTenantList(reqBO, true);
        if (rspList.isSuccess()) {
            List periodList = rspList.getRows();
            summaryByTenantCode = periodList.stream().collect(Collectors.groupingBy(trainOpTenantRspBO -> "00000000".equals(trainOpTenantRspBO.getTenantCode()) ? "00000000" : "professional", Collectors.counting()));
            reportRspBO.setTenantNum(summaryByTenantCode.get("professional") == null ? 0 : summaryByTenantCode.get("professional").intValue());
            reportRspBO.setEnterpriseNum(summaryByTenantCode.get("00000000") == null ? 0 : summaryByTenantCode.get("00000000").intValue());
        }
        requestBO.setIsDate(Boolean.valueOf(false));
        RspList rspBOList = this.queryTenantDataList(requestBO);
        if (rspBOList.isSuccess()) {
            List tenantRspBOList = rspBOList.getRows();
            ArrayList<TrainOpTenantRspBO> trainOpTenantRspBOS = new ArrayList<TrainOpTenantRspBO>();
            for (TrainOpTenantRspBO tenantRspBO : tenantRspBOList) {
                trainOpTenantRspBOS.add(tenantRspBO.deepCopy());
            }
            reportRspBO.setOpTenantRspBOList(trainOpTenantRspBOS);
        }
        if ((professionalTenantRspBO = (TrainOpTenantRspBO)(summaryByTenantCode = this.processorData(requestBO)).get("professional")) != null) {
            reportRspBO.setTenantUserNum(professionalTenantRspBO.getTenantUserNum());
            reportRspBO.setVideoNum(professionalTenantRspBO.getVideoNum());
            reportRspBO.setVideoSuccessNum(professionalTenantRspBO.getVideoSuccessNum());
            reportRspBO.setPptNum(professionalTenantRspBO.getPptNum());
            reportRspBO.setQuestionNum(professionalTenantRspBO.getQuestionNum());
        }
        if ((commonOpTenantRspBO = (TrainOpTenantRspBO)summaryByTenantCode.get("00000000")) != null) {
            reportRspBO.setEnterpriseUserNum(commonOpTenantRspBO.getTenantUserNum());
            reportRspBO.setVideoNum(reportRspBO.getVideoNum() + commonOpTenantRspBO.getVideoNum());
            reportRspBO.setVideoSuccessNum(reportRspBO.getVideoSuccessNum() + commonOpTenantRspBO.getVideoSuccessNum());
            reportRspBO.setPptNum(reportRspBO.getPptNum() + commonOpTenantRspBO.getPptNum());
            reportRspBO.setQuestionNum(reportRspBO.getQuestionNum() + commonOpTenantRspBO.getQuestionNum());
        }
        requestBO.setEndTime(new Date());
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 2022);
        calendar.set(2, 3);
        calendar.set(5, 2);
        calendar.set(11, 15);
        calendar.set(12, 30);
        Date startTime = calendar.getTime();
        requestBO.setStartTime(startTime);
        Map<String, TrainOpTenantRspBO> totalData = this.processorData(requestBO);
        TrainOpTenantRspBO professionalTenantTotal = totalData.get("professional");
        if (professionalTenantTotal != null) {
            reportRspBO.setTenantTotal(professionalTenantTotal.getTenantNum());
            reportRspBO.setTenantUserTotal(professionalTenantTotal.getTenantUserNum());
        }
        if ((commonOpTenantTotal = totalData.get("00000000")) != null) {
            reportRspBO.setEnterpriseTotal(commonOpTenantTotal.getTenantNum());
            reportRspBO.setEnterpriseUserTotal(commonOpTenantTotal.getTenantUserNum());
        }
        if (professionalTenantTotal != null && commonOpTenantTotal != null) {
            reportRspBO.setVideoTotal(professionalTenantTotal.getVideoNum() + commonOpTenantTotal.getVideoNum());
            reportRspBO.setVideoSuccessTotal(professionalTenantTotal.getVideoSuccessNum() + commonOpTenantTotal.getVideoSuccessNum());
            reportRspBO.setPptTotal(professionalTenantTotal.getPptNum() + commonOpTenantTotal.getPptNum());
            reportRspBO.setQuestionTotal(professionalTenantTotal.getQuestionNum() + commonOpTenantTotal.getQuestionNum());
        }
        Date lastLoginTime = this.opRpStstDayItemMapper.selectLastLoginTime(null);
        reportRspBO.setLastLoginTime(lastLoginTime);
        return BaseRspUtils.createSuccessRsp((Object)reportRspBO);
    }

    public RspList queryTenantDataList(TrainOpStstPtRequestBO requestBO) {
        ArrayList tenantDataLists = new ArrayList();
        SysTenantQueryReqBO reqBO = new SysTenantQueryReqBO();
        BeanUtils.copyProperties((Object)requestBO, (Object)reqBO);
        RspList rspList = this.selectTenantList(reqBO, requestBO.getIsDate());
        if (rspList.isSuccess()) {
            List list = rspList.getRows();
            list.forEach(sysTenantQueryRspBO -> {
                TrainOpTenantRspBO rspBO = new TrainOpTenantRspBO();
                OpRpStstDayItem opRpStstDayItem = new OpRpStstDayItem();
                rspBO.setCreateTime(sysTenantQueryRspBO.getCreateTime());
                rspBO.setTenantName(sysTenantQueryRspBO.getTenantName());
                rspBO.setTenantCode(sysTenantQueryRspBO.getTenantCode());
                rspBO.setTenantNum(1);
                if (StringUtils.isNotBlank((CharSequence)sysTenantQueryRspBO.getTenantCode()) && sysTenantQueryRspBO.getTenantCode().equals("00000000")) {
                    rspBO.setCommonTenant(true);
                    opRpStstDayItem.setTenantCode(sysTenantQueryRspBO.getTenantName());
                    rspBO.setGroupTenantCode(sysTenantQueryRspBO.getTenantCode());
                    lastLoginTime = this.opRpStstDayItemMapper.selectCommonTenantLastLoginTime(sysTenantQueryRspBO.getTenantName());
                    rspBO.setLastLoginTime(lastLoginTime);
                } else {
                    opRpStstDayItem.setTenantCode(sysTenantQueryRspBO.getTenantCode());
                    rspBO.setGroupTenantCode("professional");
                    lastLoginTime = this.opRpStstDayItemMapper.selectLastLoginTime(sysTenantQueryRspBO.getTenantCode());
                    rspBO.setLastLoginTime(lastLoginTime);
                }
                OpRpStstDayItemCondition condition = new OpRpStstDayItemCondition();
                BeanUtils.copyProperties((Object)opRpStstDayItem, (Object)condition);
                condition.setStartTime(requestBO.getStartTime());
                condition.setEndTime(requestBO.getEndTime());
                this.selectTenantData(condition, rspBO);
                tenantDataLists.add(rspBO);
            });
        }
        rspList.setRows(tenantDataLists);
        return rspList;
    }

    public Rsp queryReportTenantList(TrainOpStstPtRequestBO requestBO, TrainOpReportRspBO reportRspBO) {
        this.count();
        ArrayList rspBOList = new ArrayList();
        OpRpStstDayItemCondition condition = new OpRpStstDayItemCondition();
        condition.setStartTime(requestBO.getStartTime());
        condition.setEndTime(requestBO.getEndTime());
        List tenantDataList = this.opRpStstDayItemMapper.selectTenantDataList(condition);
        tenantDataList.forEach(item -> {
            TrainOpTenantRspBO rspBO = new TrainOpTenantRspBO();
            rspBO.setTenantCode(item.getTenantCode());
            this.analyticalItemCodeData(rspBO, (OpRpStstDayItem)item);
            NbchatSysTenant sysTenant = this.opRpStstDayItemMapper.decideProfessionalTenant(item.getTenantCode());
            if (sysTenant == null) {
                rspBO.setCommonTenant(true);
                rspBO.setGroupTenantCode("00000000");
                sysTenant = this.opRpStstDayItemMapper.decideCommonTenant(item.getTenantCode());
            } else {
                rspBO.setGroupTenantCode("professional");
                rspBO.setCommonTenant(false);
            }
            rspBO.setCreateTime(sysTenant.getCreateTime());
            rspBO.setTenantName(sysTenant.getTenantName());
            rspBOList.add(rspBO);
        });
        Map<String, TrainOpTenantRspBO> tenantRspBOMap = rspBOList.stream().collect(Collectors.toMap(TrainOpTenantRspBO::getTenantCode, bo -> bo, (bo1, bo2) -> {
            bo1.addMetrics(bo2);
            return bo1;
        }));
        ArrayList tenantRspBOList = new ArrayList();
        tenantRspBOMap.forEach((tenant, item) -> {
            int result = item.getCreateTime().compareTo(requestBO.getStartTime());
            if (result > 0) {
                item.setTenantNum(1);
            }
            tenantRspBOList.add(item);
        });
        reportRspBO.setOpTenantRspBOList(tenantRspBOList);
        ArrayList<TrainOpTenantRspBO> trainOpTenantRspBOS = new ArrayList<TrainOpTenantRspBO>();
        for (TrainOpTenantRspBO tenantRspBO : tenantRspBOList) {
            trainOpTenantRspBOS.add(tenantRspBO.deepCopy());
        }
        this.analytical(reportRspBO, trainOpTenantRspBOS, requestBO);
        return BaseRspUtils.createSuccessRsp((Object)reportRspBO);
    }

    private Map<String, TrainOpTenantRspBO> processorData(TrainOpStstPtRequestBO requestBO) {
        List<Object> tenantRspBOList = new ArrayList<TrainOpTenantRspBO>();
        requestBO.setIsDate(Boolean.valueOf(false));
        RspList rspBOList = this.queryTenantDataList(requestBO);
        if (rspBOList.isSuccess()) {
            tenantRspBOList = rspBOList.getRows();
        }
        Map<String, TrainOpTenantRspBO> summaryByTenantCode = this.sumData(tenantRspBOList);
        log.debug("\u79df\u6237\u6570\u636e\u7edf\u8ba1\u7ed3\u679c\uff1a{}", tenantRspBOList);
        return summaryByTenantCode;
    }

    private void count() {
        ArrayList<String> itemCodeList = new ArrayList<String>();
        itemCodeList.add(RpCourseItemType.new_registrations.getCode());
        itemCodeList.add(RpCourseItemType.question_creators.getCode());
        itemCodeList.add(RpCourseItemType.ppt_creators.getCode());
        itemCodeList.add(RpCourseItemType.video_creators.getCode());
        itemCodeList.add(RpCourseItemType.video_success.getCode());
        for (String itemCode : itemCodeList) {
            Date start = DateTimeUtil.createTime((Date)DateTimeUtil.DateAddDayOfYear((int)0), (int)0, (int)0, (int)0);
            CountRpDayItemRequest request = CountRpDayItemRequest.builder().itemCode(itemCode).startTime(start).endTime(new Date()).build();
            Rsp rsp = this.nbcahtTrainRpDayItemApi.countRpDayItem(request);
            log.info("\u62a5\u8868\u7edf\u8ba1\u4efb\u52a1,\u6307\u6807\u7edf\u8ba1:{}|{}", (Object)request, (Object)rsp);
        }
    }

    public RspList selectTenantList(SysTenantQueryReqBO reqBO, boolean isDate) {
        TenantSelectCondition condition = new TenantSelectCondition();
        log.info("\u67e5\u8be2\u79df\u6237-\u5206\u9875\u67e5\u8be2\u79df\u6237\u5217\u8868\uff1a{}", (Object)reqBO);
        if (isDate) {
            condition.setStartTime(reqBO.getStartTime());
            condition.setEndTime(reqBO.getEndTime());
        }
        ArrayList result = new ArrayList();
        Page page = PageHelper.startPage((int)reqBO.getPage(), (int)reqBO.getLimit());
        condition.setIsValid(EntityValidType.NORMAL.getCode());
        condition.setTenantCode(reqBO.getTargetTenant());
        condition.setTenantName(reqBO.getTenantName());
        List nbchatSysTenantList = this.opRpStstDayItemMapper.selectTenantList(condition);
        if (CollectionUtils.isEmpty((Collection)nbchatSysTenantList)) {
            return BaseRspUtils.createSuccessRspList(result);
        }
        NiccCommonUtil.copyList((List)page.getResult(), result, SysTenantQueryRspBO.class);
        return BaseRspUtils.createSuccessRspList(result, (long)page.getTotal());
    }

    private void selectTenantData(OpRpStstDayItemCondition condition, TrainOpTenantRspBO rspBO) {
        List tenantDataList = this.opRpStstDayItemMapper.selectTenantDataList(condition);
        tenantDataList.forEach(tenantData -> this.analyticalItemCodeData(rspBO, (OpRpStstDayItem)tenantData));
    }

    private Map<String, TrainOpTenantRspBO> sumData(List<TrainOpTenantRspBO> tenantRspBOList) {
        Map<String, TrainOpTenantRspBO> summaryByTenantCode = tenantRspBOList.stream().collect(Collectors.toMap(TrainOpTenantRspBO::getGroupTenantCode, bo -> bo, (bo1, bo2) -> {
            bo1.addMetrics(bo2);
            return bo1;
        }));
        return summaryByTenantCode;
    }

    private void analyticalItemCodeData(TrainOpTenantRspBO rspBO, OpRpStstDayItem tenantData) {
        if (RpCourseItemType.new_registrations.getCode().equals(tenantData.getItemCode())) {
            rspBO.setTenantUserNum(tenantData.getItemValue());
        } else if (RpCourseItemType.question_creators.getCode().equals(tenantData.getItemCode())) {
            rspBO.setQuestionNum(tenantData.getItemValue());
        } else if (RpCourseItemType.ppt_creators.getCode().equals(tenantData.getItemCode())) {
            rspBO.setPptNum(tenantData.getItemValue());
        } else if (RpCourseItemType.video_creators.getCode().equals(tenantData.getItemCode())) {
            rspBO.setVideoNum(tenantData.getItemValue());
        } else if (RpCourseItemType.video_success.getCode().equals(tenantData.getItemCode())) {
            int successVideoNum = tenantData.getItemValue();
            rspBO.setVideoSuccessNum(tenantData.getItemValue());
            int videoNum = rspBO.getVideoNum();
            double success = (double)successVideoNum / (double)videoNum;
            rspBO.setVideoFailProbability(rspBO.getVideoNum() > 0 ? (1.0 - success) * 100.0 : 0.0);
        }
    }

    private void analytical(TrainOpReportRspBO reportRspBO, List<TrainOpTenantRspBO> trainOpTenantRspBOS, TrainOpStstPtRequestBO requestBO) {
        TrainOpTenantRspBO commonOpTenantRspBO;
        Map<String, TrainOpTenantRspBO> summaryByTenantCode = this.sumData(trainOpTenantRspBOS);
        TrainOpTenantRspBO professionalTenantRspBO = summaryByTenantCode.get("professional");
        if (professionalTenantRspBO != null) {
            reportRspBO.setTenantUserNum(professionalTenantRspBO.getTenantUserNum());
            reportRspBO.setVideoNum(professionalTenantRspBO.getVideoNum());
            reportRspBO.setVideoSuccessNum(professionalTenantRspBO.getVideoSuccessNum());
            reportRspBO.setPptNum(professionalTenantRspBO.getPptNum());
            reportRspBO.setQuestionNum(professionalTenantRspBO.getQuestionNum());
        }
        if ((commonOpTenantRspBO = summaryByTenantCode.get("00000000")) != null) {
            reportRspBO.setEnterpriseUserNum(commonOpTenantRspBO.getTenantUserNum());
            reportRspBO.setVideoNum(reportRspBO.getVideoNum() + commonOpTenantRspBO.getVideoNum());
            reportRspBO.setVideoSuccessNum(reportRspBO.getVideoSuccessNum() + commonOpTenantRspBO.getVideoSuccessNum());
            reportRspBO.setPptNum(reportRspBO.getPptNum() + commonOpTenantRspBO.getPptNum());
            reportRspBO.setQuestionNum(reportRspBO.getQuestionNum() + commonOpTenantRspBO.getQuestionNum());
        }
        SysTenantQueryReqBO reqBO = new SysTenantQueryReqBO();
        BeanUtils.copyProperties((Object)requestBO, (Object)reqBO);
        RspList rspList = this.selectTenantList(reqBO, true);
        if (rspList.isSuccess()) {
            List periodList = rspList.getRows();
            Map<String, Long> tenantMap = periodList.stream().collect(Collectors.groupingBy(trainOpTenantRspBO -> "00000000".equals(trainOpTenantRspBO.getTenantCode()) ? "00000000" : "professional", Collectors.counting()));
            reportRspBO.setTenantNum(tenantMap.get("professional") == null ? 0 : tenantMap.get("professional").intValue());
            reportRspBO.setEnterpriseNum(tenantMap.get("00000000") == null ? 0 : tenantMap.get("00000000").intValue());
        }
    }
}

