/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.report.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nbchat.admin.api.bo.file.FileUploadRequest;
import com.tydic.nbchat.admin.api.fileMannager.FileManageService;
import com.tydic.nbchat.train.api.NbchatTrainCourseScoreApi;
import com.tydic.nbchat.train.api.bo.course.TrainCourseScoreQueryReqBO;
import com.tydic.nbchat.train.api.bo.course.TrainCourseScoreQueryRspBO;
import com.tydic.nbchat.train.api.bo.course.TrainUserQueryReqBO;
import com.tydic.nbchat.train.api.bo.course.TrainUserQueryRspBO;
import com.tydic.nbchat.train.mapper.NameMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainCourseScoreMapper;
import com.tydic.nbchat.train.mapper.po.NbchatCourseScore;
import com.tydic.nbchat.train.mapper.po.NbchatCourseScoreSelectCondition;
import com.tydic.nbchat.train.mapper.po.NbchatTrainUserSelectCondition;
import com.tydic.nbchat.user.api.NbchatUserApi;
import com.tydic.nbchat.user.api.bo.NbchatUserInfo;
import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.framework.utils.FileManagerHelper;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class NbchatTrainCourseScoreImpl
implements NbchatTrainCourseScoreApi {
    private static final Logger log = LoggerFactory.getLogger(NbchatTrainCourseScoreImpl.class);
    @Resource
    private NbchatTrainCourseScoreMapper nbchatTrainCourseScoreMapper;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=5000)
    private FileManageService fileManageService;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=100000)
    private NbchatUserApi nbchatUserApi;
    @Resource
    NameMapper nameMapper;

    @MethodParamVerifyEnable
    public RspList getStudyRecordsByPage(TrainCourseScoreQueryReqBO reqBO) {
        log.info("\u8bfe\u7a0b\u7edf\u8ba1-:{}", (Object)reqBO);
        ArrayList result = new ArrayList();
        NbchatCourseScoreSelectCondition nbchatCourseScoreSelectCondition = new NbchatCourseScoreSelectCondition();
        BeanUtils.copyProperties((Object)reqBO, (Object)nbchatCourseScoreSelectCondition);
        Page page = PageHelper.startPage((int)reqBO.getPage(), (int)reqBO.getLimit());
        List list = this.nbchatTrainCourseScoreMapper.getGrades(nbchatCourseScoreSelectCondition);
        if (CollectionUtils.isEmpty((Collection)list)) {
            log.warn("\u8bfe\u7a0b\u7edf\u8ba1-\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return BaseRspUtils.createSuccessRspList(result, (long)0L);
        }
        page.getResult().forEach(item -> {
            if (StringUtils.isNotBlank((CharSequence)item.getTestState()) && item.getTestState().equals("\u662f")) {
                NbchatCourseScore score = this.nbchatTrainCourseScoreMapper.getScore(item);
                item.setScore(score.getScore());
                item.setTestCount(score.getTestCount());
            } else {
                item.setScore("\u7a7a");
                item.setTestCount("0");
            }
            String deptId = item.getDeptId();
            if (StringUtils.isBlank((CharSequence)item.getDeptId())) {
                deptId = item.getTenantCode();
            }
            String deptName = this.nameMapper.queryOrganizeName(deptId);
            item.setDeptName(deptName);
        });
        NiccCommonUtil.copyList((List)page.getResult(), result, TrainCourseScoreQueryRspBO.class);
        log.info("\u8bfe\u7a0b\u7edf\u8ba1-\u67e5\u8be2\u6210\u529f:{}|{}", result, (Object)page.getTotal());
        return BaseRspUtils.createSuccessRspList(result, (long)page.getTotal());
    }

    public Rsp export(TrainCourseScoreQueryReqBO reqBO) {
        log.info("\u8bfe\u7a0b\u7edf\u8ba1-\u5bfc\u51fa:{}", (Object)reqBO);
        NbchatCourseScoreSelectCondition nbchatCourseScoreSelectCondition = new NbchatCourseScoreSelectCondition();
        BeanUtils.copyProperties((Object)reqBO, (Object)nbchatCourseScoreSelectCondition);
        List result = this.nbchatTrainCourseScoreMapper.getGrades(nbchatCourseScoreSelectCondition);
        if (CollectionUtils.isEmpty((Collection)result)) {
            log.warn("\u8bfe\u7a0b\u7edf\u8ba1-\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return BaseRspUtils.createErrorRsp((String)"\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
        }
        result.forEach(item -> {
            if (StringUtils.isNotBlank((CharSequence)item.getTestState()) && item.getTestState().equals("\u662f")) {
                NbchatCourseScore score = this.nbchatTrainCourseScoreMapper.getScore(item);
                item.setScore(score.getScore());
                item.setTestCount(score.getTestCount());
            } else {
                item.setScore("\u7a7a");
                item.setTestCount("0");
            }
        });
        TrainCourseScoreQueryRspBO trainCourseScoreQueryRspBO = new TrainCourseScoreQueryRspBO();
        try {
            String fileName = "\u8bfe\u7a0b\u7edf\u8ba1" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".xlsx";
            String tempPath = System.getProperty("java.io.tmpdir");
            File dirFile = new File(tempPath + "/" + fileName);
            EasyExcel.write((File)dirFile, NbchatCourseScore.class).sheet("\u8bfe\u7a0b\u7edf\u8ba1").doWrite((Collection)result);
            log.info("\u8bfe\u7a0b\u7edf\u8ba1-\u5bfc\u51fa:{}|{}", (Object)dirFile.exists(), (Object)dirFile.getAbsolutePath());
            MultipartFile multipartFile = FileManagerHelper.parseToMultipartFile((File)dirFile);
            FileUploadRequest uploadRequest = new FileUploadRequest();
            uploadRequest.setTenantCode(reqBO.getTenantCode());
            uploadRequest.setUploadUser(reqBO.get_userId());
            uploadRequest.setFileName(dirFile.getName());
            uploadRequest.setFile(multipartFile.getBytes());
            uploadRequest.setUploadUser(reqBO.get_userId());
            RspList fileManageSaveBOS = this.fileManageService.fileUploadRequest(uploadRequest);
            log.info("\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6bd5\uff0c\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)fileManageSaveBOS));
            if (!fileManageSaveBOS.isSuccess()) {
                return BaseRspUtils.createErrorRsp((String)"\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25");
            }
            trainCourseScoreQueryRspBO.setFileManageSaveBO(fileManageSaveBOS.getRows());
            log.info("\u8bfe\u7a0b\u7edf\u8ba1-\u5bfc\u51fa\u6210\u529f");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return BaseRspUtils.createSuccessRsp((Object)trainCourseScoreQueryRspBO, (String)"\u5bfc\u51fa\u6210\u529f");
    }

    public RspList getUserInformation(TrainUserQueryReqBO reqBO) {
        log.info("\u8bfe\u7a0b\u7edf\u8ba1-\u83b7\u53d6\u7528\u6237\u59d3\u540d-\u624b\u673a\u53f7:{}", (Object)reqBO);
        ArrayList result = new ArrayList();
        NbchatTrainUserSelectCondition nbChatTrainUserSelectCondition = new NbchatTrainUserSelectCondition();
        BeanUtils.copyProperties((Object)reqBO, (Object)nbChatTrainUserSelectCondition);
        Page page = PageHelper.startPage((int)reqBO.getPage(), (int)reqBO.getLimit());
        List nbchatTrainUserTenantList = this.nbchatTrainCourseScoreMapper.getUserInformation(nbChatTrainUserSelectCondition);
        if (CollectionUtils.isEmpty((Collection)nbchatTrainUserTenantList)) {
            log.info("\u8bfe\u7a0b\u7edf\u8ba1-\u83b7\u53d6\u7528\u6237\u59d3\u540d-\u624b\u673a\u53f7\u7ed3\u679c\u4e3a\u7a7a,\u8be5\u79df\u6237:{}\u4e0b\u6ca1\u6709\u540d\u5b57\u4e3a:{}\u7684\u7528\u6237", (Object)reqBO.getTenantCode(), (Object)reqBO);
            return BaseRspUtils.createSuccessRspList(result, (long)Long.parseLong("0"));
        }
        page.getResult().forEach(nbchatTrainUserTenant -> {
            String userId = nbchatTrainUserTenant.getUserId();
            String userRealityName = nbchatTrainUserTenant.getUserRealityName();
            Rsp rsp = this.nbchatUserApi.getUserInfo(userId);
            if (rsp.isSuccess()) {
                NbchatUserInfo nbchatUserInfo = (NbchatUserInfo)rsp.getData();
                log.info("\u8bfe\u7a0b\u7edf\u8ba1-\u83b7\u53d6\u7528\u6237\u59d3\u540d-\u624b\u673a\u53f7\u6210\u529f,\u7528\u6237\u4fe1\u606f:{}", (Object)nbchatUserInfo);
                TrainUserQueryRspBO trainUserQueryRspBO = new TrainUserQueryRspBO();
                trainUserQueryRspBO.setUserRealityName(userRealityName);
                trainUserQueryRspBO.setUserPhone(nbchatUserInfo.getPhone());
                result.add(trainUserQueryRspBO);
            } else {
                log.error("\u8bfe\u7a0b\u7edf\u8ba1-\u83b7\u53d6\u7528\u6237\u59d3\u540d-\u624b\u673a\u53f7,\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5931\u8d25:{}", (Object)userId);
            }
        });
        return BaseRspUtils.createSuccessRspList(result, (long)page.getTotal());
    }
}

