/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.report.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.tydic.nbchat.train.api.bo.eums.RpCourseItemType;
import com.tydic.nbchat.train.api.bo.eums.StateEnum;
import com.tydic.nbchat.train.api.bo.report.QueryReportRequest;
import com.tydic.nbchat.train.api.bo.report.course.TrainRpCourseCountItemReqBO;
import com.tydic.nbchat.train.api.bo.report.course.TrainRpCourseDataAnalysisRspBO;
import com.tydic.nbchat.train.api.bo.report.dialogue.TrainRpDialogueRankRspBO;
import com.tydic.nbchat.train.api.rp_course.NbcahtTrainRpCourseCountApi;
import com.tydic.nbchat.train.api.rp_dialogue.NbchatTrainRpDialogueApi;
import com.tydic.nbchat.train.mapper.NbchatTrainCourseMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainRpDayItemMapper;
import com.tydic.nbchat.train.mapper.po.NbchatTrainCourse;
import com.tydic.nbchat.train.mapper.po.NbchatTrainCourseSelectCondition;
import com.tydic.nbchat.train.mapper.po.NbchatTrainRpDayItem;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class NbchatTrainRpDialogueSeriviceImpl
implements NbchatTrainRpDialogueApi {
    private static final Logger log = LoggerFactory.getLogger(NbchatTrainRpDialogueSeriviceImpl.class);
    @Resource
    NbcahtTrainRpCourseCountApi nbcahtTrainRpCourseCountApi;
    @Resource
    NbchatTrainRpDayItemMapper nbchatTrainRpDayItemMapper;
    @Resource
    NbchatTrainCourseMapper nbchatTrainCourseMapper;

    public Rsp countItem(QueryReportRequest request) {
        log.info("\u7edf\u8ba1\u573a\u666f\u5b9e\u8df5\u6307\u6807:{}", (Object)request);
        TrainRpCourseCountItemReqBO reqBO = new TrainRpCourseCountItemReqBO();
        reqBO.setTenantCode(request.getTenantCode());
        return this.nbcahtTrainRpCourseCountApi.countDialogueItem(reqBO);
    }

    public Rsp circleScore(QueryReportRequest request) {
        log.info("\u7edf\u8ba1\u573a\u666f\u5b9e\u8df5-\u7efc\u5408\u8bc4\u5206:{}", (Object)request);
        JSONObject res = new JSONObject(){
            {
                this.put("\u4f18\u79c0", 0);
                this.put("\u826f\u597d", 0);
                this.put("\u4e2d\u7b49", 0);
                this.put("\u53ca\u683c", 0);
                this.put("\u4e0d\u53ca\u683c", 0);
            }
        };
        NbchatTrainRpDayItem cond = new NbchatTrainRpDayItem();
        cond.setTenantCode(request.getTenantCode());
        cond.setCountDay(DateTimeUtil.DateAddDayOfYear((int)-1));
        cond.setItemCode(RpCourseItemType.dialogue_level_count.getCode());
        List items = this.nbchatTrainRpDayItemMapper.selectAll(cond);
        if (CollectionUtils.isEmpty((Collection)items)) {
            return BaseRspUtils.createSuccessRsp((Object)res);
        }
        for (NbchatTrainRpDayItem item : items) {
            JSONObject entity = JSON.parseObject((String)item.getItemValues());
            res.put((String)entity.get((Object)"key"), (Object)item.getItemValue());
        }
        return BaseRspUtils.createSuccessRsp((Object)res);
    }

    public RspList analysis(QueryReportRequest request) {
        log.info("\u7edf\u8ba1\u573a\u666f\u5b9e\u8df5\u8d8b\u52bf\uff1a{}", (Object)request);
        if (request.getStartDate() == null) {
            request.setEndDate(DateTimeUtil.DateAddDayOfYear((int)-30));
        }
        if (request.getEndDate() == null) {
            request.setEndDate(new Date());
        }
        ArrayList<TrainRpCourseDataAnalysisRspBO> res = new ArrayList<TrainRpCourseDataAnalysisRspBO>();
        for (RpCourseItemType value : RpCourseItemType.dialogueItems()) {
            TrainRpCourseDataAnalysisRspBO bo = this.nbcahtTrainRpCourseCountApi.calGraph(request, value);
            res.add(bo);
        }
        return BaseRspUtils.createSuccessRspList(res);
    }

    public RspList rank(QueryReportRequest request) {
        log.info("\u573a\u666f\u5b9e\u8df5\u6392\u884c\uff1a{}", (Object)request);
        ArrayList res = new ArrayList();
        if (ObjectUtils.isEmpty((Object)request.getStartDate())) {
            request.setStartDate(DateTimeUtil.DateAddDayOfYear((int)-30));
        }
        if (ObjectUtils.isEmpty((Object)request.getEndDate())) {
            request.setEndDate(new Date());
        }
        NbchatTrainRpDayItem cond = new NbchatTrainRpDayItem();
        cond.setTenantCode(request.getTenantCode());
        cond.setItemCode(RpCourseItemType.dialogue_rank_count.getCode());
        cond.setStartDate(request.getStartDate());
        cond.setEndDate(request.getEndDate());
        List rankList = this.nbchatTrainRpDayItemMapper.selectAll(cond);
        Map<String, List<NbchatTrainRpDayItem>> collect = rankList.stream().collect(Collectors.groupingBy(NbchatTrainRpDayItem::getCourseId));
        NbchatTrainCourseSelectCondition query = new NbchatTrainCourseSelectCondition();
        query.setTenantCode(request.getTenantCode());
        query.setCourseState(StateEnum.COURSE.ON.getCode());
        query.setIsValid(EntityValidType.NORMAL.getCode());
        query.setCourseTypes(request.getCourseTypes());
        List courses = this.nbchatTrainCourseMapper.selectByCondition(query);
        for (NbchatTrainCourse course : courses) {
            TrainRpDialogueRankRspBO bo = new TrainRpDialogueRankRspBO();
            bo.setCourseName(course.getCourseName());
            List<NbchatTrainRpDayItem> records = collect.get(course.getCourseId());
            if (CollectionUtils.isNotEmpty(records)) {
                List<JSONArray> itemValues = records.stream().map(NbchatTrainRpDayItem::getItemValues).map(JSON::parseArray).collect(Collectors.toList());
                HashMap<String, Integer> valuesMap = this.analysisValues(itemValues);
                bo.setUserTotal(valuesMap.get("userTotal"));
                bo.setAvgScore(Integer.valueOf(valuesMap.get("totalTimes") == 0 ? 0 : valuesMap.get("totalScore") / valuesMap.get("totalTimes")));
                if (bo.getUserTotal() > 0) {
                    bo.setLevel_1(Integer.valueOf(100 * valuesMap.get("\u4f18\u79c0") / bo.getUserTotal()));
                    bo.setLevel_2(Integer.valueOf(100 * valuesMap.get("\u826f\u597d") / bo.getUserTotal()));
                    bo.setLevel_3(Integer.valueOf(100 * valuesMap.get("\u4e2d\u7b49") / bo.getUserTotal()));
                    bo.setLevel_4(Integer.valueOf(100 * valuesMap.get("\u53ca\u683c") / bo.getUserTotal()));
                    bo.setLevel_5(Integer.valueOf(100 * valuesMap.get("\u4e0d\u53ca\u683c") / bo.getUserTotal()));
                }
            }
            res.add(bo);
        }
        if (request.getOrderType().equals("asc")) {
            res = (ArrayList)res.stream().sorted(Comparator.comparing(this.sortKey(request.getOrderCode()))).collect(Collectors.toList());
        }
        if (request.getOrderType().equals("desc")) {
            res = (ArrayList)res.stream().sorted(Comparator.comparing(this.sortKey(request.getOrderCode())).reversed()).collect(Collectors.toList());
        }
        ArrayList resList = res.stream().skip((request.getPage() - 1) * request.getLimit()).limit(request.getLimit()).collect(Collectors.toCollection(ArrayList::new));
        return BaseRspUtils.createSuccessRspList((List)resList, (long)res.size());
    }

    public HashMap<String, Integer> analysisValues(List<JSONArray> itemValues) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        DocumentContext context = JsonPath.parse(itemValues);
        for (String item : jsonItems) {
            List values = (List)context.read("$.." + item, List.class, new Predicate[0]);
            map.put(item, NbchatTrainRpDialogueSeriviceImpl.getSum(values));
        }
        return map;
    }

    public static Integer getSum(List<Number> arr) {
        if (CollectionUtils.isEmpty(arr)) {
            return 0;
        }
        double sum = arr.stream().mapToDouble(Number::doubleValue).sum();
        return new Double(sum).intValue();
    }

    public Function<TrainRpDialogueRankRspBO, Integer> sortKey(String key) {
        if (key.equals("level_1")) {
            return TrainRpDialogueRankRspBO::getLevel_1;
        }
        if (key.equals("level_2")) {
            return TrainRpDialogueRankRspBO::getLevel_2;
        }
        if (key.equals("level_3")) {
            return TrainRpDialogueRankRspBO::getLevel_3;
        }
        if (key.equals("level_4")) {
            return TrainRpDialogueRankRspBO::getLevel_4;
        }
        if (key.equals("level_5")) {
            return TrainRpDialogueRankRspBO::getLevel_5;
        }
        if (key.equals("avgScore")) {
            return TrainRpDialogueRankRspBO::getAvgScore;
        }
        if (key.equals("userTotal")) {
            return TrainRpDialogueRankRspBO::getUserTotal;
        }
        log.info("\u4e0d\u652f\u6301\u7684\u6392\u5e8f\u5b57\u6bb5\uff1a{}", (Object)key);
        return null;
    }
}

