/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.report.service.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nbchat.admin.api.SysUpvoteRecordApi;
import com.tydic.nbchat.admin.api.bo.SysUpvoteRecordBO;
import com.tydic.nbchat.admin.api.rp.OpQueryApi;
import com.tydic.nbchat.admin.api.rp.OpQueryPptBO;
import com.tydic.nbchat.train.api.NbchatTrainRpPptService;
import com.tydic.nbchat.train.api.bo.ppt.NbchatPptQueryReqBO;
import com.tydic.nbchat.train.api.bo.ppt.NbchatPptQueryRspBO;
import com.tydic.nbchat.train.api.bo.video.NbchatVideoCountQueryRspBO;
import com.tydic.nbchat.train.mapper.PptCreationRecordMapper;
import com.tydic.nbchat.train.mapper.po.NbchatPptCondition;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class NbchatTrainRpPptServiceImpl
implements NbchatTrainRpPptService {
    private static final Logger log = LoggerFactory.getLogger(NbchatTrainRpPptServiceImpl.class);
    @Resource
    private RedisHelper redisHelper;
    @Resource
    private PptCreationRecordMapper pptCreationRecordMapper;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=3000)
    private OpQueryApi opQueryApi;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=3000)
    private SysUpvoteRecordApi sysUpvoteRecordApi;

    public Rsp getPPTCount(NbchatPptQueryReqBO reqBO) {
        log.info("\u67e5\u8be2PPT\u5236\u4f5c\u6570\u91cf:{}", (Object)reqBO.get_userId());
        NbchatVideoCountQueryRspBO rspBO = new NbchatVideoCountQueryRspBO();
        try {
            Map<String, Integer> statsMap = new HashMap<String, Integer>();
            if (this.redisHelper.hasKey("nbchat-train:ppt_count")) {
                log.debug("Redis\u4e2d\u6709\u7f13\u5b58\u6570\u636e\uff0c\u4ece\u7f13\u5b58\u83b7\u53d6PPT\u7edf\u8ba1\u6570\u636e");
                Object video = this.redisHelper.get("nbchat-train:ppt_count");
                statsMap = (Map)video;
            } else {
                log.debug("Redis\u4e2d\u65e0\u7f13\u5b58\u6570\u636e\uff0c\u4ece\u6570\u636e\u5e93\u83b7\u53d6PPT\u7edf\u8ba1\u6570\u636e");
                statsMap.put("lastWeek", this.pptCreationRecordMapper.getPptCount(6, null));
                statsMap.put("lastMonth", this.pptCreationRecordMapper.getPptCount(29, null));
                statsMap.put("enterpriseLastWeek", this.pptCreationRecordMapper.getPptCount(6, "1"));
                statsMap.put("enterpriseLastMonth", this.pptCreationRecordMapper.getPptCount(29, "1"));
                statsMap.put("personalLastWeek", this.pptCreationRecordMapper.getPptCount(6, "0"));
                statsMap.put("personalLastMonth", this.pptCreationRecordMapper.getPptCount(29, "0"));
                LocalDate now = LocalDate.now();
                LocalDateTime endOfDay = now.atTime(23, 59, 59);
                long seconds = Duration.between(LocalDateTime.now(), endOfDay).toSeconds();
                this.redisHelper.set("nbchat-train:ppt_count", statsMap, seconds);
            }
            int today = this.pptCreationRecordMapper.getPptCount(0, null);
            int enterpriseToday = this.pptCreationRecordMapper.getPptCount(0, "1");
            int personalToday = this.pptCreationRecordMapper.getPptCount(0, "0");
            rspBO.setToday(today);
            rspBO.setLastWeek(statsMap.getOrDefault("lastWeek", 0) + today);
            rspBO.setLastMonth(statsMap.getOrDefault("lastMonth", 0) + today);
            rspBO.setEnterpriseToday(enterpriseToday);
            rspBO.setEnterpriseLastWeek(statsMap.getOrDefault("enterpriseLastWeek", 0) + enterpriseToday);
            rspBO.setEnterpriseLastMonth(statsMap.getOrDefault("enterpriseLastMonth", 0) + enterpriseToday);
            rspBO.setPersonalToday(personalToday);
            rspBO.setPersonalLastWeek(statsMap.getOrDefault("personalLastWeek", 0) + personalToday);
            rspBO.setPersonalLastMonth(statsMap.getOrDefault("personalLastMonth", 0) + personalToday);
            log.debug("PPT\u7edf\u8ba1\u6570\u636e\u67e5\u8be2\u5b8c\u6210: {}", (Object)rspBO);
            return BaseRspUtils.createSuccessRsp((Object)rspBO);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6PPT\u7edf\u8ba1\u6570\u636e\u5f02\u5e38", (Throwable)e);
            return BaseRspUtils.createSuccessRsp((Object)new NbchatVideoCountQueryRspBO());
        }
    }

    public RspList<NbchatPptQueryRspBO> getPPTList(NbchatPptQueryReqBO reqBO) {
        List pptList;
        log.info("\u67e5\u8be2PPT\u5236\u4f5c\u5217\u8868:{}", (Object)reqBO);
        ArrayList rspBOList = new ArrayList();
        NbchatPptCondition condition = new NbchatPptCondition();
        BeanUtils.copyProperties((Object)reqBO, (Object)condition);
        Page page = null;
        if (Boolean.TRUE.equals(reqBO.getIsPaged())) {
            page = PageHelper.startPage((int)reqBO.getPage(), (int)reqBO.getLimit());
        }
        if (CollectionUtils.isEmpty((Collection)(pptList = this.pptCreationRecordMapper.getPptList(condition)))) {
            return BaseRspUtils.createSuccessRspList(rspBOList, (long)0L);
        }
        NiccCommonUtil.copyList((List)pptList, rspBOList, NbchatPptQueryRspBO.class);
        rspBOList.forEach(o -> {
            Rsp rsp = this.opQueryApi.opQueryPpt(o.getPptId());
            if (rsp.isSuccess()) {
                o.setShareNum(((OpQueryPptBO)rsp.getData()).getShareNum());
                o.setDownNum(((OpQueryPptBO)rsp.getData()).getDownNum());
                o.setReadNum(((OpQueryPptBO)rsp.getData()).getReadNum());
                o.setViewNum(((OpQueryPptBO)rsp.getData()).getViewNum());
            }
            this.fetchPptRatingInfo((NbchatPptQueryRspBO)o);
        });
        return BaseRspUtils.createSuccessRspList(rspBOList, (long)(page != null ? page.getTotal() : (long)pptList.size()));
    }

    private void fetchPptRatingInfo(NbchatPptQueryRspBO bo) {
        try {
            SysUpvoteRecordBO recordBO = new SysUpvoteRecordBO();
            recordBO.setBusiId(bo.getPptId());
            recordBO.setProductModule("2");
            RspList ratingRsp = this.sysUpvoteRecordApi.getUpvoteRecordByBusiId(recordBO);
            if (ratingRsp.isSuccess() && !CollectionUtils.isEmpty((Collection)ratingRsp.getRows())) {
                SysUpvoteRecordBO ratingInfo = (SysUpvoteRecordBO)ratingRsp.getRows().get(0);
                bo.setRating(ratingInfo.getRating().toString());
                bo.setUnlikeInput(ratingInfo.getUnlikeInput());
                bo.setUnlikeReason(ratingInfo.getUnlikeReason());
                bo.setContent(ratingInfo.getContent());
            }
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6PPT\u8bc4\u5206\u4fe1\u606f\u5931\u8d25, pptId: {}", (Object)bo.getPptId(), (Object)e);
        }
    }
}

