/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.report.service.impl;

import com.tydic.nbchat.train.api.bo.report.course.TrainRpCoursePnSaveReqBO;
import com.tydic.nbchat.train.api.bo.report.course.TrainRpCoursePtSaveReqBO;
import com.tydic.nbchat.train.api.rp_course.NbcahtTrainRpCourseSaveApi;
import com.tydic.nbchat.train.mapper.NbchatTrainRecordMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainRpStudyPnMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainRpStudyPtMapper;
import com.tydic.nbchat.train.mapper.po.NbchatTrainRecord;
import com.tydic.nbchat.train.mapper.po.NbchatTrainRpStudyPn;
import com.tydic.nbchat.train.mapper.po.NbchatTrainRpStudyPt;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NbchatTrainRpStudyImpl
implements NbcahtTrainRpCourseSaveApi {
    private static final Logger log = LoggerFactory.getLogger(NbchatTrainRpStudyImpl.class);
    @Resource
    NbchatTrainRpStudyPtMapper nbchatTrainRpStudyPtMapper;
    @Resource
    NbchatTrainRpStudyPnMapper nbchatTrainRpStudyPnMapper;
    @Resource
    NbchatTrainRecordMapper nbchatTrainRecordMapper;
    private static final String HISTORY_DATA = "1";

    public Rsp saveRpCoursePnRecord(TrainRpCoursePnSaveReqBO reqBO) {
        log.info("\u4fdd\u5b58\u5b66\u4e60\u4eba\u6570\u8bb0\u5f55\uff1a{}", (Object)reqBO);
        NbchatTrainRpStudyPn query = new NbchatTrainRpStudyPn();
        BeanUtils.copyProperties((Object)reqBO, (Object)query);
        List nbchatTrainRpStudyPns = this.nbchatTrainRpStudyPnMapper.selectAll(query);
        if (CollectionUtils.isEmpty((Collection)nbchatTrainRpStudyPns)) {
            NbchatTrainRpStudyPn record = new NbchatTrainRpStudyPn();
            BeanUtils.copyProperties((Object)reqBO, (Object)record);
            record.setDateTime(new Date());
            if (this.isStudied(reqBO.getCourseId(), reqBO.getUserId())) {
                record.setIsFinish(EntityValidType.NORMAL.getCode());
            }
            try {
                this.nbchatTrainRpStudyPnMapper.insertSelective(record);
            }
            catch (Exception e) {
                log.error("\u4fdd\u5b58\u5b66\u4e60\u4eba\u6570\u8bb0\u5f55\u5931\u8d25", (Throwable)e);
            }
        } else if (this.isStudied(reqBO.getCourseId(), reqBO.getUserId())) {
            NbchatTrainRpStudyPn record = (NbchatTrainRpStudyPn)nbchatTrainRpStudyPns.get(0);
            record.setIsFinish(EntityValidType.NORMAL.getCode());
            this.nbchatTrainRpStudyPnMapper.update(record);
        }
        return BaseRspUtils.createSuccessRsp(null);
    }

    public boolean isStudied(String courseId, String userId) {
        NbchatTrainRecord nbchatTrainRecord = this.nbchatTrainRecordMapper.selectByUserAndCourseId(userId, courseId);
        if (ObjectUtils.isEmpty((Object)nbchatTrainRecord)) {
            return false;
        }
        return EntityValidType.NORMAL.getCode().equals(nbchatTrainRecord.getTrainState());
    }

    @Transactional(rollbackFor={Exception.class})
    public Rsp saveRpCoursePtRecord(TrainRpCoursePtSaveReqBO ptSaveReqBO) {
        log.info("\u4fdd\u5b58\u5b66\u4e60\u4eba\u6b21\u8bb0\u5f55\uff1a{}", (Object)ptSaveReqBO);
        Long id = IdWorker.nextAutoId();
        String userId = ptSaveReqBO.getUserId();
        String courseId = ptSaveReqBO.getCourseId();
        String tenantCode = ptSaveReqBO.getTenantCode();
        String historyData = ptSaveReqBO.getHistoryData();
        Date dateDay = new Date();
        if (StringUtils.isNotBlank((CharSequence)historyData) && historyData.equals(HISTORY_DATA)) {
            dateDay = ptSaveReqBO.getDateDay();
        }
        NbchatTrainRpStudyPt nbchatTrainRpStudyPt = new NbchatTrainRpStudyPt();
        nbchatTrainRpStudyPt.setId(id);
        nbchatTrainRpStudyPt.setUserId(userId);
        nbchatTrainRpStudyPt.setCourseId(courseId);
        nbchatTrainRpStudyPt.setTenantCode(tenantCode);
        nbchatTrainRpStudyPt.setDateDay(dateDay);
        nbchatTrainRpStudyPt.setDateTime(new Date());
        this.nbchatTrainRpStudyPtMapper.insert(nbchatTrainRpStudyPt);
        return BaseRspUtils.createSuccessRsp((Object)"", (String)"\u4fdd\u5b58\u6210\u529f");
    }
}

