/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.report.service.impl.excel;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.tydic.nbchat.admin.api.bo.file.FileUploadRequest;
import com.tydic.nbchat.admin.api.fileMannager.FileManageService;
import com.tydic.nbchat.train.api.NbchatTrainStudentsArchiveReportApi;
import com.tydic.nbchat.train.api.bo.course.NbchatTrainStudentTrainingBO;
import com.tydic.nbchat.train.api.bo.course.TranStudentArchiveQueryReqBO;
import com.tydic.nbchat.train.api.bo.course.TranStudentArchiveRspBO;
import com.tydic.nbchat.train.report.service.impl.excel.CustomCellStyleStrategy;
import com.tydic.nbchat.train.report.service.impl.excel.TaskMergeStrategy;
import com.tydic.nbchat.train.report.service.impl.excel.entity.TaskCourseExcelEntity;
import com.tydic.nicc.common.bo.file.FileManageSaveBO;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

@Component
public class ArchiveExportService {
    private static final Logger log = LoggerFactory.getLogger(ArchiveExportService.class);
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=5000)
    private FileManageService fileManageService;
    @Resource
    private NbchatTrainStudentsArchiveReportApi nbchatTrainStudentsArchiveReportApi;

    public Rsp export(TranStudentArchiveQueryReqBO request) throws Exception {
        Rsp rsp = this.nbchatTrainStudentsArchiveReportApi.getStudentArchive(request);
        if (!rsp.isSuccess()) {
            return rsp;
        }
        TranStudentArchiveRspBO data = (TranStudentArchiveRspBO)rsp.getData();
        String filePath = this.export(data);
        log.info("\u6863\u6848\u672c\u5730\u8def\u5f84\uff1a{}", (Object)filePath);
        RspList rspList = this.upload(filePath);
        log.info("\u4e0a\u4f20\u7ed3\u679c\uff1a{}", (Object)rspList);
        if (rspList.isSuccess()) {
            FileManageSaveBO res = (FileManageSaveBO)rspList.getRows().get(0);
            return BaseRspUtils.createSuccessRsp((Object)res.getAccessUrl());
        }
        return BaseRspUtils.createErrorRsp((String)"\u5bfc\u51fa\u5931\u8d25");
    }

    public RspList upload(String filePath) throws Exception {
        log.info("\u4e0a\u4f20\u6863\u6848\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)filePath);
        String fileName = filePath.substring(filePath.lastIndexOf("/") + 1);
        byte[] byteArray = IOUtils.toByteArray((InputStream)new FileInputStream(filePath));
        FileUploadRequest uploadRequest = FileUploadRequest.builder().file(byteArray).fileName(fileName).uploadUser("2").tenantCode("00000000").build();
        return this.fileManageService.fileUploadRequest(uploadRequest);
    }

    public String export(TranStudentArchiveRspBO data) throws Exception {
        int mergeIndex = 5;
        String filePath = "/tmp/" + System.currentTimeMillis() + ".xlsx";
        ClassPathResource resource = new ClassPathResource("template/archive_tmpl.xlsx");
        InputStream inputStream = resource.getInputStream();
        try (ExcelWriter excelWriter = EasyExcel.write((String)filePath).withTemplate(inputStream).build();){
            WriteSheet writeSheet = ((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)EasyExcel.writerSheet((String)"Sheet1").registerWriteHandler((WriteHandler)new TaskMergeStrategy())).registerWriteHandler((WriteHandler)new CustomCellStyleStrategy())).relativeHeadRowIndex(Integer.valueOf(4))).build();
            Map<String, String> fillMap = this.fillData(data);
            excelWriter.fill(fillMap, writeSheet);
            List taskList = data.getTrainingList();
            for (NbchatTrainStudentTrainingBO task : taskList) {
                int size = task.getCourseList().size();
                List<TaskCourseExcelEntity> rows = this.getRow(task);
                excelWriter.write(rows, writeSheet);
                if (size > 1) {
                    CellRangeAddress cellRangeAddress = new CellRangeAddress(mergeIndex, size + mergeIndex - 1, 0, 0);
                    excelWriter.writeContext().writeSheetHolder().getSheet().addMergedRegionUnsafe(cellRangeAddress);
                }
                mergeIndex += task.getCourseList().size();
            }
        }
        return filePath;
    }

    public List<TaskCourseExcelEntity> getRow(NbchatTrainStudentTrainingBO task) {
        List list = task.getCourseList();
        ArrayList<TaskCourseExcelEntity> rows = new ArrayList<TaskCourseExcelEntity>();
        NiccCommonUtil.copyList((List)list, rows, TaskCourseExcelEntity.class);
        ((TaskCourseExcelEntity)rows.get(0)).setTaskName(task.getTaskName());
        return rows;
    }

    public Map<String, String> fillData(TranStudentArchiveRspBO data) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("projectName", data.getProjectName());
        map.put("name", data.getUserRealityName());
        map.put("idCard", data.getIdCard());
        map.put("phone", data.getPhone());
        map.put("entryTime", data.getEntryTime());
        return map;
    }
}

