/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.report.timer;

import com.alibaba.fastjson.JSON;
import com.tydic.nbchat.train.mapper.RpSearchLogMapper;
import com.tydic.nbchat.train.mapper.po.RpSearchLog;
import com.tydic.nbchat.train.report.bo.SearchManuallyTimerBO;
import com.tydic.nbchat.train.report.promotion.AppService;
import com.tydic.nbchat.train.report.promotion.bo.AppServiceEnum;
import com.tydic.nbchat.train.report.promotion.bo.PromotionTypeEnum;
import com.tydic.nbchat.train.report.service.impl.RpSearchLogService;
import com.tydic.nicc.dc.boot.starter.entity.RedisLockEntity;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class TrainPromotionRpSearchLogDayTimer {
    private static final Logger log = LoggerFactory.getLogger(TrainPromotionRpSearchLogDayTimer.class);
    private static final int retryNum = 5;
    private static final String NBCHAT_TRAIN_SEARCH_SAVE_LOCK = "NBCHAT_TRAIN_SEARCH_SAVE_LOCK";
    private static final String NBCHAT_TRAIN_SEARCH_SAVE_FOR_FAILED_DATA_RETRY_LOCK = "NBCHAT_TRAIN_SEARCH_SAVE_FOR_FAILED_DATA_RETRY_LOCK";
    @Value(value="${nbchat-train.config.rp.search.timer-enable:true}")
    private boolean timeEnable;
    @Resource
    private RedisHelper redisHelper;
    @Resource
    private List<AppService> appServices;
    @Resource
    private RpSearchLogMapper rpSearchLogMapper;
    @Resource
    private RpSearchLogService rpSearchLogService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="0 40 8 * * ?")
    public void run() {
        if (!this.timeEnable) {
            return;
        }
        RedisLockEntity redisLockEntity = RedisLockEntity.builder().lockKey(NBCHAT_TRAIN_SEARCH_SAVE_LOCK).requestId(IdWorker.nextAutoIdStr()).build();
        boolean locked = this.redisHelper.lock(redisLockEntity);
        if (locked) {
            try {
                List futures = this.appServices.stream().map(appService -> appService.getPromotionType().stream().map(promotionType -> this.rpSearchLogService.findRpSearchLog((AppService)appService, (PromotionTypeEnum)((Object)((Object)promotionType))))).reduce(Stream.empty(), Stream::concat).toList();
                ArrayList<RpSearchLog> rpSearchLogs = new ArrayList<RpSearchLog>();
                for (Future future : futures) {
                    rpSearchLogs.addAll((Collection)future.get());
                }
                if (CollectionUtils.isNotEmpty(rpSearchLogs)) {
                    this.saveRpSearchLog(rpSearchLogs);
                }
            }
            catch (Exception e) {
                log.error("\u8c03\u7528API\u83b7\u53d6\u63a8\u5e7f\u62a5\u8868\u6570\u636e,\u6267\u884c\u5f02\u5e38:", (Throwable)e);
            }
            finally {
                this.redisHelper.unlockLua(redisLockEntity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="0 0/10 9-10 * * ?")
    public void runForFailedDataRetry() {
        if (!this.timeEnable) {
            return;
        }
        RedisLockEntity redisLockEntity = RedisLockEntity.builder().lockKey(NBCHAT_TRAIN_SEARCH_SAVE_FOR_FAILED_DATA_RETRY_LOCK).requestId(IdWorker.nextAutoIdStr()).build();
        boolean locked = this.redisHelper.lock(redisLockEntity);
        if (locked) {
            try {
                List statistics = this.rpSearchLogMapper.selectStatisticsByDaily();
                log.info("\u63a8\u5e7f\u62a5\u8868\u6570\u636e\u83b7\u53d6\u5931\u8d25\u91cd\u8bd5\u5b9a\u65f6\u4efb\u52a1-\u5f00\u59cb:{}", (Object)JSON.toJSONString((Object)statistics));
                if (CollectionUtils.isEmpty((Collection)statistics)) {
                    return;
                }
                statistics.forEach(o -> {
                    SearchManuallyTimerBO param;
                    if (o.getPcBaidu() == null) {
                        param = new SearchManuallyTimerBO();
                        param.setAppServiceEnum(AppServiceEnum.BAIDU);
                        param.setDayData(o.getDayData());
                        this.manuallyTimer(param);
                    }
                    if (o.getPc360() == null) {
                        param = new SearchManuallyTimerBO();
                        param.setAppServiceEnum(AppServiceEnum.E360);
                        param.setDayData(o.getDayData());
                        this.manuallyTimer(param);
                    }
                    if (o.getPcBing() == null) {
                        param = new SearchManuallyTimerBO();
                        param.setAppServiceEnum(AppServiceEnum.BING);
                        param.setDayData(o.getDayData());
                        this.manuallyTimer(param);
                    }
                });
            }
            catch (Exception e) {
                log.error("\u63a8\u5e7f\u62a5\u8868\u6570\u636e\u83b7\u53d6\u5931\u8d25\u91cd\u8bd5\u5b9a\u65f6\u4efb\u52a1,\u6267\u884c\u5f02\u5e38:", (Throwable)e);
            }
            finally {
                this.redisHelper.unlockLua(redisLockEntity);
            }
        }
    }

    @Async(value="searchLogTaskExecutor")
    public void manuallyTimer(SearchManuallyTimerBO param) {
        AppServiceEnum appServiceEnum = StringUtils.isNotBlank((CharSequence)param.getAppServiceType()) ? AppServiceEnum.getEnumByCode(param.getAppServiceType()) : param.getAppServiceEnum();
        PromotionTypeEnum promotionTypeEnum = StringUtils.isNotBlank((CharSequence)param.getPromotionType()) ? PromotionTypeEnum.getEnumByType(param.getPromotionType()) : param.getPromotionTypeEnum();
        List futures = this.appServices.stream().filter(o -> appServiceEnum == null || o.getAppType().equals(appServiceEnum.getCode())).map(appService -> {
            List<PromotionTypeEnum> promotionTypes = appService.getPromotionType();
            if (promotionTypeEnum != null && promotionTypes.contains((Object)promotionTypeEnum)) {
                promotionTypes = List.of(promotionTypeEnum);
            }
            if (param.getDayData() != null) {
                return promotionTypes.stream().map(promotionType -> this.rpSearchLogService.findRpSearchLog((AppService)appService, param.getDayData(), (PromotionTypeEnum)((Object)((Object)promotionType))));
            }
            if (param.getStartDate() != null && param.getEndDate() != null) {
                return promotionTypes.stream().map(promotionType -> this.rpSearchLogService.findRpSearchLog((AppService)appService, param.getStartDate(), param.getEndDate(), (PromotionTypeEnum)((Object)((Object)promotionType))));
            }
            return promotionTypes.stream().map(promotionType -> this.rpSearchLogService.findRpSearchLog((AppService)appService, (PromotionTypeEnum)((Object)((Object)promotionType))));
        }).reduce(Stream.empty(), Stream::concat).toList();
        ArrayList<RpSearchLog> rpSearchLogs = new ArrayList<RpSearchLog>();
        try {
            for (Future future : futures) {
                rpSearchLogs.addAll((Collection)future.get());
            }
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("\u624b\u52a8\u5237\u65b0\uff0c\u5f02\u6b65\u83b7\u53d6\u4e09\u65b9\u63a8\u5e7f\u6570\u636e\u5931\u8d25", (Throwable)e);
            return;
        }
        if (CollectionUtils.isNotEmpty(rpSearchLogs)) {
            this.saveRpSearchLog(rpSearchLogs);
        }
    }

    private void saveRpSearchLog(List<RpSearchLog> rpSearchLogs) {
        if (!this.searchIdentifyClassifyByTerm(rpSearchLogs)) {
            return;
        }
        ArrayList deleteQueryList = new ArrayList();
        rpSearchLogs.stream().collect(Collectors.groupingBy(RpSearchLog::getDayData)).forEach((dayData, rpSearchLogList) -> {
            rpSearchLogs.stream().collect(Collectors.groupingBy(RpSearchLog::getKeyword)).forEach((keyword, searchLogs) -> {
                String identifyClassify = searchLogs.stream().filter(rpSearchLog -> !List.of("\u5176\u4ed6", "\u5176\u5b83").contains(rpSearchLog.getIdentifyClassify())).collect(Collectors.groupingBy(RpSearchLog::getIdentifyClassify, Collectors.counting())).entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse("\u5176\u5b83");
                searchLogs.forEach(rpSearchLog -> rpSearchLog.setIdentifyClassify(identifyClassify));
            });
            rpSearchLogList.stream().map(RpSearchLog::getSources).distinct().forEach(sources -> {
                RpSearchLog rpSearchLog = new RpSearchLog();
                rpSearchLog.setSources(sources);
                rpSearchLog.setDayData(dayData);
                deleteQueryList.add(rpSearchLog);
            });
        });
        this.rpSearchLogMapper.batchDelete(deleteQueryList);
        this.rpSearchLogMapper.batchInsert(rpSearchLogs);
    }

    private boolean searchIdentifyClassifyByTerm(List<RpSearchLog> rpSearchLogs) {
        Map<String, List<RpSearchLog>> termMap = rpSearchLogs.stream().collect(Collectors.groupingBy(rpSearchLog -> rpSearchLog.getTerm().replaceAll(" ", "")));
        return this.doSearchIdentifyClassify(termMap, 0);
    }

    private boolean doSearchIdentifyClassify(Map<String, List<RpSearchLog>> termMap, int retry) {
        if (retry++ > 5) {
            log.warn("\u91cd\u8bd5\u4e86{}\u6b21\u8fd8\u5b58\u5728\u672a\u83b7\u53d6\u5230\u8bc6\u522b\u5206\u7c7b\u7684\u641c\u7d22\u8bcd", (Object)5);
            return false;
        }
        log.info("\u5b58\u5728\u672a\u83b7\u53d6\u5230\u8bc6\u522b\u5206\u7c7b\u7684\u641c\u7d22\u8bcd");
        List<Future> futures = TrainPromotionRpSearchLogDayTimer.partitionCollection(termMap.keySet()).map(this.rpSearchLogService::searchIdentifyClassify).toList();
        for (Future future : futures) {
            Map identifyClassifyMap;
            try {
                identifyClassifyMap = (Map)future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                log.error("\u5f02\u6b65\u83b7\u53d6\u8bc6\u522b\u5206\u7c7b\u5931\u8d25", (Throwable)e);
                return this.doSearchIdentifyClassify(termMap, retry);
            }
            if (!MapUtils.isNotEmpty((Map)identifyClassifyMap)) continue;
            identifyClassifyMap.forEach((identifyClassify, terms) -> terms.stream().map(term -> term.replaceAll(" ", "")).filter(termMap::containsKey).forEach(term -> ((List)termMap.remove(term)).forEach(rpSearchLog -> rpSearchLog.setIdentifyClassify(identifyClassify))));
        }
        return MapUtils.isEmpty(termMap) || this.doSearchIdentifyClassify(termMap, retry);
    }

    private static <T> Stream<List<T>> partitionCollection(Collection<T> collections) {
        ArrayList partitions = new ArrayList();
        ArrayList<T> partition = new ArrayList<T>();
        for (T item : collections) {
            partition.add(item);
            if (partition.size() != 100) continue;
            partitions.add(partition);
            partition = new ArrayList();
        }
        if (!partition.isEmpty()) {
            partitions.add(partition);
        }
        return partitions.stream();
    }
}

