/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.report.timer;

import com.tydic.nbchat.train.api.bo.report.CountRpDayItemRequest;
import com.tydic.nbchat.train.api.rp_course.NbcahtTrainRpDayItemApi;
import com.tydic.nbchat.train.report.config.NbchatTrainRpConfigProperties;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.entity.RedisLockEntity;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(value={"nbchat-train.config.rp-config.timer-enable"}, havingValue="true")
@EnableScheduling
@Component
public class TrainRpDayCountTimer {
    private static final Logger log = LoggerFactory.getLogger(TrainRpDayCountTimer.class);
    private static final String NBCHAT_TRAIN_RP_TIMER_LOCK_KEY = "NBCHAT_TRAIN_RP_TIMER_LOCK";
    private final RedisHelper redisHelper;
    private final NbchatTrainRpConfigProperties nbchatTrainRpConfigProperties;
    private final NbcahtTrainRpDayItemApi nbcahtTrainRpDayItemApi;

    public TrainRpDayCountTimer(RedisHelper redisHelper, NbchatTrainRpConfigProperties nbchatTrainRpConfigProperties, NbcahtTrainRpDayItemApi nbcahtTrainRpDayItemApi) {
        this.redisHelper = redisHelper;
        this.nbchatTrainRpConfigProperties = nbchatTrainRpConfigProperties;
        this.nbcahtTrainRpDayItemApi = nbcahtTrainRpDayItemApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="${nbchat-train.config.rp-config.timer-cron:0 0 2 * * ?}")
    public void doCheckSessionTimout() {
        RedisLockEntity redisLockEntity = RedisLockEntity.builder().lockKey(NBCHAT_TRAIN_RP_TIMER_LOCK_KEY).requestId(IdWorker.nextAutoIdStr()).build();
        boolean locked = this.redisHelper.lock(redisLockEntity);
        if (locked) {
            try {
                log.info("\u62a5\u8868\u7edf\u8ba1\u4efb\u52a1,\u5f00\u59cb\u6267\u884c:{}", (Object)redisLockEntity);
                Date start = DateTimeUtil.createTime((Date)DateTimeUtil.DateAddDayOfYear((int)-1), (int)0, (int)0, (int)0);
                Date end = DateTimeUtil.getStartTimeOfDay();
                long startTime = System.currentTimeMillis();
                for (String itemCode : this.nbchatTrainRpConfigProperties.getItemCodes()) {
                    CountRpDayItemRequest request = CountRpDayItemRequest.builder().itemCode(itemCode).startTime(start).endTime(end).build();
                    Rsp rsp = this.nbcahtTrainRpDayItemApi.countRpDayItem(request);
                    log.info("\u62a5\u8868\u7edf\u8ba1\u4efb\u52a1,\u6307\u6807\u7edf\u8ba1:{}|{}", (Object)request, (Object)rsp);
                }
                long endTime = System.currentTimeMillis();
                log.info("\u62a5\u8868\u7edf\u8ba1\u4efb\u52a1,\u6267\u884c\u5b8c\u6210:{} ms", (Object)(endTime - startTime));
            }
            catch (Exception e) {
                log.error("\u62a5\u8868\u7edf\u8ba1\u4efb\u52a1,\u6267\u884c\u5f02\u5e38:", (Throwable)e);
            }
            finally {
                this.redisHelper.unlockLua(redisLockEntity);
            }
        }
    }
}

