/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.report.web;

import com.tydic.nbchat.train.mapper.po.RpSearchLog;
import com.tydic.nbchat.train.report.promotion.AppService;
import com.tydic.nbchat.train.report.promotion.baidu.BaiduAppService;
import com.tydic.nbchat.train.report.promotion.bing.BingAppService;
import com.tydic.nbchat.train.report.promotion.bing.BingReportUtils;
import com.tydic.nbchat.train.report.promotion.bo.AppServiceEnum;
import com.tydic.nbchat.train.report.promotion.bo.PromotionTypeEnum;
import com.tydic.nbchat.train.report.promotion.e360.E360AppService;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/train/promotion"})
public class PromotionOAuthController {
    private static final Logger log = LoggerFactory.getLogger(PromotionOAuthController.class);
    @Resource
    private BingAppService bingAppService;
    @Resource
    private BaiduAppService baiduAppService;
    @Resource
    private E360AppService e360AppService;
    private final Map<String, AppService> appServiceMap = new HashMap<String, AppService>();

    @PostConstruct
    public void init() {
        this.appServiceMap.put(AppServiceEnum.BING.getCode(), this.bingAppService);
        this.appServiceMap.put(AppServiceEnum.BAIDU.getCode(), this.baiduAppService);
        this.appServiceMap.put(AppServiceEnum.E360.getCode(), this.e360AppService);
    }

    @GetMapping(value={"/searchLog"})
    public RspList<RpSearchLog> findRpSearchLog(@RequestParam String appType, @RequestParam @DateTimeFormat(pattern="yyyy-MM-dd") Date startDate, @RequestParam @DateTimeFormat(pattern="yyyy-MM-dd") Date endDate, @RequestParam(required=false) String promotionType, @RequestParam(defaultValue="1") int page) {
        log.info("\u67e5\u627e\u641c\u7d22\u65e5\u5fd7\u8bb0\u5f55\uff1aappType={}, startDate={}, endDate={}, promotionType={}, page={}", new Object[]{appType, startDate, endDate, promotionType, page});
        if (StringUtils.isBlank((CharSequence)appType)) {
            return BaseRspUtils.createErrorRspList((String)"\u63a8\u5e7f\u5e73\u53f0\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (startDate == null || endDate == null) {
            return BaseRspUtils.createErrorRspList((String)"\u5f00\u59cb\u65e5\u671f\u548c\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (startDate.after(endDate)) {
            return BaseRspUtils.createErrorRspList((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u7ed3\u675f\u65e5\u671f");
        }
        AppService appService = this.appServiceMap.get(appType.toLowerCase());
        if (appService == null) {
            return BaseRspUtils.createErrorRspList((String)("\u4e0d\u652f\u6301\u7684\u63a8\u5e7f\u5e73\u53f0\u7c7b\u578b: " + appType));
        }
        PromotionTypeEnum promotionTypeEnum = this.parsePromotionType(promotionType);
        try {
            return appService.findRpSearchLog(startDate, endDate, promotionTypeEnum, page);
        }
        catch (Exception e) {
            log.error("\u67e5\u627e\u641c\u7d22\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25", (Throwable)e);
            return BaseRspUtils.createErrorRspList((String)("\u67e5\u627e\u641c\u7d22\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25: " + e.getMessage()));
        }
    }

    private PromotionTypeEnum parsePromotionType(String promotionType) {
        if (StringUtils.isBlank((CharSequence)promotionType)) {
            return PromotionTypeEnum.ALL_PROMOTION_TYPE;
        }
        switch (promotionType.toLowerCase()) {
            case "computer": 
            case "pc": {
                return PromotionTypeEnum.COMPUTER;
            }
            case "mobile": 
            case "smartphone": {
                return PromotionTypeEnum.MOBILE;
            }
        }
        return PromotionTypeEnum.ALL_PROMOTION_TYPE;
    }

    @GetMapping(value={"/bing/authUrl"})
    public Rsp<String> generateBingAuthUrl(@RequestParam String customerId) {
        log.info("\u751f\u6210Bing OAuth\u6388\u6743URL\uff0ccustomerId: {}", (Object)customerId);
        if (StringUtils.isBlank((CharSequence)customerId)) {
            return BaseRspUtils.createErrorRsp((String)"customerId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            String authUrl = this.bingAppService.generateAuthUrl(customerId);
            if (StringUtils.isBlank((CharSequence)authUrl)) {
                return BaseRspUtils.createErrorRsp((String)"\u751f\u6210\u6388\u6743URL\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5customerId\u914d\u7f6e");
            }
            return BaseRspUtils.createSuccessRsp((Object)authUrl);
        }
        catch (Exception e) {
            log.error("\u751f\u6210Bing OAuth\u6388\u6743URL\u5f02\u5e38", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)("\u751f\u6210\u6388\u6743URL\u5f02\u5e38: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/bing/status"})
    public Rsp<String> checkBingAuthStatus(@RequestParam String customerId) {
        log.info("\u68c0\u67e5Bing OAuth\u6388\u6743\u72b6\u6001\uff0ccustomerId: {}", (Object)customerId);
        if (StringUtils.isBlank((CharSequence)customerId)) {
            return BaseRspUtils.createErrorRsp((String)"customerId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            String accessToken = this.bingAppService.getAccessToken(customerId);
            if (StringUtils.isNotBlank((CharSequence)accessToken)) {
                return BaseRspUtils.createSuccessRsp((Object)"\u5df2\u6388\u6743");
            }
            return BaseRspUtils.createSuccessRsp((Object)"\u672a\u6388\u6743");
        }
        catch (Exception e) {
            log.error("\u68c0\u67e5Bing OAuth\u6388\u6743\u72b6\u6001\u5f02\u5e38", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)("\u68c0\u67e5\u6388\u6743\u72b6\u6001\u5f02\u5e38: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/bing/refresh"})
    public Rsp<String> refreshBingToken(@RequestParam String customerId) {
        log.info("\u624b\u52a8\u5237\u65b0Bing\u8bbf\u95ee\u4ee4\u724c\uff0ccustomerId: {}", (Object)customerId);
        if (StringUtils.isBlank((CharSequence)customerId)) {
            return BaseRspUtils.createErrorRsp((String)"customerId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            this.bingAppService.doRefreshToken(customerId);
            String accessToken = this.bingAppService.getAccessToken(customerId);
            if (StringUtils.isNotBlank((CharSequence)accessToken)) {
                return BaseRspUtils.createSuccessRsp((Object)"\u4ee4\u724c\u5237\u65b0\u6210\u529f");
            }
            return BaseRspUtils.createErrorRsp((String)"\u4ee4\u724c\u5237\u65b0\u5931\u8d25");
        }
        catch (Exception e) {
            log.error("\u624b\u52a8\u5237\u65b0Bing\u8bbf\u95ee\u4ee4\u724c\u5f02\u5e38", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)("\u5237\u65b0\u4ee4\u724c\u5f02\u5e38: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/bing/test"})
    public Rsp<Map<String, Object>> testBingConnection(@RequestParam String customerId) {
        log.info("\u6d4b\u8bd5Bing API\u8fde\u63a5\u6027\uff0ccustomerId: {}", (Object)customerId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)customerId)) {
            return BaseRspUtils.createErrorRsp((String)"customerId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            result.put("configCheck", "\u5f00\u59cb\u68c0\u67e5\u914d\u7f6e...");
            String accessToken = this.bingAppService.getAccessToken(customerId);
            if (!StringUtils.isNotBlank((CharSequence)accessToken)) {
                result.put("tokenCheck", "\u8bbf\u95ee\u4ee4\u724c\u83b7\u53d6\u5931\u8d25");
                return BaseRspUtils.createSuccessRsp(result);
            }
            result.put("tokenCheck", "\u8bbf\u95ee\u4ee4\u724c\u83b7\u53d6\u6210\u529f\uff0c\u957f\u5ea6: " + accessToken.length());
            Date yesterday = DateTimeUtil.DateAdd((Date)new Date(), (int)-1, (int)1);
            RspList<RpSearchLog> searchResult = this.bingAppService.findRpSearchLog(yesterday, yesterday, PromotionTypeEnum.ALL_PROMOTION_TYPE, 1);
            if (searchResult.isSuccess()) {
                result.put("apiTest", "API\u8c03\u7528\u6210\u529f\uff0c\u8fd4\u56de\u6570\u636e\u6761\u6570: " + searchResult.getCount());
            } else {
                result.put("apiTest", "API\u8c03\u7528\u5931\u8d25: " + searchResult.getRspDesc());
            }
            return BaseRspUtils.createSuccessRsp(result);
        }
        catch (Exception e) {
            log.error("\u6d4b\u8bd5Bing API\u8fde\u63a5\u6027\u5f02\u5e38", (Throwable)e);
            result.put("error", "\u6d4b\u8bd5\u5f02\u5e38: " + e.getMessage());
            return BaseRspUtils.createSuccessRsp(result);
        }
    }

    @GetMapping(value={"/bing/test-rest-submit"})
    public Rsp<String> testBingRestSubmit(@RequestParam String customerId, @RequestParam String startDate, @RequestParam String endDate, @RequestParam(required=false) String deviceFilter) {
        log.info("\u6d4b\u8bd5Bing \u63d0\u4ea4\u62a5\u544a\u8bf7\u6c42\uff0ccustomerId: {}, startDate: {}, endDate: {}, deviceFilter: {}", new Object[]{customerId, startDate, endDate, deviceFilter});
        if (StringUtils.isBlank((CharSequence)customerId)) {
            return BaseRspUtils.createErrorRsp((String)"customerId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date start = sdf.parse(startDate);
            Date end = sdf.parse(endDate);
            String reportRequestId = this.bingAppService.testSubmitReportRequestWithRestApi(customerId, start, end, deviceFilter);
            if (StringUtils.isNotBlank((CharSequence)reportRequestId)) {
                return BaseRspUtils.createSuccessRsp((Object)reportRequestId);
            }
            return BaseRspUtils.createErrorRsp((String)"\u63d0\u4ea4\u62a5\u544a\u8bf7\u6c42\u5931\u8d25");
        }
        catch (Exception e) {
            log.error("\u6d4b\u8bd5Bing REST API\u63d0\u4ea4\u62a5\u544a\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)("\u6d4b\u8bd5\u5f02\u5e38: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/bing/test-rest-poll"})
    public Rsp<Map<String, Object>> testBingRestPoll(@RequestParam String customerId, @RequestParam String reportRequestId) {
        log.info("\u6d4b\u8bd5Bing \u8f6e\u8be2\u62a5\u544a\u72b6\u6001\uff0ccustomerId: {}, reportRequestId: {}", (Object)customerId, (Object)reportRequestId);
        if (StringUtils.isBlank((CharSequence)customerId) || StringUtils.isBlank((CharSequence)reportRequestId)) {
            return BaseRspUtils.createErrorRsp((String)"customerId\u548creportRequestId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            BingReportUtils.ReportStatus status = this.bingAppService.testPollReportStatusWithRestApi(customerId, reportRequestId);
            HashMap<String, Object> result = new HashMap<String, Object>();
            if (status != null) {
                result.put("status", status.getStatus());
                result.put("downloadUrl", status.getDownloadUrl());
                result.put("isSuccess", status.isSuccess());
                result.put("isPending", status.isPending());
                result.put("isError", status.isError());
                return BaseRspUtils.createSuccessRsp(result);
            }
            return BaseRspUtils.createErrorRsp((String)"\u8f6e\u8be2\u62a5\u544a\u72b6\u6001\u5931\u8d25");
        }
        catch (Exception e) {
            log.error("\u6d4b\u8bd5Bing REST API\u8f6e\u8be2\u62a5\u544a\u72b6\u6001\u5f02\u5e38", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)("\u6d4b\u8bd5\u5f02\u5e38: " + e.getMessage()));
        }
    }
}

