/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.api.bo.utils;

import com.tydic.nbchat.user.api.bo.constants.AreaCodeConstants;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class PhoneNumberUtils {
    private static final String CN_PHONE_REGEX = "^1[0-9]{10}$";
    private static final String CN_HK_PHONE_REGEX = "^[5689][0-9]{7}$";
    private static final String CN_MO_PHONE_REGEX = "^6[0-9]{7}$";
    private static final String CN_TW_PHONE_REGEX = "^[09][0-9]{8}$";
    private static final Pattern INTERNATIONAL_PATTERN = Pattern.compile("^\\+?(\\d{1,4})[-\\s]?(.*)$");
    private static final Pattern ZERO_PREFIX_PATTERN = Pattern.compile("^00?(\\d{1,4})(.*)$");
    private static final Map<String, String> PHONE_REGEX_MAP = new HashMap<String, String>();

    public static String normalizePhoneNumber(String phoneNumber) {
        if (StringUtils.isBlank((CharSequence)phoneNumber)) {
            return "";
        }
        String cleanNumber = phoneNumber.replaceAll("[\\s-]", "");
        return cleanNumber;
    }

    public static boolean validPhoneNumber(String phoneNumber) {
        Matcher matcher;
        if (StringUtils.isBlank((CharSequence)phoneNumber)) {
            return false;
        }
        String cleanNumber = PhoneNumberUtils.normalizePhoneNumber(phoneNumber);
        if (cleanNumber.matches(CN_PHONE_REGEX)) {
            return true;
        }
        if (cleanNumber.matches(CN_HK_PHONE_REGEX)) {
            return true;
        }
        if (cleanNumber.matches(CN_MO_PHONE_REGEX)) {
            return true;
        }
        if (cleanNumber.matches(CN_TW_PHONE_REGEX)) {
            return true;
        }
        if (cleanNumber.startsWith("+") && (matcher = INTERNATIONAL_PATTERN.matcher(cleanNumber)).matches()) {
            String areaCode = matcher.group(1);
            String number = matcher.group(2);
            areaCode = areaCode.replaceFirst("^0+", "");
            return PhoneNumberUtils.validateNumberWithAreaCode(areaCode, number);
        }
        if (cleanNumber.matches("^00?\\d{1,4}.*") && (matcher = ZERO_PREFIX_PATTERN.matcher(cleanNumber)).matches()) {
            String areaCode = matcher.group(1);
            String number = matcher.group(2);
            areaCode = areaCode.replaceFirst("^0+", "");
            return PhoneNumberUtils.validateNumberWithAreaCode(areaCode, number);
        }
        if (cleanNumber.length() > 10) {
            for (String knownAreaCode : PHONE_REGEX_MAP.keySet()) {
                if (!cleanNumber.startsWith(knownAreaCode)) continue;
                String number = cleanNumber.substring(knownAreaCode.length());
                return PhoneNumberUtils.validateNumberWithAreaCode(knownAreaCode, number);
            }
        }
        return cleanNumber.matches("^\\d{7,15}$");
    }

    private static boolean validateNumberWithAreaCode(String areaCode, String number) {
        if ("852".equals(areaCode)) {
            return number.matches(CN_HK_PHONE_REGEX);
        }
        if ("853".equals(areaCode)) {
            return number.matches(CN_MO_PHONE_REGEX);
        }
        if ("886".equals(areaCode)) {
            return number.matches(CN_TW_PHONE_REGEX);
        }
        if ("86".equals(areaCode)) {
            return number.matches(CN_PHONE_REGEX);
        }
        String regex = PHONE_REGEX_MAP.get(areaCode);
        if (regex == null) {
            return number.matches("^\\d{7,15}$");
        }
        return number.matches(regex);
    }

    public static String maskPhoneNum(String phoneNum) {
        if (StringUtils.isBlank((CharSequence)phoneNum)) {
            return phoneNum;
        }
        String cleanNumber = PhoneNumberUtils.normalizePhoneNumber(phoneNum);
        String areaCode = PhoneNumberUtils.extractAreaCode(cleanNumber);
        String number = cleanNumber;
        if (cleanNumber.startsWith("+")) {
            matcher = INTERNATIONAL_PATTERN.matcher(cleanNumber);
            if (((Matcher)matcher).matches()) {
                number = ((Matcher)matcher).group(2);
            }
        } else if (cleanNumber.matches("^00?\\d{1,4}.*")) {
            matcher = ZERO_PREFIX_PATTERN.matcher(cleanNumber);
            if (((Matcher)matcher).matches()) {
                number = ((Matcher)matcher).group(2);
            }
        } else if (cleanNumber.length() > 10) {
            for (String knownAreaCode : PHONE_REGEX_MAP.keySet()) {
                if (!cleanNumber.startsWith(knownAreaCode)) continue;
                number = cleanNumber.substring(knownAreaCode.length());
                break;
            }
        } else if (cleanNumber.matches(CN_PHONE_REGEX)) {
            number = cleanNumber;
        } else if (cleanNumber.matches(CN_HK_PHONE_REGEX)) {
            number = cleanNumber;
        } else if (cleanNumber.matches(CN_MO_PHONE_REGEX)) {
            number = cleanNumber;
        } else if (cleanNumber.matches(CN_TW_PHONE_REGEX)) {
            number = cleanNumber;
        }
        Object prefix = "";
        if (phoneNum.startsWith("+")) {
            prefix = "+" + areaCode + " ";
        } else if (phoneNum.startsWith("00")) {
            prefix = "00" + areaCode + " ";
        } else if (phoneNum.startsWith("0")) {
            prefix = "0" + areaCode + " ";
        } else if (!(StringUtils.isBlank((CharSequence)areaCode) || areaCode.equals("86") || cleanNumber.equals(number))) {
            prefix = areaCode + " ";
        }
        if (StringUtils.isBlank((CharSequence)prefix) && number.matches(CN_PHONE_REGEX)) {
            return number.replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2");
        }
        if (StringUtils.isBlank((CharSequence)prefix) && number.matches(CN_HK_PHONE_REGEX)) {
            return number.substring(0, 2) + "****" + number.substring(6);
        }
        if (StringUtils.isBlank((CharSequence)prefix) && number.matches(CN_MO_PHONE_REGEX)) {
            return number.substring(0, 2) + "****" + number.substring(6);
        }
        if (StringUtils.isBlank((CharSequence)prefix) && number.matches(CN_TW_PHONE_REGEX)) {
            return number.substring(0, 2) + "****" + number.substring(6);
        }
        return (String)prefix + PhoneNumberUtils.maskNumberByLength(number);
    }

    private static String maskNumberByLength(String number) {
        int length = number.length();
        if (length <= 4) {
            return number;
        }
        if (length <= 7) {
            int prefixLength = (length - 2) / 2;
            int suffixLength = length - prefixLength - 2;
            return number.substring(0, prefixLength) + "**" + number.substring(prefixLength + 2);
        }
        int prefixLength = (length - 4) / 2;
        int suffixLength = length - prefixLength - 4;
        return number.substring(0, prefixLength) + "****" + number.substring(prefixLength + 4);
    }

    public static String extractAreaCode(String phoneNumber) {
        Matcher matcher;
        if (StringUtils.isBlank((CharSequence)phoneNumber)) {
            return "86";
        }
        String cleanNumber = PhoneNumberUtils.normalizePhoneNumber(phoneNumber);
        if (cleanNumber.matches(CN_PHONE_REGEX)) {
            return "86";
        }
        if (cleanNumber.matches(CN_HK_PHONE_REGEX)) {
            return "852";
        }
        if (cleanNumber.matches(CN_MO_PHONE_REGEX)) {
            return "853";
        }
        if (cleanNumber.matches(CN_TW_PHONE_REGEX)) {
            return "886";
        }
        if (cleanNumber.startsWith("+") && (matcher = INTERNATIONAL_PATTERN.matcher(cleanNumber)).matches()) {
            String areaCode = matcher.group(1);
            areaCode = areaCode.replaceFirst("^0+", "");
            return areaCode;
        }
        if (cleanNumber.matches("^00?\\d{1,4}.*") && (matcher = ZERO_PREFIX_PATTERN.matcher(cleanNumber)).matches()) {
            String areaCode = matcher.group(1);
            areaCode = areaCode.replaceFirst("^0+", "");
            return areaCode;
        }
        if (cleanNumber.length() > 10) {
            for (String knownAreaCode : PHONE_REGEX_MAP.keySet()) {
                if (!cleanNumber.startsWith(knownAreaCode)) continue;
                return knownAreaCode;
            }
        }
        return "86";
    }

    public static String getCountryNameByAreaCode(String areaCode) {
        if (StringUtils.isBlank((CharSequence)areaCode)) {
            return "\u672a\u77e5\u5730\u533a";
        }
        return AreaCodeConstants.COUNTRY_NAME_MAP.getOrDefault(areaCode, "\u672a\u77e5\u5730\u533a");
    }

    static {
        PHONE_REGEX_MAP.put("86", CN_PHONE_REGEX);
        PHONE_REGEX_MAP.put("852", CN_HK_PHONE_REGEX);
        PHONE_REGEX_MAP.put("853", CN_MO_PHONE_REGEX);
        PHONE_REGEX_MAP.put("886", CN_TW_PHONE_REGEX);
        PHONE_REGEX_MAP.put("1", "^[2-9][0-9]{9}$");
    }
}

