/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.busi;

import com.tydic.nbchat.user.api.bo.eums.TradeBusiCodeDefine;
import com.tydic.nbchat.user.api.bo.eums.TradePayType;
import com.tydic.nbchat.user.api.bo.trade.AllocateScoreBO;
import com.tydic.nbchat.user.api.bo.trade.UserBalanceDeductReqBO;
import com.tydic.nbchat.user.api.bo.trade.UserBalanceRechargeReqBO;
import com.tydic.nbchat.user.api.bo.trade.UserTradeResult;
import com.tydic.nbchat.user.core.busi.ScoreDeductService;
import com.tydic.nbchat.user.core.busi.ScoreRechargeService;
import com.tydic.nbchat.user.mapper.NbchatUserScoreDetailMapper;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EnterpriseScoreService {
    private static final Logger log = LoggerFactory.getLogger(EnterpriseScoreService.class);
    @Resource
    private NbchatUserScoreDetailMapper nbchatUserScoreDetailMapper;
    private final ScoreDeductService scoreDeductService;
    private final ScoreRechargeService scoreRechargeService;

    public EnterpriseScoreService(ScoreDeductService scoreDeductService, ScoreRechargeService scoreRechargeService) {
        this.scoreDeductService = scoreDeductService;
        this.scoreRechargeService = scoreRechargeService;
    }

    @Transactional(rollbackFor={Exception.class})
    public Rsp allocate(AllocateScoreBO request) {
        log.info("\u4f01\u4e1a\u79ef\u5206\u5212\u62e8-\u53c2\u6570: {}", (Object)request);
        String tenantCode = request.getTargetTenantCode();
        UserBalanceDeductReqBO deductReqBO = new UserBalanceDeductReqBO();
        deductReqBO.setTenantCode(tenantCode);
        deductReqBO.setUserId(tenantCode);
        deductReqBO.setPayType(TradePayType.ENTERPRISE.getCode());
        deductReqBO.setAmount(Integer.valueOf(1));
        deductReqBO.setBizId(IdWorker.nextAutoIdStr());
        deductReqBO.setBizName("\u7b97\u529b\u70b9\u5145\u503c - \u4f01\u4e1a\u6263\u51cf");
        deductReqBO.setRemark(request.getRemark());
        deductReqBO.setBizCode(TradeBusiCodeDefine.ENTERPRISE_SCORE_ALLOCATE.getCode());
        deductReqBO.setScore(request.getScore());
        Rsp<UserTradeResult> deduct = this.scoreDeductService.deduct(deductReqBO);
        if (deduct.isSuccess()) {
            Date expireTime = this.nbchatUserScoreDetailMapper.selectMaxExpireTime(tenantCode, tenantCode);
            UserBalanceRechargeReqBO rechargeReqBO = new UserBalanceRechargeReqBO();
            rechargeReqBO.setUserId(request.getTargetUid());
            rechargeReqBO.setTenantCode(tenantCode);
            rechargeReqBO.setScore(request.getScore());
            rechargeReqBO.setScoreType("0");
            rechargeReqBO.setRemark(request.getRemark());
            rechargeReqBO.setBizCode(TradeBusiCodeDefine.ENTERPRISE_SCORE_ALLOCATE.getCode());
            rechargeReqBO.setExpireTime(expireTime);
            Rsp<UserTradeResult> recharge = this.scoreRechargeService.recharge(rechargeReqBO);
            if (recharge.isSuccess()) {
                return BaseRspUtils.createSuccessRsp(null);
            }
            log.error("\u4f01\u4e1a\u79ef\u5206\u5212\u62e8-\u5145\u503c\u5931\u8d25: {}", recharge);
            throw new RuntimeException("\u4f01\u4e1a\u79ef\u5206\u5212\u62e8-\u5145\u503c\u5931\u8d25");
        }
        log.error("\u4f01\u4e1a\u79ef\u5206\u5212\u62e8-\u6263\u51cf\u5931\u8d25: {}", deduct);
        return BaseRspUtils.createErrorRsp((String)"\u4f01\u4e1a\u79ef\u5206\u5212\u62e8-\u6263\u51cf\u5931\u8d25");
    }
}

