/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.busi;

import cn.hutool.core.collection.ListUtil;
import com.tydic.nbchat.user.api.bo.eums.UserVipType;
import com.tydic.nbchat.user.mapper.NbchatUserBalanceMapper;
import com.tydic.nbchat.user.mapper.NbchatUserScoreDetailMapper;
import com.tydic.nbchat.user.mapper.NbchatUserVipMapper;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ScoreAccountService {
    private static final Logger log = LoggerFactory.getLogger(ScoreAccountService.class);
    @Resource
    private NbchatUserScoreDetailMapper nbchatUserScoreDetailMapper;
    @Resource
    private NbchatUserBalanceMapper nbchatUserBalanceMapper;
    @Resource
    private NbchatUserVipMapper nbchatUserVipMapper;

    public void freezeScore(String tenantCode, String userId, String scoreType) {
        log.info("\u51bb\u7ed3\u79ef\u5206\uff0c\u5f00\u59cb\u6267\u884c:{}|{}|{}", new Object[]{tenantCode, userId, scoreType});
        try {
            List scoreTypes = ListUtil.reverse((List)UserVipType.getVipsUpTo((String)scoreType));
            for (String type : scoreTypes) {
                int var = this.nbchatUserVipMapper.checkVipByType(userId, type);
                if (var != 0) continue;
                this.nbchatUserScoreDetailMapper.freezeScore(tenantCode, userId, type);
            }
            int count = this.nbchatUserVipMapper.checkValidVip(new Date(), userId);
            if (count == 0) {
                this.nbchatUserScoreDetailMapper.freezeScore(tenantCode, userId, "0");
            }
            this.nbchatUserBalanceMapper.updateBalance(tenantCode, userId);
        }
        catch (Exception e) {
            log.error("\u51bb\u7ed3\u79ef\u5206\uff0c\u6267\u884c\u5f02\u5e38:tenantCode={},userId={}", new Object[]{tenantCode, userId, e});
        }
    }

    public void unfreezeScore(String tenantCode, String userId, String scoreType) {
        log.info("\u89e3\u51bb\u79ef\u5206\uff0c\u5f00\u59cb\u6267\u884c:{}|{}|{}", new Object[]{tenantCode, userId, scoreType});
        try {
            if (UserVipType.isProfessional((String)scoreType)) {
                scoreType = UserVipType.PROFESSIONAL_MAX.getCode();
            }
            List scoreTypes = UserVipType.getVipsUpTo((String)scoreType);
            for (String type : scoreTypes) {
                this.nbchatUserScoreDetailMapper.unfreezeScore(tenantCode, userId, type);
            }
            if (CollectionUtils.isNotEmpty((Collection)scoreTypes)) {
                this.nbchatUserScoreDetailMapper.unfreezeScore(tenantCode, userId, "0");
            }
            this.nbchatUserBalanceMapper.updateBalance(tenantCode, userId);
        }
        catch (Exception e) {
            log.error("\u89e3\u51bb\u79ef\u5206\uff0c\u6267\u884c\u5f02\u5e38:tenantCode={},userId={}", new Object[]{tenantCode, userId, e});
        }
    }
}

