/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.user.core.busi;

import com.tydic.nbchat.user.api.bo.eums.ScoreStatusType;
import com.tydic.nbchat.user.api.bo.eums.TradeType;
import com.tydic.nbchat.user.api.bo.trade.UserBalanceAccountReqBO;
import com.tydic.nbchat.user.api.bo.trade.UserBalanceBO;
import com.tydic.nbchat.user.api.bo.trade.UserScoreDetailBO;
import com.tydic.nbchat.user.core.busi.UserMakeEventSender;
import com.tydic.nbchat.user.core.config.NbchatUserConfigProperties;
import com.tydic.nbchat.user.mapper.NbchatUserBalanceMapper;
import com.tydic.nbchat.user.mapper.NbchatUserBillRecordMapper;
import com.tydic.nbchat.user.mapper.NbchatUserScoreDetailMapper;
import com.tydic.nbchat.user.mapper.po.NbchatUserBalance;
import com.tydic.nbchat.user.mapper.po.NbchatUserBillRecord;
import com.tydic.nbchat.user.mapper.po.NbchatUserScoreDetail;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScoreBalanceService {
    private static final Logger log = LoggerFactory.getLogger(ScoreBalanceService.class);
    @Resource
    private NbchatUserBalanceMapper nbchatUserBalanceMapper;
    @Resource
    private NbchatUserBillRecordMapper nbchatUserBillRecordMapper;
    @Resource
    private NbchatUserScoreDetailMapper nbchatUserScoreDetailMapper;
    @Resource
    private UserMakeEventSender userMakeEventSender;
    private final NbchatUserConfigProperties nbchatUserConfigProperties;

    public ScoreBalanceService(NbchatUserConfigProperties nbchatUserConfigProperties) {
        this.nbchatUserConfigProperties = nbchatUserConfigProperties;
    }

    public Rsp<UserBalanceBO> getBalance(String tenantCode, String userId) {
        log.info("\u67e5\u8be2\u7528\u6237\u4f59\u989d: {}|{}", (Object)tenantCode, (Object)userId);
        NbchatUserBalance balance = this.nbchatUserBalanceMapper.selectByUserId(tenantCode, userId);
        if (balance != null) {
            UserBalanceBO userBalanceBO = new UserBalanceBO();
            userBalanceBO.setUserId(userId);
            userBalanceBO.setTenantCode(tenantCode);
            userBalanceBO.setScore(balance.getScore());
            userBalanceBO.setUpdateTime(balance.getUpdateTime());
            List scoreDetails = this.nbchatUserScoreDetailMapper.selectByUserId(balance.getTenantCode(), balance.getUserId(), null);
            if (CollectionUtils.isEmpty((Collection)scoreDetails)) {
                log.warn("\u8d26\u6237\u660e\u7ec6\u4e0d\u5b58\u5728: {}|{}", (Object)tenantCode, (Object)userId);
            }
            ArrayList details = Lists.newArrayList();
            NiccCommonUtil.copyList((List)scoreDetails, (List)details, UserScoreDetailBO.class);
            userBalanceBO.setDetails((List)details);
            return BaseRspUtils.createSuccessRsp((Object)userBalanceBO);
        }
        return BaseRspUtils.createErrorRsp((String)"\u8d26\u6237\u4e0d\u5b58\u5728");
    }

    @Transactional(rollbackFor={Exception.class})
    public Rsp createBalanceAccount(UserBalanceAccountReqBO accountReqBO) {
        NbchatUserBalance balance = this.nbchatUserBalanceMapper.selectByUserId(accountReqBO.getTenantCode(), accountReqBO.getUserId());
        log.info("\u521b\u5efa\u8d26\u6237-\u53c2\u6570: {}", (Object)accountReqBO);
        if (balance == null) {
            if (accountReqBO.getScore() == null) {
                if (accountReqBO.getTenantCode().equals("00000000")) {
                    accountReqBO.setScore(this.nbchatUserConfigProperties.getNewUserDou());
                } else if (accountReqBO.getTenantCode().equals(accountReqBO.getUserId())) {
                    accountReqBO.setScore(Integer.valueOf(0));
                } else {
                    accountReqBO.setScore(Integer.valueOf(0));
                }
            }
            balance = new NbchatUserBalance();
            balance.setTenantCode(accountReqBO.getTenantCode());
            balance.setUserId(accountReqBO.getUserId());
            balance.setScore(accountReqBO.getScore());
            balance.setPpScore(accountReqBO.getScore());
            balance.setCreateTime(new Date());
            balance.setUpdateTime(new Date());
            this.nbchatUserBalanceMapper.insertSelective(balance);
            if (accountReqBO.getScore() > 0) {
                NbchatUserScoreDetail detail = new NbchatUserScoreDetail();
                detail.setTenantCode(accountReqBO.getTenantCode());
                detail.setUserId(accountReqBO.getUserId());
                detail.setScore(accountReqBO.getScore());
                detail.setCreateTime(new Date());
                detail.setUpdateTime(new Date());
                Date date = DateTimeUtil.DateAddDayOfYear((int)31);
                detail.setExpireTime(DateTimeUtil.createTime((Date)date, (int)23, (int)59, (int)59));
                detail.setScoreStatus(ScoreStatusType.VALID.getCode());
                detail.setScoreDesc("\u65b0\u7528\u6237\u8d60\u9001");
                this.nbchatUserScoreDetailMapper.insertSelective(detail);
                NbchatUserBillRecord record = new NbchatUserBillRecord();
                record.setTenantCode(accountReqBO.getTenantCode());
                record.setUserId(accountReqBO.getUserId());
                record.setScore(accountReqBO.getScore());
                record.setType(TradeType.RECHARGE.getCode());
                record.setRemark("\u65b0\u7528\u6237\u8d60\u9001");
                record.setTradeTime(new Date());
                this.nbchatUserBillRecordMapper.insertSelective(record);
            }
            return this.getBalance(accountReqBO.getTenantCode(), accountReqBO.getUserId());
        }
        return BaseRspUtils.createErrorRsp((String)"\u8d26\u6237\u5df2\u5b58\u5728");
    }
}

